/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.EvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class LanchesterEvaluationFunction
extends EvaluationFunction {
    public static float[] W_BASE = new float[]{0.12900642f, 0.48944974f};
    public static float[] W_RAX = new float[]{0.23108198f, 0.55022866f};
    public static float[] W_WORKER = new float[]{0.18122299f, -0.007851469f};
    public static float[] W_LIGHT = new float[]{1.7496678f, 0.12587242f};
    public static float[] W_RANGE = new float[]{1.679384f, 0.029918374f};
    public static float[] W_HEAVY = new float[]{3.9012442f, 0.1641424f};
    public static float[] W_MINERALS_CARRIED = new float[]{0.35662296f, 0.010614901f};
    public static float[] W_MINERALS_MINED = new float[]{0.30141655f, 0.38643843f};
    public static float order = 1.7f;

    public static float sigmoid(float x) {
        return (float)(1.0 / (1.0 + Math.pow(Math.E, 0.0f - x)));
    }

    @Override
    public float evaluate(int maxplayer, int minplayer, GameState gs) {
        return 2.0f * LanchesterEvaluationFunction.sigmoid(this.base_score(maxplayer, gs) - this.base_score(minplayer, gs)) - 1.0f;
    }

    public float base_score(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int index = 0;
        if (pgs.getWidth() == 128) {
            index = 1;
        }
        float score = 0.0f;
        float score_buildings = 0.0f;
        float nr_units = 0.0f;
        float res_carried = 0.0f;
        UnitTypeTable utt = gs.getUnitTypeTable();
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player) continue;
            res_carried += (float)u.getResources();
            if (u.getType() == utt.getUnitType("Base")) {
                score_buildings += W_BASE[index] * (float)u.getHitPoints();
                continue;
            }
            if (u.getType() == utt.getUnitType("Barracks")) {
                score_buildings += W_RAX[index] * (float)u.getHitPoints();
                continue;
            }
            if (u.getType() == utt.getUnitType("Worker")) {
                nr_units += 1.0f;
                score += W_WORKER[index] * (float)u.getHitPoints();
                continue;
            }
            if (u.getType() == utt.getUnitType("Light")) {
                nr_units += 1.0f;
                score += W_LIGHT[index] * (float)u.getHitPoints() / (float)u.getMaxHitPoints();
                continue;
            }
            if (u.getType() == utt.getUnitType("Ranged")) {
                nr_units += 1.0f;
                score += W_RANGE[index] * (float)u.getHitPoints();
                continue;
            }
            if (u.getType() != utt.getUnitType("Heavy")) continue;
            nr_units += 1.0f;
            score += W_HEAVY[index] * (float)u.getHitPoints() / (float)u.getMaxHitPoints();
        }
        score = (float)((double)score * Math.pow(nr_units, order - 1.0f));
        return score += score_buildings + res_carried * W_MINERALS_CARRIED[index] + (float)gs.getPlayer(player).getResources() * W_MINERALS_MINED[index];
    }

    @Override
    public float upperBound(GameState gs) {
        return 2.0f;
    }
}

