/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.SimpleEvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;

public class SimpleOptEvaluationFunction
extends SimpleEvaluationFunction {
    public static float RESOURCE = 0.19059792f;
    public static float RESOURCE_IN_WORKER = 0.6051353f;
    public static float UNIT_BONUS_MULTIPLIER = 0.30983886f;

    @Override
    public float evaluate(int maxplayer, int minplayer, GameState gs) {
        return this.base_score(maxplayer, gs) - this.base_score(minplayer, gs);
    }

    @Override
    public float base_score(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        float score = (float)gs.getPlayer(player).getResources() * RESOURCE;
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player) continue;
            score += (float)u.getResources() * RESOURCE_IN_WORKER;
            score += UNIT_BONUS_MULTIPLIER * (float)(u.getCost() * u.getHitPoints()) / (float)u.getMaxHitPoints();
        }
        return score;
    }

    @Override
    public float upperBound(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int free_resources = 0;
        int[] player_resources = new int[]{gs.getPlayer(0).getResources(), gs.getPlayer(1).getResources()};
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() == -1) {
                free_resources += u.getResources();
            }
            if (u.getPlayer() == 0) {
                player_resources[0] = player_resources[0] + u.getResources();
                player_resources[0] = player_resources[0] + u.getCost();
            }
            if (u.getPlayer() != 1) continue;
            player_resources[1] = player_resources[1] + u.getResources();
            player_resources[1] = player_resources[1] + u.getCost();
        }
        return (float)(free_resources + Math.max(player_resources[0], player_resources[1])) * UNIT_BONUS_MULTIPLIER;
    }
}

