/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.EvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;

public class SimpleSqrtEvaluationFunction2
extends EvaluationFunction {
    public static float RESOURCE = 20.0f;
    public static float RESOURCE_IN_WORKER = 10.0f;
    public static float UNIT_BONUS_MULTIPLIER = 40.0f;

    @Override
    public float evaluate(int maxplayer, int minplayer, GameState gs) {
        float s1 = this.base_score(maxplayer, gs);
        float s2 = this.base_score(minplayer, gs);
        if (s1 == 0.0f && s2 != 0.0f) {
            return -VICTORY;
        }
        if (s1 != 0.0f && s2 == 0.0f) {
            return VICTORY;
        }
        return s1 - s2;
    }

    public float base_score(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        float score = (float)gs.getPlayer(player).getResources() * RESOURCE;
        boolean anyunit = false;
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player) continue;
            anyunit = true;
            score += (float)u.getResources() * RESOURCE_IN_WORKER;
            score = (float)((double)score + (double)UNIT_BONUS_MULTIPLIER * ((double)u.getCost() * Math.sqrt(u.getHitPoints()) / (double)u.getMaxHitPoints()));
        }
        if (!anyunit) {
            return 0.0f;
        }
        return score;
    }

    @Override
    public float upperBound(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int free_resources = 0;
        int[] player_resources = new int[]{gs.getPlayer(0).getResources(), gs.getPlayer(1).getResources()};
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() == -1) {
                free_resources += u.getResources();
            }
            if (u.getPlayer() == 0) {
                player_resources[0] = player_resources[0] + u.getResources();
                player_resources[0] = player_resources[0] + u.getCost();
            }
            if (u.getPlayer() != 1) continue;
            player_resources[1] = player_resources[1] + u.getResources();
            player_resources[1] = player_resources[1] + u.getCost();
        }
        return (float)(free_resources + Math.max(player_resources[0], player_resources[1])) * UNIT_BONUS_MULTIPLIER;
    }
}

