/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.EvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;

public class SimpleSqrtEvaluationFunction3
extends EvaluationFunction {
    public static float RESOURCE = 20.0f;
    public static float RESOURCE_IN_WORKER = 10.0f;
    public static float UNIT_BONUS_MULTIPLIER = 40.0f;

    @Override
    public float evaluate(int maxplayer, int minplayer, GameState gs) {
        float s2;
        float s1 = this.base_score(maxplayer, gs);
        if (s1 + (s2 = this.base_score(minplayer, gs)) == 0.0f) {
            return 0.5f;
        }
        return 2.0f * s1 / (s1 + s2) - 1.0f;
    }

    public float base_score(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        float score = (float)gs.getPlayer(player).getResources() * RESOURCE;
        boolean anyunit = false;
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player) continue;
            anyunit = true;
            score += (float)u.getResources() * RESOURCE_IN_WORKER;
            score = (float)((double)score + (double)(UNIT_BONUS_MULTIPLIER * (float)u.getCost()) * Math.sqrt(u.getHitPoints() / u.getMaxHitPoints()));
        }
        if (!anyunit) {
            return 0.0f;
        }
        return score;
    }

    @Override
    public float upperBound(GameState gs) {
        return 1.0f;
    }
}

