/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes;

import ai.machinelearning.bayes.BayesianModel;
import ai.machinelearning.bayes.DiscreteCPD;
import ai.machinelearning.bayes.FeatureSelection;
import ai.machinelearning.bayes.TrainingInstance;
import ai.machinelearning.bayes.featuregeneration.FeatureGenerator;
import ai.machinelearning.bayes.featuregeneration.FeatureGeneratorComplex;
import ai.machinelearning.bayes.featuregeneration.FeatureGeneratorEmpty;
import ai.machinelearning.bayes.featuregeneration.FeatureGeneratorSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class CalibratedNaiveBayes
extends BayesianModel {
    int estimationMethod = 1;
    double calibrationFactor = 0.0;
    double[] prior_distribution;
    DiscreteCPD[] distributions;
    boolean[] selectedFeatures;
    int Ysize = 0;
    int[] Xsizes;

    public CalibratedNaiveBayes(int[] a_Xsizes, int a_Ysize, int estimation, double a_correctionFactor, UnitTypeTable utt, FeatureGenerator fg, String a_name) {
        super(utt, fg, a_name);
        this.Ysize = a_Ysize;
        this.Xsizes = a_Xsizes;
        this.estimationMethod = estimation;
        this.calibrationFactor = a_correctionFactor;
        this.clearTraining();
    }

    @Override
    public Object clone() {
        CalibratedNaiveBayes c = new CalibratedNaiveBayes(this.Xsizes, this.Ysize, this.estimationMethod, this.calibrationFactor, this.utt, this.featureGenerator, this.name);
        return c;
    }

    @Override
    public void clearTraining() {
        int nfeatures = this.Xsizes.length;
        this.distributions = new DiscreteCPD[nfeatures];
        for (int i = 0; i < nfeatures; ++i) {
            this.distributions[i] = new DiscreteCPD(this.Ysize, this.Xsizes[i]);
        }
    }

    @Override
    public void train(List<int[]> x_l, List<Integer> y_l, List<TrainingInstance> i_l) throws Exception {
        int i;
        int nfeatures = this.distributions.length;
        this.prior_distribution = new double[this.Ysize];
        for (i = 0; i < x_l.size(); ++i) {
            int y;
            int[] x = x_l.get(i);
            int n = y = y_l.get(i).intValue();
            this.prior_distribution[n] = this.prior_distribution[n] + 1.0;
            for (int j = 0; j < nfeatures; ++j) {
                this.distributions[j].addObservation(y, x[j]);
            }
        }
        if (this.estimationMethod == 1) {
            i = 0;
            while (i < this.Ysize) {
                int n = i++;
                this.prior_distribution[n] = this.prior_distribution[n] / (double)x_l.size();
            }
        } else {
            for (i = 0; i < this.Ysize; ++i) {
                this.prior_distribution[i] = (this.prior_distribution[i] + 1.0) / (double)(x_l.size() + this.Ysize);
            }
        }
    }

    @Override
    public void calibrateProbabilities(List<int[]> x_l, List<Integer> y_l, List<TrainingInstance> i_l) throws Exception {
        double best_c = 0.0;
        double best_ll = Double.NEGATIVE_INFINITY;
        for (double c = 0.0; c <= 1.05; c += 0.05) {
            this.calibrationFactor = c;
            double loglikelihood = 0.0;
            for (int i = 0; i < x_l.size(); ++i) {
                Unit u = i_l.get((int)i).u;
                List<UnitAction> possibleUnitActions = u.getUnitActions(i_l.get((int)i).gs);
                ArrayList<Integer> possibleUnitActionIndexes = new ArrayList<Integer>();
                for (UnitAction ua : possibleUnitActions) {
                    int idx;
                    if (ua.getType() == 5) {
                        ua = new UnitAction(5, ua.getLocationX() - u.getX(), ua.getLocationY() - u.getY());
                    }
                    if ((idx = this.allPossibleActions.indexOf(ua)) < 0) {
                        throw new Exception("Unknown action: " + ua);
                    }
                    possibleUnitActionIndexes.add(idx);
                }
                if (possibleUnitActions.size() <= 1) continue;
                double[] predicted_distribution = this.predictDistribution(x_l.get(i), i_l.get(i));
                predicted_distribution = this.filterByPossibleActionIndexes(predicted_distribution, possibleUnitActionIndexes);
                int actual_y = y_l.get(i);
                if (!possibleUnitActionIndexes.contains(actual_y)) continue;
                int predicted_y = -1;
                Collections.shuffle(possibleUnitActions);
                Iterator iterator = possibleUnitActionIndexes.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (predicted_y == -1) {
                        predicted_y = idx;
                        continue;
                    }
                    if (!(predicted_distribution[idx] > predicted_distribution[predicted_y])) continue;
                    predicted_y = idx;
                }
                double ll = Math.log(predicted_distribution[actual_y]);
                if (Double.isInfinite(ll)) {
                    System.out.println(Arrays.toString(predicted_distribution));
                    System.out.println(possibleUnitActionIndexes);
                    System.out.println(actual_y + " : " + this.allPossibleActions.get(actual_y));
                    System.exit(1);
                }
                loglikelihood += ll;
            }
            if (!(loglikelihood > best_ll)) break;
            best_c = c;
            best_ll = loglikelihood;
        }
        System.out.println("best calibration factor = " + best_c);
        this.calibrationFactor = best_c;
    }

    @Override
    public void featureSelectionByGainRatio(List<int[]> x_l, List<Integer> y_l, double fractionOfFeaturesToKeep) {
        int i;
        ArrayList<Integer> featureIndexes = new ArrayList<Integer>();
        final ArrayList<Double> featureGR = new ArrayList<Double>();
        int nfeatures = this.distributions.length;
        this.selectedFeatures = new boolean[nfeatures];
        for (i = 0; i < nfeatures; ++i) {
            featureIndexes.add(i);
            featureGR.add(FeatureSelection.featureGainRatio(x_l, y_l, i));
            this.selectedFeatures[i] = false;
        }
        featureIndexes.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare((Double)featureGR.get(o2), (Double)featureGR.get(o1));
            }
        });
        i = 0;
        while ((double)i < fractionOfFeaturesToKeep * (double)nfeatures) {
            this.selectedFeatures[((Integer)featureIndexes.get((int)i)).intValue()] = true;
            ++i;
        }
    }

    @Override
    public double[] predictDistribution(int[] x, TrainingInstance ti) {
        return this.predictDistribution(x, ti, this.calibrationFactor);
    }

    public double[] predictDistribution(int[] x, TrainingInstance ti, double correction) {
        int i;
        double[] d = new double[this.Ysize];
        for (int i2 = 0; i2 < this.Ysize; ++i2) {
            d[i2] = this.prior_distribution == null ? 1.0 : this.prior_distribution[i2];
        }
        double n_used_features = 1.0;
        for (int i3 = 0; i3 < x.length; ++i3) {
            double[] d2;
            int j;
            if (this.selectedFeatures != null && !this.selectedFeatures[i3]) continue;
            n_used_features += 1.0;
            if (this.estimationMethod == 1) {
                j = 0;
                while (j < this.Ysize) {
                    d2 = this.distributions[i3].distribution(j);
                    int n = j++;
                    d[n] = d[n] * d2[x[i3]];
                }
                continue;
            }
            j = 0;
            while (j < this.Ysize) {
                d2 = this.distributions[i3].distributionLaplace(j, 1.0);
                double v = 1.0;
                v = d2.length > x[i3] ? d2[x[i3]] : 1.0 / (double)this.Ysize;
                int n = j++;
                d[n] = d[n] * v;
            }
        }
        double accum = 0.0;
        for (i = 0; i < this.Ysize; ++i) {
            d[i] = Math.pow(d[i], 1.0 / (1.0 * (1.0 - correction) + n_used_features * correction));
            accum += d[i];
        }
        if (accum <= 0.0) {
            for (i = 0; i < this.Ysize; ++i) {
                d[i] = 1.0 / (double)this.Ysize;
            }
        } else {
            i = 0;
            while (i < this.Ysize) {
                int n = i++;
                d[n] = d[n] / accum;
            }
        }
        return d;
    }

    @Override
    public void save(XMLWriter w) throws Exception {
        w.tagWithAttributes(this.getClass().getSimpleName(), "estimationMethod=\"" + this.estimationMethod + "\" Ysize=\"" + this.Ysize + "\" calibrationFactor=\"" + this.calibrationFactor + "\" nfeatures=\"" + this.distributions.length + "\" featureGenerationClass=\"" + this.featureGenerator.getClass().getSimpleName() + "\"");
        w.tag("Xsizes");
        for (int n : this.Xsizes) {
            w.rawXML(n + " ");
        }
        w.rawXML("\n");
        w.tag("/Xsizes");
        w.tag("priorDistribution");
        for (double d : this.prior_distribution) {
            w.rawXML(d + " ");
        }
        w.rawXML("\n");
        w.tag("/priorDistribution");
        if (this.selectedFeatures != null) {
            w.tag("selectedFeatures");
            for (boolean bl : this.selectedFeatures) {
                w.rawXML(bl + " ");
            }
            w.rawXML("\n");
            w.tag("/selectedFeatures");
        }
        for (DiscreteCPD discreteCPD : this.distributions) {
            discreteCPD.save(w);
        }
        w.tag("/SimpleNaiveBayes");
        w.flush();
    }

    public CalibratedNaiveBayes(Element e, UnitTypeTable utt, String a_name) throws Exception {
        super(utt, null, a_name);
        this.load(e);
    }

    @Override
    public void load(Element e) throws Exception {
        if (!e.getName().equals(this.getClass().getSimpleName())) {
            throw new Exception("Head tag is not 'SimpleNaiveBayes'!");
        }
        String fgclass = e.getAttributeValue("featureGenerationClass");
        if (fgclass.contains("FeatureGeneratorEmpty")) {
            this.featureGenerator = new FeatureGeneratorEmpty();
        } else if (fgclass.contains("FeatureGeneratorSimple")) {
            this.featureGenerator = new FeatureGeneratorSimple();
        } else if (fgclass.contains("FeatureGeneratorComplex")) {
            this.featureGenerator = new FeatureGeneratorComplex();
        }
        this.estimationMethod = Integer.parseInt(e.getAttributeValue("estimationMethod"));
        this.Ysize = Integer.parseInt(e.getAttributeValue("Ysize"));
        int nfeatures = Integer.parseInt(e.getAttributeValue("nfeatures"));
        this.calibrationFactor = Double.parseDouble(e.getAttributeValue("calibrationFactor"));
        Element xs_xml = e.getChild("Xsizes");
        String text = xs_xml.getTextTrim();
        String[] tokens = text.split(" ");
        this.Xsizes = new int[nfeatures];
        for (int i = 0; i < nfeatures; ++i) {
            this.Xsizes[i] = Integer.parseInt(tokens[i]);
        }
        Element pd_xml = e.getChild("priorDistribution");
        String text2 = pd_xml.getTextTrim();
        String[] tokens2 = text2.split(" ");
        this.prior_distribution = new double[this.Ysize];
        for (int i = 0; i < this.Ysize; ++i) {
            this.prior_distribution[i] = Double.parseDouble(tokens2[i]);
        }
        Element sf_xml = e.getChild("selectedFeatures");
        if (sf_xml != null) {
            String text3 = sf_xml.getTextTrim();
            String[] tokens3 = text3.split(" ");
            this.selectedFeatures = new boolean[nfeatures];
            for (int i = 0; i < nfeatures; ++i) {
                this.selectedFeatures[i] = Boolean.parseBoolean(tokens3[i]);
            }
        } else {
            this.selectedFeatures = null;
        }
        this.distributions = new DiscreteCPD[nfeatures];
        List cpd_xml_l = e.getChildren("DiscreteCPD");
        for (int i = 0; i < nfeatures; ++i) {
            Element cpd_xml = (Element)cpd_xml_l.get(i);
            this.distributions[i] = new DiscreteCPD(cpd_xml);
        }
    }

    @Override
    public void featureSelectionByCrossValidation(List<int[]> x_l, List<Integer> y_l, List<TrainingInstance> i_l) throws Exception {
        boolean change;
        int nfeatures = this.distributions.length;
        System.out.println("featureSelectionByCrossValidation " + x_l.size());
        boolean[] bestSelection = new boolean[nfeatures];
        for (int i = 0; i < nfeatures; ++i) {
            bestSelection[i] = false;
        }
        this.selectedFeatures = bestSelection;
        double best_score = (Double)FeatureSelection.crossValidation((BayesianModel)this, x_l, y_l, i_l, (List<UnitAction>)this.allPossibleActions, (int)10).m_a;
        System.out.println("  loglikelihood with " + Arrays.toString(this.selectedFeatures) + ": " + best_score);
        do {
            change = false;
            boolean[] bestLastSelection = bestSelection;
            for (int i = 0; i < nfeatures; ++i) {
                if (bestSelection[i]) continue;
                boolean[] currentSelection = new boolean[nfeatures];
                System.arraycopy(bestSelection, 0, currentSelection, 0, nfeatures);
                currentSelection[i] = true;
                this.selectedFeatures = currentSelection;
                double score = (Double)FeatureSelection.crossValidation((BayesianModel)this, x_l, y_l, i_l, (List<UnitAction>)this.allPossibleActions, (int)10).m_a;
                System.out.println("  loglikelihood with " + Arrays.toString(this.selectedFeatures) + ": " + score);
                if (!(score > best_score)) continue;
                bestLastSelection = currentSelection;
                best_score = score;
                change = true;
            }
            bestSelection = bestLastSelection;
        } while (change);
        this.selectedFeatures = bestSelection;
        System.out.println("Selected features: " + Arrays.toString(this.selectedFeatures));
    }
}

