/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes;

import org.jdom.Element;
import util.XMLWriter;

public class DiscreteCPD {
    public int Xvalues = 0;
    public int Yvalues = 0;
    public int[][] counts;

    public DiscreteCPD(int nX, int nY) {
        this.Xvalues = nX;
        this.Yvalues = nY;
        this.counts = new int[nX][nY];
    }

    public void addObservation(int X, int Y) {
        int[] nArray = this.counts[X];
        int n = Y;
        nArray[n] = nArray[n] + 1;
    }

    public int[] marginalizedCounts() {
        int[] marginalizedCounts = new int[this.Yvalues];
        for (int i = 0; i < this.Xvalues; ++i) {
            for (int j = 0; j < this.Yvalues; ++j) {
                int n = j;
                marginalizedCounts[n] = marginalizedCounts[n] + this.counts[i][j];
            }
        }
        return marginalizedCounts;
    }

    public double[] marginalizedDistribution() {
        int i;
        int[] marginalizedCounts = this.marginalizedCounts();
        double[] distribution = new double[this.Yvalues];
        int accum = 0;
        for (i = 0; i < this.Yvalues; ++i) {
            accum += marginalizedCounts[i];
        }
        for (i = 0; i < this.Yvalues; ++i) {
            distribution[i] = (double)marginalizedCounts[i] / (double)accum;
        }
        return distribution;
    }

    public double[] marginalizedDistributionLaplace(double beta) {
        int i;
        int[] marginalizedCounts = this.marginalizedCounts();
        double[] distribution = new double[this.Yvalues];
        int accum = 0;
        for (i = 0; i < this.Yvalues; ++i) {
            accum += marginalizedCounts[i];
        }
        for (i = 0; i < this.Yvalues; ++i) {
            distribution[i] = ((double)marginalizedCounts[i] + beta) / ((double)accum + beta * (double)this.Yvalues);
        }
        return distribution;
    }

    public double[] distribution(int Xvalue) {
        int i;
        double[] distribution = new double[this.Yvalues];
        if (Xvalue >= this.Xvalues) {
            for (int i2 = 0; i2 < this.Yvalues; ++i2) {
                distribution[i2] = 1.0 / (double)this.Yvalues;
            }
            return distribution;
        }
        int accum = 0;
        for (i = 0; i < this.Yvalues; ++i) {
            accum += this.counts[Xvalue][i];
        }
        for (i = 0; i < this.Yvalues; ++i) {
            distribution[i] = (double)this.counts[Xvalue][i] / (double)accum;
        }
        return distribution;
    }

    public double[] distributionLaplace(int Xvalue, double beta) {
        int i;
        double[] distribution = new double[this.Yvalues];
        if (Xvalue >= this.Xvalues) {
            for (int i2 = 0; i2 < this.Yvalues; ++i2) {
                distribution[i2] = 1.0 / (double)this.Yvalues;
            }
            return distribution;
        }
        int accum = 0;
        for (i = 0; i < this.Yvalues; ++i) {
            accum += this.counts[Xvalue][i];
        }
        for (i = 0; i < this.Yvalues; ++i) {
            distribution[i] = ((double)this.counts[Xvalue][i] + beta) / ((double)accum + beta * (double)this.Yvalues);
        }
        return distribution;
    }

    public void save(XMLWriter w) throws Exception {
        w.tagWithAttributes("DiscreteCPD", "Xvalues=\"" + this.Xvalues + "\" Yvalues=\"" + this.Yvalues + "\"");
        for (int i = 0; i < this.Xvalues; ++i) {
            for (int j = 0; j < this.Yvalues; ++j) {
                w.rawXML(this.counts[i][j] + " ");
            }
            w.rawXML("\n");
        }
        w.tag("/DiscreteCPD");
    }

    public DiscreteCPD(Element e) throws Exception {
        if (!e.getName().equals("DiscreteCPD")) {
            throw new Exception("Head tag is not 'DiscreteCPD'!");
        }
        this.Xvalues = Integer.parseInt(e.getAttributeValue("Xvalues"));
        this.Yvalues = Integer.parseInt(e.getAttributeValue("Yvalues"));
        this.counts = new int[this.Xvalues][this.Yvalues];
        String text = e.getTextTrim();
        String[] tokens = text.split(" |\n");
        int k = 0;
        for (int i = 0; i < this.Xvalues; ++i) {
            int j = 0;
            while (j < this.Yvalues) {
                while (tokens[k].equals("")) {
                    ++k;
                }
                this.counts[i][j] = Integer.parseInt(tokens[k]);
                ++j;
                ++k;
            }
        }
    }
}

