/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes;

import ai.machinelearning.bayes.BayesianModel;
import ai.machinelearning.bayes.TrainingInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;

public class FeatureSelection {
    public static int DEBUG = 0;

    public static double featureSetCrossValidationAccuracy(BayesianModel model, List<int[]> X_l, List<Integer> Y_l, List<TrainingInstance> instances, List<UnitAction> allPossibleActions, List<Integer> features) throws Exception {
        ArrayList<int[]> X_reduced_l = new ArrayList<int[]>();
        for (int[] x : X_l) {
            int[] x_reduced = new int[features.size()];
            for (int i = 0; i < features.size(); ++i) {
                x_reduced[i] = x[features.get(i)];
            }
            X_reduced_l.add(x_reduced);
        }
        double accuracy = (Double)FeatureSelection.crossValidation((BayesianModel)model, X_l, Y_l, instances, allPossibleActions, (int)10).m_a;
        return accuracy;
    }

    public static double featureGainRatio(List<int[]> X_l, List<Integer> Y_l, int feature) {
        int i;
        int n_x_values = 0;
        int n_y_values = 0;
        for (int i2 = 0; i2 < X_l.size(); ++i2) {
            if (X_l.get(i2)[feature] >= n_x_values) {
                n_x_values = X_l.get(i2)[feature] + 1;
            }
            if (Y_l.get(i2) < n_y_values) continue;
            n_y_values = Y_l.get(i2) + 1;
        }
        int[] x_distribution = new int[n_x_values];
        List[] y_x_distributions = new List[n_x_values];
        for (i = 0; i < n_x_values; ++i) {
            y_x_distributions[i] = new ArrayList();
        }
        for (i = 0; i < X_l.size(); ++i) {
            int x;
            int n = x = X_l.get(i)[feature];
            x_distribution[n] = x_distribution[n] + 1;
            y_x_distributions[x].add(Y_l.get(i));
        }
        double H = FeatureSelection.entropy(Y_l, n_y_values);
        double[] H_x = new double[n_x_values];
        for (int i3 = 0; i3 < n_x_values; ++i3) {
            H_x[i3] = x_distribution[i3] > 0 ? FeatureSelection.entropy(y_x_distributions[i3], n_y_values) : 0.0;
        }
        double information_gain = H;
        double intrinsic_value = 0.0;
        for (int i4 = 0; i4 < n_x_values; ++i4) {
            double x_ratio = (double)x_distribution[i4] / (double)X_l.size();
            information_gain -= x_ratio * H_x[i4];
            if (x_distribution[i4] <= 0) continue;
            intrinsic_value -= x_ratio * Math.log(x_ratio) / Math.log(2.0);
        }
        double information_gain_ratio = intrinsic_value > 0.0 ? information_gain / intrinsic_value : 0.0;
        return information_gain_ratio;
    }

    public static double entropy(List<Integer> l, int nValues) {
        int[] histogram = new int[nValues];
        double total = 0.0;
        Iterator<Integer> iterator = l.iterator();
        while (iterator.hasNext()) {
            int v;
            int n = v = iterator.next().intValue();
            histogram[n] = histogram[n] + 1;
            total += 1.0;
        }
        double h = 0.0;
        for (int i = 0; i < nValues; ++i) {
            double p = (double)histogram[i] / total;
            if (histogram[i] <= 0) continue;
            h += -p * Math.log(p) / Math.log(2.0);
        }
        return h;
    }

    public static Pair<Double, Double> crossValidation(BayesianModel model, List<int[]> X_l, List<Integer> Y_l, List<TrainingInstance> instances, List<UnitAction> allPossibleActions, int nfolds) throws Exception {
        int i;
        int i2;
        Random r = new Random();
        List[] folds = new List[nfolds];
        int nfeatures = X_l.get(0).length;
        int[] Xsizes = new int[nfeatures];
        int Ysize = 0;
        UnitTypeTable utt = instances.get((int)0).gs.getUnitTypeTable();
        for (i2 = 0; i2 < nfolds; ++i2) {
            folds[i2] = new ArrayList();
        }
        for (i2 = 0; i2 < X_l.size(); ++i2) {
            int fold = r.nextInt(nfolds);
            folds[fold].add(i2);
            for (int j = 0; j < nfeatures; ++j) {
                if (X_l.get(i2)[j] < Xsizes[j]) continue;
                Xsizes[j] = X_l.get(i2)[j] + 1;
            }
            if (Y_l.get(i2) < Ysize) continue;
            Ysize = Y_l.get(i2) + 1;
        }
        if (DEBUG >= 1) {
            System.out.println("Xsizes: " + Arrays.toString(Xsizes));
        }
        if (DEBUG >= 1) {
            System.out.println("Ysize: " + Ysize);
        }
        double[] correct_per_unit = new double[utt.getUnitTypes().size()];
        double[] total_per_unit = new double[utt.getUnitTypes().size()];
        double[] loglikelihood_per_unit = new double[utt.getUnitTypes().size()];
        for (int fold = 0; fold < nfolds; ++fold) {
            int i3;
            if (DEBUG >= 1) {
                System.out.println("Evaluating fold " + (fold + 1) + "/" + nfolds + ":");
            }
            ArrayList<int[]> X_training = new ArrayList<int[]>();
            ArrayList<Integer> Y_training = new ArrayList<Integer>();
            ArrayList<TrainingInstance> i_training = new ArrayList<TrainingInstance>();
            ArrayList<int[]> X_test = new ArrayList<int[]>();
            ArrayList<Integer> Y_test = new ArrayList<Integer>();
            ArrayList<TrainingInstance> i_test = new ArrayList<TrainingInstance>();
            for (int i4 = 0; i4 < nfolds; ++i4) {
                int idx;
                Iterator iterator;
                if (i4 == fold) {
                    iterator = folds[i4].iterator();
                    while (iterator.hasNext()) {
                        idx = (Integer)iterator.next();
                        X_test.add(X_l.get(idx));
                        Y_test.add(Y_l.get(idx));
                        i_test.add(instances.get(idx));
                    }
                    continue;
                }
                iterator = folds[i4].iterator();
                while (iterator.hasNext()) {
                    idx = (Integer)iterator.next();
                    X_training.add(X_l.get(idx));
                    Y_training.add(Y_l.get(idx));
                    i_training.add(instances.get(idx));
                }
            }
            if (DEBUG >= 1) {
                System.out.println("  training/test split is " + X_training.size() + "/" + X_test.size());
            }
            model.clearTraining();
            model.train(X_training, Y_training, i_training);
            int[] fold_correct_per_unit = new int[utt.getUnitTypes().size()];
            int[] fold_total_per_unit = new int[utt.getUnitTypes().size()];
            double[] fold_loglikelihood_per_unit = new double[utt.getUnitTypes().size()];
            double numPossibleActionsAccum = 0.0;
            for (int i5 = 0; i5 < X_test.size(); ++i5) {
                Unit u = ((TrainingInstance)i_test.get((int)i5)).u;
                List<UnitAction> possibleUnitActions = u.getUnitActions(((TrainingInstance)i_test.get((int)i5)).gs);
                ArrayList<Integer> possibleUnitActionIndexes = new ArrayList<Integer>();
                for (UnitAction ua : possibleUnitActions) {
                    int idx;
                    if (ua.getType() == 5) {
                        ua = new UnitAction(5, ua.getLocationX() - u.getX(), ua.getLocationY() - u.getY());
                    }
                    if ((idx = allPossibleActions.indexOf(ua)) < 0) {
                        throw new Exception("Unknown action: " + ua);
                    }
                    possibleUnitActionIndexes.add(idx);
                }
                if (possibleUnitActions.size() <= 1) continue;
                numPossibleActionsAccum += (double)possibleUnitActions.size();
                double[] predicted_distribution = model.predictDistribution((int[])X_test.get(i5), (TrainingInstance)i_test.get(i5));
                predicted_distribution = model.filterByPossibleActionIndexes(predicted_distribution, possibleUnitActionIndexes);
                int actual_y = (Integer)Y_test.get(i5);
                if (!possibleUnitActionIndexes.contains(actual_y)) {
                    System.out.println("Actual action in the dataset is not possible!");
                    continue;
                }
                int predicted_y = -1;
                Collections.shuffle(possibleUnitActions);
                Iterator iterator = possibleUnitActionIndexes.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (predicted_y == -1) {
                        predicted_y = idx;
                        continue;
                    }
                    if (!(predicted_distribution[idx] > predicted_distribution[predicted_y])) continue;
                    predicted_y = idx;
                }
                if (predicted_y == actual_y) {
                    int n = u.getType().ID;
                    fold_correct_per_unit[n] = fold_correct_per_unit[n] + 1;
                }
                int n = u.getType().ID;
                fold_total_per_unit[n] = fold_total_per_unit[n] + 1;
                double loglikelihood = Math.log(predicted_distribution[actual_y]);
                if (Double.isInfinite(loglikelihood)) {
                    System.out.println(Arrays.toString(predicted_distribution));
                    System.out.println(possibleUnitActionIndexes);
                    System.out.println(actual_y + " : " + allPossibleActions.get(actual_y));
                    System.exit(1);
                }
                int n2 = u.getType().ID;
                fold_loglikelihood_per_unit[n2] = fold_loglikelihood_per_unit[n2] + loglikelihood;
            }
            double[] fold_accuracy_per_unit = new double[utt.getUnitTypes().size()];
            if (DEBUG >= 1) {
                System.out.println("Average possible actions: " + numPossibleActionsAccum / (double)X_test.size());
            }
            for (i3 = 0; i3 < utt.getUnitTypes().size(); ++i3) {
                fold_accuracy_per_unit[i3] = (double)fold_correct_per_unit[i3] / (double)fold_total_per_unit[i3];
                if (DEBUG >= 1) {
                    System.out.println("Fold accuracy (" + utt.getUnitTypes().get((int)i3).name + "): " + fold_accuracy_per_unit[i3] + "   (" + fold_correct_per_unit[i3] + "/" + fold_total_per_unit[i3] + ")");
                }
                int n = i3;
                correct_per_unit[n] = correct_per_unit[n] + (double)fold_correct_per_unit[i3];
                int n3 = i3;
                total_per_unit[n3] = total_per_unit[n3] + (double)fold_total_per_unit[i3];
            }
            for (i3 = 0; i3 < utt.getUnitTypes().size(); ++i3) {
                if (DEBUG >= 1) {
                    System.out.println("Fold loglikelihood (" + utt.getUnitTypes().get((int)i3).name + "): " + fold_loglikelihood_per_unit[i3] + " (average: " + fold_loglikelihood_per_unit[i3] / (double)fold_total_per_unit[i3] + ")");
                }
                int n = i3;
                loglikelihood_per_unit[n] = loglikelihood_per_unit[n] + fold_loglikelihood_per_unit[i3];
            }
        }
        if (DEBUG >= 1) {
            System.out.println(" ---------- ");
        }
        double correct = 0.0;
        double total = 0.0;
        double loglikelihood = 0.0;
        for (i = 0; i < utt.getUnitTypes().size(); ++i) {
            double accuracy_per_unit = correct_per_unit[i] / total_per_unit[i];
            if (DEBUG >= 1) {
                System.out.println("Final accuracy (" + utt.getUnitTypes().get((int)i).name + "): " + accuracy_per_unit + "   (" + correct_per_unit[i] + "/" + total_per_unit[i] + ")");
            }
            correct += correct_per_unit[i];
            total += total_per_unit[i];
        }
        for (i = 0; i < utt.getUnitTypes().size(); ++i) {
            if (DEBUG >= 1) {
                System.out.println("Final loglikelihood (" + utt.getUnitTypes().get((int)i).name + "): " + loglikelihood_per_unit[i] + " (average: " + loglikelihood_per_unit[i] / total_per_unit[i] + ")");
            }
            loglikelihood += loglikelihood_per_unit[i];
        }
        double accuracy = correct / total;
        if (DEBUG >= 1) {
            System.out.println("Final accuracy: " + accuracy);
        }
        if (DEBUG >= 1) {
            System.out.println("Final loglikelihood: " + loglikelihood + " (average " + loglikelihood / total + ")");
        }
        return new Pair<Double, Double>(accuracy, loglikelihood / total);
    }
}

