/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes.featuregeneration;

import ai.machinelearning.bayes.TrainingInstance;
import ai.machinelearning.bayes.featuregeneration.FeatureGenerator;
import java.util.ArrayList;
import java.util.List;
import rts.PhysicalGameState;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class FeatureGeneratorSimple
extends FeatureGenerator {
    @Override
    public List<Object> generateFeatures(TrainingInstance ti) {
        ArrayList<Object> features = new ArrayList<Object>();
        int player = ti.u.getPlayer();
        PhysicalGameState pgs = ti.gs.getPhysicalGameState();
        int total_friendly = 0;
        double x_friendly = 0.0;
        double y_friendly = 0.0;
        int total_enemy = 0;
        double x_enemy = 0.0;
        double y_enemy = 0.0;
        int have_barracks = 0;
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() == -1) continue;
            if (u.getPlayer() == player) {
                x_friendly += (double)u.getX();
                y_friendly += (double)u.getY();
                ++total_friendly;
                if (!u.getType().name.equals("Barracks")) continue;
                have_barracks = 1;
                continue;
            }
            x_enemy += (double)u.getX();
            y_enemy += (double)u.getY();
            ++total_enemy;
        }
        x_friendly /= (double)total_friendly;
        y_friendly /= (double)total_friendly;
        x_enemy /= (double)total_enemy;
        y_enemy /= (double)total_enemy;
        double angle_friendly = Math.atan2(x_friendly -= (double)ti.u.getX(), y_friendly -= (double)ti.u.getY());
        double angle_enemy = Math.atan2(x_enemy -= (double)ti.u.getX(), y_enemy -= (double)ti.u.getY());
        double resolution = 0.7853981633974483;
        angle_friendly += resolution / 2.0;
        angle_enemy += resolution / 2.0;
        if (angle_friendly < 0.0) {
            angle_friendly += Math.PI * 2;
        }
        if (angle_enemy < 0.0) {
            angle_enemy += Math.PI * 2;
        }
        int direction_friendly = (int)(angle_friendly / resolution);
        int direction_enemy = (int)(angle_enemy / resolution);
        features.add(ti.u.getResources());
        features.add(direction_friendly);
        features.add(direction_enemy);
        features.add(have_barracks);
        int[] xo = new int[]{-2, 0, 2, 0};
        int[] yo = new int[]{0, -2, 0, 2};
        int x = ti.u.getX();
        int y = ti.u.getY();
        int width = ti.gs.getPhysicalGameState().getWidth();
        int height = ti.gs.getPhysicalGameState().getHeight();
        UnitTypeTable utt = ti.gs.getUnitTypeTable();
        int unitTypes = utt.getUnitTypes().size();
        for (int i = 0; i < xo.length; ++i) {
            int x2 = x - xo[i];
            int y2 = y - yo[i];
            Unit u = ti.gs.getPhysicalGameState().getUnitAt(x2, y2);
            if (u != null) {
                if (u.getPlayer() == player) {
                    features.add(3 + u.getType().ID);
                    continue;
                }
                features.add(3 + unitTypes + u.getType().ID);
                continue;
            }
            if (x2 < 0 || y2 < 0 || x2 >= width || y2 >= height) {
                features.add(2);
                continue;
            }
            if (ti.gs.getPhysicalGameState().getTerrain(x2, y2) == 0) {
                if (ti.gs.free(x2, y2)) {
                    features.add(0);
                    continue;
                }
                features.add(1);
                continue;
            }
            features.add(2);
        }
        return features;
    }
}

