/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts;

import ai.evaluation.EvaluationFunction;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;

public abstract class MCTSNode {
    public static Random r = new Random();
    public int type;
    public MCTSNode parent;
    public GameState gs;
    public int depth = 0;
    public List<PlayerAction> actions;
    public List<MCTSNode> children;
    public double accum_evaluation = 0.0;
    public int visit_count = 0;
    public int creation_ID = -1;
    public int highest_children_creation_ID = -1;
    public int best_child_so_far = -1;

    public void showNode(int depth, int maxdepth, EvaluationFunction ef) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                MCTSNode child = this.children.get(i);
                for (int j = 0; j < depth; ++j) {
                    System.out.print("    ");
                }
                System.out.println("child explored " + child.visit_count + " (EF: " + ef.evaluate(0, 1, child.gs) + ") Avg evaluation: " + child.accum_evaluation / (double)child.visit_count + " : " + this.actions.get(i));
                if (depth >= maxdepth) continue;
                child.showNode(depth + 1, maxdepth, ef);
            }
        }
    }
}

