/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.units.Unit;

public interface AIWithBelieveState {
    public void setInitialBelieveState(int var1, GameState var2, PartiallyObservableGameState var3);

    public List<Unit> getBelieveUnits();

    public static double getJaccardIndex(int player, GameState gs, PartiallyObservableGameState pogs, List<Unit> believeUnits) {
        double maxDist = gs.getPhysicalGameState().getWidth() + gs.getPhysicalGameState().getHeight() + 1;
        double AB_intersection = 0.0;
        double A = believeUnits.size();
        double B = 0.0;
        boolean[] unitSeen = new boolean[believeUnits.size()];
        for (Unit u : gs.getUnits()) {
            if (u.getPlayer() != player) continue;
            B += 1.0;
            if (pogs.observable(u.getX(), u.getY())) {
                AB_intersection += 1.0;
                A += 1.0;
                continue;
            }
            Unit closestUnit = null;
            double minDist = maxDist;
            int id = -1;
            for (int i = 0; i < believeUnits.size(); ++i) {
                double dist;
                if (unitSeen[i]) continue;
                Unit bu = believeUnits.get(i);
                if (bu.getID() == u.getID()) {
                    id = i;
                    closestUnit = bu;
                    minDist = Math.abs(bu.getX() - u.getX()) + Math.abs(bu.getY() - u.getY());
                    break;
                }
                if (bu.getType() != u.getType() || !(minDist > (dist = (double)(Math.abs(bu.getX() - u.getX()) + Math.abs(bu.getY() - u.getY()))))) continue;
                id = i;
                closestUnit = bu;
                minDist = dist;
            }
            if (closestUnit == null) continue;
            unitSeen[id] = true;
            double normDist = 1.0 - minDist / maxDist;
            AB_intersection += normDist;
        }
        double jaccardIndex = AB_intersection / (A + B - AB_intersection);
        if (jaccardIndex > 1.0) {
            System.out.println("### Jaccard Index bigger than 1.0 ###");
            System.out.println(AB_intersection + " / " + A + " + " + B + " - " + AB_intersection + "=" + jaccardIndex);
            System.out.println(gs.getPhysicalGameState());
            System.out.println(pogs.getPhysicalGameState());
            for (Unit u : gs.getUnits()) {
                if (u.getPlayer() != player) continue;
                System.out.println("Adding to B " + u);
                if (!pogs.observable(u.getX(), u.getY())) continue;
                System.out.println("Adding to A " + u);
            }
        }
        return jaccardIndex;
    }
}

