/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.mcts.MCTSNode;
import ai.mcts.believestatemcts.AIWithBelieveState;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class BS1_NaiveMCTS
extends NaiveMCTS
implements AIWithBelieveState {
    GameState initialGameState;
    List<Unit> lastKnownPosition = new LinkedList<Unit>();

    public BS1_NaiveMCTS(UnitTypeTable utt) {
        super(utt);
    }

    public BS1_NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float discout_l, float e_g, float discout_g, float e_0, float discout_0, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts, lookahead, max_depth, e_l, discout_l, e_g, discout_g, e_0, discout_0, policy, a_ef, fensa);
    }

    public BS1_NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float e_g, float e_0, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts, lookahead, max_depth, e_l, e_g, e_0, policy, a_ef, fensa);
    }

    public BS1_NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float e_g, float e_0, int a_global_strategy, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts, lookahead, max_depth, e_l, e_g, e_0, a_global_strategy, policy, a_ef, fensa);
    }

    @Override
    public AI clone() {
        return new BS1_NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs);
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        if (this.initialGameState != null && gs.getTime() == 0) {
            this.setInitialBelieveState(a_player, this.initialGameState.clone(), new PartiallyObservableGameState(this.initialGameState, a_player));
        }
        if (gs instanceof PartiallyObservableGameState) {
            gs = this.sampleWorld(this.player, (PartiallyObservableGameState)gs);
        }
        this.player = a_player;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gs, null, this.ef.upperBound(gs), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gs;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    @Override
    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        if (this.getTree().children == null) {
            return -1;
        }
        ArrayList<Integer> bestIdxs = new ArrayList<Integer>();
        int bestScore = -1;
        for (int i = 0; i < this.getTree().children.size(); ++i) {
            NaiveMCTSNode child = (NaiveMCTSNode)this.getTree().children.get(i);
            if (child.visit_count > bestScore) {
                bestIdxs.clear();
                bestIdxs.add(i);
                bestScore = child.visit_count;
                continue;
            }
            if (child.visit_count <= bestScore) continue;
            bestIdxs.add(i);
        }
        if (bestIdxs.isEmpty()) {
            return -1;
        }
        if (bestIdxs.size() == 1) {
            return (Integer)bestIdxs.get(0);
        }
        return MCTSNode.r.nextInt(bestIdxs.size());
    }

    @Override
    public void reset() {
        this.initialGameState = null;
    }

    @Override
    public void preGameAnalysis(GameState gs, long milliseconds) throws Exception {
        this.initialGameState = gs.clone();
    }

    @Override
    public void setInitialBelieveState(int player, GameState gs, PartiallyObservableGameState pogs) {
        int opponent = 1 - player;
        for (Unit u : gs.getUnits()) {
            if (u.getPlayer() != opponent || u.getType().canMove || pogs.observable(u.getX(), u.getY())) continue;
            this.lastKnownPosition.add(u);
        }
    }

    @Override
    public List<Unit> getBelieveUnits() {
        LinkedList<Unit> l = new LinkedList<Unit>(this.lastKnownPosition);
        return l;
    }

    public GameState sampleWorld(int player, PartiallyObservableGameState gs) {
        PartiallyObservableGameState newWorld = gs.clone();
        ArrayList<Unit> toDelete = new ArrayList<Unit>();
        for (Unit u : this.lastKnownPosition) {
            if (!gs.observable(u.getX(), u.getY())) {
                newWorld.getPhysicalGameState().addUnit(u);
                continue;
            }
            Unit observedUnit = newWorld.getPhysicalGameState().getUnitAt(u.getX(), u.getY());
            if (observedUnit != null && u.getType() == observedUnit.getType()) continue;
            toDelete.add(u);
        }
        this.lastKnownPosition.removeAll(toDelete);
        return newWorld;
    }
}

