/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.mcts.MCTSNode;
import ai.mcts.believestatemcts.AIWithBelieveState;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PlayerAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class BS3_NaiveMCTS
extends NaiveMCTS
implements AIWithBelieveState {
    GameState initialGameState;
    List<Unit> lastKnownPosition = new LinkedList<Unit>();
    List<Unit> inferedUnits = new LinkedList<Unit>();
    PartiallyObservableGameState lastObservedGame;
    boolean[] typeSeen;

    public BS3_NaiveMCTS(UnitTypeTable utt) {
        super(utt);
    }

    public BS3_NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float discout_l, float e_g, float discout_g, float e_0, float discout_0, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts, lookahead, max_depth, e_l, discout_l, e_g, discout_g, e_0, discout_0, policy, a_ef, fensa);
    }

    public BS3_NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float e_g, float e_0, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts, lookahead, max_depth, e_l, e_g, e_0, policy, a_ef, fensa);
    }

    public BS3_NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float e_g, float e_0, int a_global_strategy, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts, lookahead, max_depth, e_l, e_g, e_0, a_global_strategy, policy, a_ef, fensa);
    }

    @Override
    public AI clone() {
        return new BS3_NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs);
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        if (this.initialGameState != null && gs.getTime() == 0) {
            this.setInitialBelieveState(a_player, this.initialGameState.clone(), new PartiallyObservableGameState(this.initialGameState, a_player));
        }
        if (gs instanceof PartiallyObservableGameState) {
            this.updateBelieveState(this.player, (PartiallyObservableGameState)gs);
            gs = this.sampleWorld(this.player, (PartiallyObservableGameState)gs);
        }
        this.player = a_player;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gs, null, this.ef.upperBound(gs), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gs;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    @Override
    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        if (this.getTree().children == null) {
            return -1;
        }
        ArrayList<Integer> bestIdxs = new ArrayList<Integer>();
        int bestScore = -1;
        for (int i = 0; i < this.getTree().children.size(); ++i) {
            NaiveMCTSNode child = (NaiveMCTSNode)this.getTree().children.get(i);
            if (child.visit_count > bestScore) {
                bestIdxs.clear();
                bestIdxs.add(i);
                bestScore = child.visit_count;
                continue;
            }
            if (child.visit_count <= bestScore) continue;
            bestIdxs.add(i);
        }
        if (bestIdxs.isEmpty()) {
            return -1;
        }
        if (bestIdxs.size() == 1) {
            return (Integer)bestIdxs.get(0);
        }
        System.out.println("Random action from " + bestIdxs.size());
        return MCTSNode.r.nextInt(bestIdxs.size());
    }

    @Override
    public void reset() {
        this.initialGameState = null;
    }

    @Override
    public void preGameAnalysis(GameState gs, long milliseconds) throws Exception {
        this.initialGameState = gs.clone();
    }

    @Override
    public void setInitialBelieveState(int player, GameState gs, PartiallyObservableGameState pogs) {
        int opponent = 1 - player;
        this.typeSeen = new boolean[gs.getUnitTypeTable().getUnitTypes().size()];
        for (Unit u : gs.getUnits()) {
            if (u.getPlayer() != opponent || pogs.observable(u.getX(), u.getY())) continue;
            this.lastKnownPosition.add(u.clone());
            this.typeSeen[u.getType().ID] = true;
        }
        this.lastObservedGame = pogs.clone();
    }

    @Override
    public List<Unit> getBelieveUnits() {
        LinkedList<Unit> l = new LinkedList<Unit>();
        l.addAll(this.lastKnownPosition);
        l.addAll(this.inferedUnits);
        return l;
    }

    public GameState sampleWorld(int player, PartiallyObservableGameState gs) {
        boolean validPosition;
        PartiallyObservableGameState newWorld = gs.clone();
        ArrayList<Unit> toDelete = new ArrayList<Unit>();
        for (Unit u : this.lastKnownPosition) {
            validPosition = true;
            if (gs.observable(u.getX(), u.getY())) {
                validPosition = this.getClosestNotObservableLocationNear(u.getX(), u.getY(), gs, u);
            }
            if (validPosition) {
                try {
                    newWorld.getPhysicalGameState().addUnit(u);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("IllegalArgumentException: " + e.getMessage());
                    System.err.println(newWorld.getPhysicalGameState());
                    System.err.println("adding unit: " + u);
                    System.err.println("Last known unit:");
                    System.err.println(this.lastKnownPosition);
                }
                continue;
            }
            toDelete.add(u);
        }
        this.lastKnownPosition.removeAll(toDelete);
        toDelete.clear();
        for (Unit u : this.inferedUnits) {
            validPosition = true;
            if (gs.observable(u.getX(), u.getY())) {
                this.getClosestNotObservableLocationNear(u.getX(), u.getY(), gs, u);
            }
            if (validPosition) {
                try {
                    newWorld.getPhysicalGameState().addUnit(u);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("IllegalArgumentException: " + e.getMessage());
                    System.err.println(newWorld.getPhysicalGameState());
                    System.err.println("adding unit: " + u);
                    System.err.println("Infered units:");
                    System.err.println(this.inferedUnits);
                }
                continue;
            }
            toDelete.add(u);
        }
        this.inferedUnits.removeAll(toDelete);
        return newWorld;
    }

    public void updateBelieveState(int player, PartiallyObservableGameState gs) {
        int opponent = 1 - player;
        for (Unit u : this.lastObservedGame.getUnits()) {
            if (u.getPlayer() != opponent || !gs.free(u.getX(), u.getY())) continue;
            UnitActionAssignment uaa = this.lastObservedGame.getActionAssignment(u);
            if (uaa != null && uaa.action.getType() == 1) {
                int offsx = 0;
                int offsy = 0;
                if (uaa.action.getDirection() == 0) {
                    offsy = -1;
                }
                if (uaa.action.getDirection() == 1) {
                    offsx = 1;
                }
                if (uaa.action.getDirection() == 2) {
                    offsy = 1;
                }
                if (uaa.action.getDirection() == 3) {
                    offsx = -1;
                }
                if (gs.observable(u.getX() + offsx, u.getY() + offsy)) continue;
                this.lastKnownPosition.add(u.clone());
                continue;
            }
            if (gs.observable(u.getX(), u.getY()) || this.wasUnderAttack(u)) continue;
            this.lastKnownPosition.add(u.clone());
        }
        block1: for (Unit u : gs.getUnits()) {
            boolean validPosition;
            UnitActionAssignment uaa;
            if (u.getPlayer() != opponent) continue;
            if (!this.typeSeen[u.getType().ID]) {
                this.typeSeen[u.getType().ID] = true;
                UnitType ut = u.getType().producedBy.get(0);
                if (!this.typeSeen[ut.ID]) {
                    Unit newUnit = new Unit(opponent, ut, 0, 0, 0);
                    boolean validPosition2 = this.getClosestNotObservableLocationNear(u.getX(), u.getY(), gs, newUnit);
                    if (validPosition2) {
                        this.inferedUnits.add(newUnit);
                    }
                }
            }
            ArrayList<Unit> toDelete = new ArrayList<Unit>();
            for (Unit iu : this.inferedUnits) {
                if (u.getType() != iu.getType()) continue;
                toDelete.add(iu);
            }
            this.inferedUnits.removeAll(toDelete);
            if (!this.lastObservedGame.observable(u.getX(), u.getY()) || !this.wasVisibleOpponentMovingTo(opponent, u.getX(), u.getY())) {
                Unit unitToRemove = null;
                for (Unit observedUnit : this.lastKnownPosition) {
                    if (observedUnit.getID() != u.getID()) continue;
                    unitToRemove = observedUnit;
                    break;
                }
                if (unitToRemove != null) {
                    this.lastKnownPosition.remove(unitToRemove);
                }
            }
            if ((uaa = gs.getActionAssignment(u)) == null || uaa.action.getType() != 1 && uaa.action.getType() != 4) continue;
            int offsx = u.getX();
            int offsy = u.getY();
            if (uaa.action.getDirection() == 0) {
                --offsy;
            }
            if (uaa.action.getDirection() == 1) {
                ++offsx;
            }
            if (uaa.action.getDirection() == 2) {
                ++offsy;
            }
            if (uaa.action.getDirection() == 3) {
                --offsx;
            }
            for (Unit bu : this.lastKnownPosition) {
                if (bu.getX() != offsx || bu.getY() != offsy) continue;
                validPosition = this.getClosestNotObservableLocationNear(bu.getX(), bu.getY(), gs, bu);
                if (validPosition) break;
                this.lastKnownPosition.remove(bu);
                break;
            }
            for (Unit bu : this.inferedUnits) {
                if (bu.getX() != offsx || bu.getY() != offsy) continue;
                validPosition = this.getClosestNotObservableLocationNear(bu.getX(), bu.getY(), gs, bu);
                if (validPosition) continue block1;
                this.inferedUnits.remove(bu);
                continue block1;
            }
        }
        this.lastObservedGame = gs.clone();
    }

    public boolean wasVisibleOpponentMovingTo(int opponent, int x, int y) {
        if (!this.lastObservedGame.free(x, y)) {
            return true;
        }
        for (Unit u : this.lastObservedGame.getUnits()) {
            UnitActionAssignment uaa;
            if (u.getPlayer() != opponent || (uaa = this.lastObservedGame.getActionAssignment(u)) == null || uaa.action.getType() != 1) continue;
            int offsx = 0;
            int offsy = 0;
            if (uaa.action.getDirection() == 0) {
                offsy = -1;
            }
            if (uaa.action.getDirection() == 1) {
                offsx = 1;
            }
            if (uaa.action.getDirection() == 2) {
                offsy = 1;
            }
            if (uaa.action.getDirection() == 3) {
                offsx = -1;
            }
            if (u.getX() + offsx != x || u.getY() + offsy != y) continue;
            return true;
        }
        return false;
    }

    public boolean wasUnderAttack(Unit u) {
        for (UnitActionAssignment ua : this.lastObservedGame.getUnitActions().values()) {
            if (ua.action.getType() != 5 || ua.action.getLocationX() != u.getX() || ua.action.getLocationY() != u.getY()) continue;
            return true;
        }
        return false;
    }

    public boolean getClosestNotObservableLocationNear(int startX, int startY, PartiallyObservableGameState gs, Unit u) {
        int x = startX;
        int y = startY;
        int length = 1;
        int j = 0;
        boolean first = true;
        int dx = 0;
        int dy = 1;
        int maxLenght = Math.max(gs.getPhysicalGameState().getWidth(), gs.getPhysicalGameState().getHeight());
        while (length < maxLenght) {
            if (x >= 0 && x < gs.getPhysicalGameState().getWidth() && y >= 0 && y < gs.getPhysicalGameState().getHeight() && !gs.observable(x, y) && gs.free(x, y) && this.believeFree(x, y)) {
                u.setX(x);
                u.setY(y);
                return true;
            }
            x += dx;
            y += dy;
            if (++j != length) continue;
            j = 0;
            if (!first) {
                ++length;
            }
            boolean bl = first = !first;
            if (dx == 0) {
                dx = dy;
                dy = 0;
                continue;
            }
            dy = -dx;
            dx = 0;
        }
        return false;
    }

    public boolean believeFree(int x, int y) {
        for (Unit u : this.lastKnownPosition) {
            if (u.getX() != x || u.getY() != y) continue;
            return false;
        }
        for (Unit u : this.inferedUnits) {
            if (u.getX() != x || u.getY() != y) continue;
            return false;
        }
        return true;
    }
}

