/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.mlps;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.mlps.MLPSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class MLPSMCTS
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    public EvaluationFunction ef;
    Random r = new Random();
    public AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from;
    MLPSNode tree;
    int current_iteration = 0;
    public int MAXSIMULATIONTIME = 1024;
    public int MAX_TREE_DEPTH = 10;
    int playerForThisComputation;
    double C = 0.05;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    public long total_time = 0L;

    public MLPSMCTS(UnitTypeTable utt) {
        this(100, -1, 100, 10, 0.05, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public MLPSMCTS(int available_time, int max_playouts, int lookahead, int max_depth, double a_C, AI policy, EvaluationFunction a_ef) {
        super(available_time, max_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.randomAI = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.C = a_C;
        this.ef = a_ef;
    }

    @Override
    public void reset() {
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs = 0L;
        this.total_cycles_executed = 0L;
        this.total_actions_issued = 0L;
        this.total_time = 0L;
        this.current_iteration = 0;
    }

    @Override
    public AI clone() {
        return new MLPSMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.C, this.randomAI, this.ef);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        this.playerForThisComputation = a_player;
        this.current_iteration = 0;
        float evaluation_bound = this.ef.upperBound(gs);
        this.tree = new MLPSNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gs, null, evaluation_bound, this.current_iteration++);
        if (this.tree.moveGenerator != null) {
            this.max_actions_so_far = Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        }
        this.gs_to_start_from = gs;
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long start;
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long end = start = System.currentTimeMillis();
        long count = 0L;
        while (this.iteration(this.playerForThisComputation)) {
            end = System.currentTimeMillis();
            if ((this.TIME_BUDGET < 0 || end - start < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++count < (long)this.ITERATIONS_BUDGET)) continue;
        }
        this.total_time += end - start;
        ++this.total_cycles_executed;
    }

    public boolean iteration(int player) throws Exception {
        MLPSNode leaf;
        if ((leaf = this.tree.selectLeaf(player, 1 - player, this.C, this.MAX_TREE_DEPTH, this.current_iteration++)) != null) {
            GameState gs2 = leaf.gs.clone();
            this.simulate(gs2, gs2.getTime() + this.MAXSIMULATIONTIME);
            int time = gs2.getTime() - this.gs_to_start_from.getTime();
            double evaluation = (double)this.ef.evaluate(player, 1 - player, gs2) * Math.pow(0.99, (double)time / 10.0);
            leaf.propagateEvaluation((float)evaluation, null);
            ++this.total_runs;
        } else {
            System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        int idx = this.getMostVisitedActionIdx();
        if (idx == -1) {
            if (DEBUG >= 1) {
                System.out.println("MLPSMCTS no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        if (DEBUG >= 2) {
            this.tree.showNode(0, 1, this.ef);
        }
        if (DEBUG >= 1) {
            MLPSNode best = (MLPSNode)this.tree.children.get(idx);
            System.out.println("MLPSMCTS selected children " + this.tree.actions.get(idx) + " explored " + best.visit_count + " Avg evaluation: " + best.accum_evaluation / (double)best.visit_count);
        }
        return (PlayerAction)this.tree.actions.get(idx);
    }

    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        int bestIdx = -1;
        MLPSNode best = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        if (this.tree.children == null) {
            return -1;
        }
        for (int i = 0; i < this.tree.children.size(); ++i) {
            MLPSNode child = (MLPSNode)this.tree.children.get(i);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + child.accum_evaluation / (double)child.visit_count);
            }
            if (best != null && child.visit_count <= best.visit_count) continue;
            best = child;
            bestIdx = i;
        }
        return bestIdx;
    }

    public int getHighestEvaluationActionIdx() {
        ++this.total_actions_issued;
        int bestIdx = -1;
        MLPSNode best = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int i = 0; i < this.tree.children.size(); ++i) {
            MLPSNode child = (MLPSNode)this.tree.children.get(i);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + child.accum_evaluation / (double)child.visit_count);
            }
            if (best != null && !(child.accum_evaluation / (double)child.visit_count > best.accum_evaluation / (double)best.visit_count)) continue;
            best = child;
            bestIdx = i;
        }
        return bestIdx;
    }

    public void simulate(GameState gs, int time) throws Exception {
        boolean gameover = false;
        do {
            if (gs.isComplete()) {
                gameover = gs.cycle();
                continue;
            }
            gs.issue(this.randomAI.getAction(0, gs));
            gs.issue(this.randomAI.getAction(1, gs));
        } while (!gameover && gs.getTime() < time);
    }

    public MLPSNode getTree() {
        return this.tree;
    }

    public GameState getGameStateToStartFrom() {
        return this.gs_to_start_from;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + ", " + this.MAX_TREE_DEPTH + ", " + this.C + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public String statisticsString() {
        return "Total runs: " + this.total_runs + ", runs per action: " + (float)this.total_runs / (float)this.total_actions_issued + ", runs per cycle: " + (float)this.total_runs / (float)this.total_cycles_executed + ", averate time per cycle: " + (float)this.total_time / (float)this.total_cycles_executed + ", max branching factor: " + this.max_actions_so_far;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        parameters.add(new ParameterSpecification("C", Double.TYPE, 0.05));
        parameters.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.MAXSIMULATIONTIME = a_pola;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int a_mtd) {
        this.MAX_TREE_DEPTH = a_mtd;
    }

    public double getC() {
        return this.C;
    }

    public void setC(double a_c) {
        this.C = a_c;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI a_dp) {
        this.randomAI = a_dp;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }
}

