/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.naivemcts;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class NaiveMCTS
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    public EvaluationFunction ef;
    Random r = new Random();
    public AI playoutPolicy = new RandomBiasedAI();
    protected long max_actions_so_far = 0L;
    protected GameState gs_to_start_from;
    protected NaiveMCTSNode tree;
    protected int current_iteration = 0;
    public int MAXSIMULATIONTIME = 1024;
    public int MAX_TREE_DEPTH = 10;
    protected int player;
    public float epsilon_0 = 0.2f;
    public float epsilon_l = 0.25f;
    public float epsilon_g = 0.0f;
    public float initial_epsilon_0 = 0.2f;
    public float initial_epsilon_l = 0.25f;
    public float initial_epsilon_g = 0.0f;
    public float discount_0 = 0.999f;
    public float discount_l = 0.999f;
    public float discount_g = 0.999f;
    public int global_strategy = 0;
    public boolean forceExplorationOfNonSampledActions = true;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    public long total_time = 0L;

    public NaiveMCTS(UnitTypeTable utt) {
        this(100, -1, 100, 10, 0.3f, 0.0f, 0.4f, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3(), true);
    }

    public NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float discout_l, float e_g, float discout_g, float e_0, float discout_0, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.playoutPolicy = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.initial_epsilon_l = this.epsilon_l = e_l;
        this.initial_epsilon_g = this.epsilon_g = e_g;
        this.initial_epsilon_0 = this.epsilon_0 = e_0;
        this.discount_l = discout_l;
        this.discount_g = discout_g;
        this.discount_0 = discout_0;
        this.ef = a_ef;
        this.forceExplorationOfNonSampledActions = fensa;
    }

    public NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float e_g, float e_0, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.playoutPolicy = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.initial_epsilon_l = this.epsilon_l = e_l;
        this.initial_epsilon_g = this.epsilon_g = e_g;
        this.initial_epsilon_0 = this.epsilon_0 = e_0;
        this.discount_l = 1.0f;
        this.discount_g = 1.0f;
        this.discount_0 = 1.0f;
        this.ef = a_ef;
        this.forceExplorationOfNonSampledActions = fensa;
    }

    public NaiveMCTS(int available_time, int max_playouts, int lookahead, int max_depth, float e_l, float e_g, float e_0, int a_global_strategy, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.playoutPolicy = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.initial_epsilon_l = this.epsilon_l = e_l;
        this.initial_epsilon_g = this.epsilon_g = e_g;
        this.initial_epsilon_0 = this.epsilon_0 = e_0;
        this.discount_l = 1.0f;
        this.discount_g = 1.0f;
        this.discount_0 = 1.0f;
        this.global_strategy = a_global_strategy;
        this.ef = a_ef;
        this.forceExplorationOfNonSampledActions = fensa;
    }

    @Override
    public void reset() {
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs = 0L;
        this.total_cycles_executed = 0L;
        this.total_actions_issued = 0L;
        this.total_time = 0L;
        this.current_iteration = 0;
    }

    @Override
    public AI clone() {
        return new NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        this.player = a_player;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gs, null, this.ef.upperBound(gs), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gs;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long start;
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long end = start = System.currentTimeMillis();
        long count = 0L;
        while (this.iteration(this.player)) {
            end = System.currentTimeMillis();
            if ((this.TIME_BUDGET < 0 || end - start < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++count < (long)this.ITERATIONS_BUDGET)) continue;
        }
        this.total_time += end - start;
        ++this.total_cycles_executed;
    }

    public boolean iteration(int player) throws Exception {
        NaiveMCTSNode leaf;
        if ((leaf = this.tree.selectLeaf(player, 1 - player, this.epsilon_l, this.epsilon_g, this.epsilon_0, this.global_strategy, this.MAX_TREE_DEPTH, this.current_iteration++)) != null) {
            GameState gs2 = leaf.gs.clone();
            this.simulate(gs2, gs2.getTime() + this.MAXSIMULATIONTIME);
            int time = gs2.getTime() - this.gs_to_start_from.getTime();
            double evaluation = (double)this.ef.evaluate(player, 1 - player, gs2) * Math.pow(0.99, (double)time / 10.0);
            leaf.propagateEvaluation(evaluation, null);
            this.epsilon_0 *= this.discount_0;
            this.epsilon_l *= this.discount_l;
            this.epsilon_g *= this.discount_g;
            ++this.total_runs;
        } else {
            System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        int idx = this.getMostVisitedActionIdx();
        if (idx == -1) {
            if (DEBUG >= 1) {
                System.out.println("NaiveMCTS no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        if (DEBUG >= 2) {
            this.tree.showNode(0, 1, this.ef);
        }
        if (DEBUG >= 1) {
            NaiveMCTSNode best = (NaiveMCTSNode)this.tree.children.get(idx);
            System.out.println("NaiveMCTS selected children " + this.tree.actions.get(idx) + " explored " + best.visit_count + " Avg evaluation: " + best.accum_evaluation / (double)best.visit_count);
        }
        return (PlayerAction)this.tree.actions.get(idx);
    }

    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        int bestIdx = -1;
        NaiveMCTSNode best = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        if (this.tree.children == null) {
            return -1;
        }
        for (int i = 0; i < this.tree.children.size(); ++i) {
            NaiveMCTSNode child = (NaiveMCTSNode)this.tree.children.get(i);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + child.accum_evaluation / (double)child.visit_count);
            }
            if (best != null && child.visit_count <= best.visit_count) continue;
            best = child;
            bestIdx = i;
        }
        return bestIdx;
    }

    public int getHighestEvaluationActionIdx() {
        ++this.total_actions_issued;
        int bestIdx = -1;
        NaiveMCTSNode best = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int i = 0; i < this.tree.children.size(); ++i) {
            NaiveMCTSNode child = (NaiveMCTSNode)this.tree.children.get(i);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + child.accum_evaluation / (double)child.visit_count);
            }
            if (best != null && !(child.accum_evaluation / (double)child.visit_count > best.accum_evaluation / (double)best.visit_count)) continue;
            best = child;
            bestIdx = i;
        }
        return bestIdx;
    }

    public void simulate(GameState gs, int time) throws Exception {
        boolean gameover = false;
        do {
            if (gs.isComplete()) {
                gameover = gs.cycle();
                continue;
            }
            gs.issue(this.playoutPolicy.getAction(0, gs));
            gs.issue(this.playoutPolicy.getAction(1, gs));
        } while (!gameover && gs.getTime() < time);
    }

    public NaiveMCTSNode getTree() {
        return this.tree;
    }

    public GameState getGameStateToStartFrom() {
        return this.gs_to_start_from;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + "," + this.MAX_TREE_DEPTH + "," + this.epsilon_l + ", " + this.discount_l + ", " + this.epsilon_g + ", " + this.discount_g + ", " + this.epsilon_0 + ", " + this.discount_0 + ", " + this.playoutPolicy + ", " + this.ef + ")";
    }

    @Override
    public String statisticsString() {
        return "Total runs: " + this.total_runs + ", runs per action: " + (float)this.total_runs / (float)this.total_actions_issued + ", runs per cycle: " + (float)this.total_runs / (float)this.total_cycles_executed + ", average time per cycle: " + (float)this.total_time / (float)this.total_cycles_executed + ", max branching factor: " + this.max_actions_so_far;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        parameters.add(new ParameterSpecification("E_l", Float.TYPE, 0.3));
        parameters.add(new ParameterSpecification("Discount_l", Float.TYPE, 1.0));
        parameters.add(new ParameterSpecification("E_g", Float.TYPE, 0.0));
        parameters.add(new ParameterSpecification("Discount_g", Float.TYPE, 1.0));
        parameters.add(new ParameterSpecification("E_0", Float.TYPE, 0.4));
        parameters.add(new ParameterSpecification("Discount_0", Float.TYPE, 1.0));
        parameters.add(new ParameterSpecification("DefaultPolicy", AI.class, this.playoutPolicy));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        parameters.add(new ParameterSpecification("ForceExplorationOfNonSampledActions", Boolean.TYPE, true));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.MAXSIMULATIONTIME = a_pola;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int a_mtd) {
        this.MAX_TREE_DEPTH = a_mtd;
    }

    public float getE_l() {
        return this.epsilon_l;
    }

    public void setE_l(float a_e_l) {
        this.epsilon_l = a_e_l;
    }

    public float getDiscount_l() {
        return this.discount_l;
    }

    public void setDiscount_l(float a_discount_l) {
        this.discount_l = a_discount_l;
    }

    public float getE_g() {
        return this.epsilon_g;
    }

    public void setE_g(float a_e_g) {
        this.epsilon_g = a_e_g;
    }

    public float getDiscount_g() {
        return this.discount_g;
    }

    public void setDiscount_g(float a_discount_g) {
        this.discount_g = a_discount_g;
    }

    public float getE_0() {
        return this.epsilon_0;
    }

    public void setE_0(float a_e_0) {
        this.epsilon_0 = a_e_0;
    }

    public float getDiscount_0() {
        return this.discount_0;
    }

    public void setDiscount_0(float a_discount_0) {
        this.discount_0 = a_discount_0;
    }

    public AI getDefaultPolicy() {
        return this.playoutPolicy;
    }

    public void setDefaultPolicy(AI a_dp) {
        this.playoutPolicy = a_dp;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }

    public boolean getForceExplorationOfNonSampledActions() {
        return this.forceExplorationOfNonSampledActions;
    }

    public void setForceExplorationOfNonSampledActions(boolean fensa) {
        this.forceExplorationOfNonSampledActions = fensa;
    }
}

