/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.naivemcts;

import ai.mcts.naivemcts.NaiveMCTSNode;
import ai.mcts.naivemcts.UnitActionTableEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import rts.GameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Sampler;

public class TwoPhaseNaiveMCTSNode
extends NaiveMCTSNode {
    public TwoPhaseNaiveMCTSNode(int maxplayer, int minplayer, GameState a_gs, NaiveMCTSNode a_parent, double a_evaluation_bound, int a_creation_ID, boolean fensa) throws Exception {
        super(maxplayer, minplayer, a_gs, a_parent, a_evaluation_bound, a_creation_ID, fensa);
    }

    public TwoPhaseNaiveMCTSNode selectLeaf(int maxplayer, int minplayer, float el1, float eg1, float e01, int a_gs1, float el2, float eg2, float e02, int a_gs2, int phase1_budget, int max_depth, int a_creation_ID) throws Exception {
        int global_strategy;
        if (this.unitActionTable == null) {
            return this;
        }
        if (this.depth >= max_depth) {
            return this;
        }
        float epsilon_0 = this.visit_count < phase1_budget ? e01 : e02;
        float epsilon_g = this.visit_count < phase1_budget ? eg1 : eg2;
        int n = global_strategy = this.visit_count < phase1_budget ? a_gs1 : a_gs2;
        if (this.children.size() > 0 && r.nextFloat() >= epsilon_0) {
            TwoPhaseNaiveMCTSNode selected = null;
            if (global_strategy == 0) {
                selected = (TwoPhaseNaiveMCTSNode)this.selectFromAlreadySampledEpsilonGreedy(epsilon_g);
            } else if (global_strategy == 1) {
                selected = (TwoPhaseNaiveMCTSNode)this.selectFromAlreadySampledUCB1(C);
            }
            return selected.selectLeaf(maxplayer, minplayer, el1, eg1, e01, a_gs1, el2, eg2, e02, a_gs2, phase1_budget, max_depth, a_creation_ID);
        }
        return this.selectLeafUsingLocalMABs(maxplayer, minplayer, el1, eg1, e01, a_gs1, el2, eg2, e02, a_gs2, phase1_budget, max_depth, a_creation_ID);
    }

    public TwoPhaseNaiveMCTSNode selectLeafUsingLocalMABs(int maxplayer, int minplayer, float el1, float eg1, float e01, int a_gs1, float el2, float eg2, float e02, int a_gs2, int phase1_budget, int max_depth, int a_creation_ID) throws Exception {
        float epsilon_l = this.visit_count < phase1_budget ? el1 : el2;
        LinkedList<double[]> distributions = new LinkedList<double[]>();
        LinkedList<Integer> notSampledYet = new LinkedList<Integer>();
        for (Object ate : this.unitActionTable) {
            int i;
            double[] dist = new double[((UnitActionTableEntry)ate).nactions];
            int bestIdx = -1;
            double bestEvaluation = 0.0;
            int visits = 0;
            for (i = 0; i < ((UnitActionTableEntry)ate).nactions; ++i) {
                if (this.type == 0) {
                    if (bestIdx == -1 || visits != 0 && ((UnitActionTableEntry)ate).visit_count[i] == 0 || visits != 0 && ((UnitActionTableEntry)ate).accum_evaluation[i] / (double)((UnitActionTableEntry)ate).visit_count[i] > bestEvaluation) {
                        bestIdx = i;
                        bestEvaluation = ((UnitActionTableEntry)ate).visit_count[i] > 0 ? ((UnitActionTableEntry)ate).accum_evaluation[i] / (double)((UnitActionTableEntry)ate).visit_count[i] : 0.0;
                        visits = ((UnitActionTableEntry)ate).visit_count[i];
                    }
                } else if (bestIdx == -1 || visits != 0 && ((UnitActionTableEntry)ate).visit_count[i] == 0 || visits != 0 && ((UnitActionTableEntry)ate).accum_evaluation[i] / (double)((UnitActionTableEntry)ate).visit_count[i] < bestEvaluation) {
                    bestIdx = i;
                    bestEvaluation = ((UnitActionTableEntry)ate).visit_count[i] > 0 ? ((UnitActionTableEntry)ate).accum_evaluation[i] / (double)((UnitActionTableEntry)ate).visit_count[i] : 0.0;
                    visits = ((UnitActionTableEntry)ate).visit_count[i];
                }
                dist[i] = epsilon_l / (float)((UnitActionTableEntry)ate).nactions;
            }
            if (((UnitActionTableEntry)ate).visit_count[bestIdx] != 0) {
                dist[bestIdx] = 1.0f - epsilon_l + epsilon_l / (float)((UnitActionTableEntry)ate).nactions;
            } else {
                for (int j = 0; j < dist.length; ++j) {
                    if (((UnitActionTableEntry)ate).visit_count[j] <= 0) continue;
                    dist[j] = 0.0;
                }
            }
            if (DEBUG >= 3) {
                System.out.print("[ ");
                for (i = 0; i < ((UnitActionTableEntry)ate).nactions; ++i) {
                    System.out.print("(" + ((UnitActionTableEntry)ate).visit_count[i] + "," + ((UnitActionTableEntry)ate).accum_evaluation[i] / (double)((UnitActionTableEntry)ate).visit_count[i] + ")");
                }
                System.out.println("]");
                System.out.print("[ ");
                for (double v : dist) {
                    System.out.print(v + " ");
                }
                System.out.println("]");
            }
            notSampledYet.add(distributions.size());
            distributions.add(dist);
        }
        ResourceUsage base_ru = new ResourceUsage();
        for (Unit u : this.gs.getUnits()) {
            UnitAction ua = this.gs.getUnitAction(u);
            if (ua == null) continue;
            ResourceUsage ru = ua.resourceUsage(u, this.gs.getPhysicalGameState());
            base_ru.merge(ru);
        }
        PlayerAction pa2 = new PlayerAction();
        BigInteger actionCode = BigInteger.ZERO;
        pa2.setResourceUsage(base_ru.clone());
        while (!notSampledYet.isEmpty()) {
            int i = (Integer)notSampledYet.remove(r.nextInt(notSampledYet.size()));
            try {
                UnitActionTableEntry ate = (UnitActionTableEntry)this.unitActionTable.get(i);
                double[] distribution = (double[])distributions.get(i);
                int code = Sampler.weighted(distribution);
                UnitAction ua = ate.actions.get(code);
                ResourceUsage r2 = ua.resourceUsage(ate.u, this.gs.getPhysicalGameState());
                if (!pa2.getResourceUsage().consistentWith(r2, this.gs)) {
                    ArrayList<Double> dist_l = new ArrayList<Double>();
                    ArrayList<Integer> dist_outputs = new ArrayList<Integer>();
                    for (int j = 0; j < distribution.length; ++j) {
                        dist_l.add(distribution[j]);
                        dist_outputs.add(j);
                    }
                    do {
                        int idx = dist_outputs.indexOf(code);
                        dist_l.remove(idx);
                        dist_outputs.remove(idx);
                        code = (Integer)Sampler.weighted(dist_l, dist_outputs);
                        ua = ate.actions.get(code);
                        r2 = ua.resourceUsage(ate.u, this.gs.getPhysicalGameState());
                    } while (!pa2.getResourceUsage().consistentWith(r2, this.gs));
                }
                if (this.gs.getUnit(ate.u.getID()) == null) {
                    throw new Error("Issuing an action to an inexisting unit!!!");
                }
                pa2.getResourceUsage().merge(r2);
                pa2.addUnitAction(ate.u, ua);
                actionCode = actionCode.add(BigInteger.valueOf(code).multiply(this.multipliers[i]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TwoPhaseNaiveMCTSNode pate = (TwoPhaseNaiveMCTSNode)this.childrenMap.get(actionCode);
        if (pate == null) {
            this.actions.add(pa2);
            GameState gs2 = this.gs.cloneIssue(pa2);
            TwoPhaseNaiveMCTSNode node = new TwoPhaseNaiveMCTSNode(maxplayer, minplayer, gs2.clone(), this, this.evaluation_bound, a_creation_ID, this.forceExplorationOfNonSampledActions);
            this.childrenMap.put(actionCode, node);
            this.children.add(node);
            return node;
        }
        return pate.selectLeaf(maxplayer, minplayer, el1, eg1, e01, a_gs1, el2, eg2, e02, a_gs2, phase1_budget, max_depth, a_creation_ID);
    }
}

