/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.naivemcts;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTSNode;
import ai.mcts.naivemcts.TwoPhaseNaiveMCTSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class TwoPhaseNaiveMCTSPerNode
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    public EvaluationFunction ef;
    Random r = new Random();
    public AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from;
    TwoPhaseNaiveMCTSNode tree;
    int node_creation_ID = 0;
    public int MAXSIMULATIONTIME = 1024;
    public int MAX_TREE_DEPTH = 10;
    int playerForThisComputation;
    public float phase1_epsilon_l = 0.3f;
    public float phase1_epsilon_g = 0.0f;
    public float phase1_epsilon_0 = 1.0f;
    public float phase2_epsilon_l = 0.3f;
    public float phase2_epsilon_g = 0.0f;
    public float phase2_epsilon_0 = 0.0f;
    public int phase1_budget = 100;
    public int phase1_global_strategy = 0;
    public int phase2_global_strategy = 0;
    boolean forceExplorationOfNonSampledActions = true;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    public long total_time = 0L;

    public TwoPhaseNaiveMCTSPerNode(UnitTypeTable utt) {
        this(100, -1, 100, 10, 0.3f, 0.0f, 1.0f, 0.3f, 0.0f, 0.0f, 100, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3(), true);
    }

    public TwoPhaseNaiveMCTSPerNode(int available_time, int max_playouts, int lookahead, int max_depth, float el1, float eg1, float e01, float el2, float eg2, float e02, int p1_budget, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.randomAI = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.phase1_epsilon_l = el1;
        this.phase1_epsilon_g = eg1;
        this.phase1_epsilon_0 = e01;
        this.phase2_epsilon_l = el2;
        this.phase2_epsilon_g = eg2;
        this.phase2_epsilon_0 = e02;
        this.phase1_budget = p1_budget;
        this.ef = a_ef;
        this.forceExplorationOfNonSampledActions = fensa;
    }

    public TwoPhaseNaiveMCTSPerNode(int available_time, int max_playouts, int lookahead, int max_depth, float el1, float eg1, float e01, int a_gs1, float el2, float eg2, float e02, int a_gs2, int p1_budget, AI policy, EvaluationFunction a_ef, boolean fensa) {
        super(available_time, max_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.randomAI = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.phase1_epsilon_l = el1;
        this.phase1_epsilon_g = eg1;
        this.phase1_epsilon_0 = e01;
        this.phase1_global_strategy = a_gs1;
        this.phase2_epsilon_l = el2;
        this.phase2_epsilon_g = eg2;
        this.phase2_epsilon_0 = e02;
        this.phase2_global_strategy = a_gs2;
        this.phase1_budget = p1_budget;
        this.ef = a_ef;
        this.forceExplorationOfNonSampledActions = fensa;
    }

    @Override
    public void reset() {
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs = 0L;
        this.total_cycles_executed = 0L;
        this.total_actions_issued = 0L;
        this.total_time = 0L;
        this.node_creation_ID = 0;
    }

    @Override
    public AI clone() {
        return new TwoPhaseNaiveMCTSPerNode(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.phase1_epsilon_l, this.phase1_epsilon_g, this.phase1_epsilon_0, this.phase2_epsilon_l, this.phase2_epsilon_g, this.phase2_epsilon_0, this.phase1_budget, this.randomAI, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        this.playerForThisComputation = a_player;
        this.node_creation_ID = 0;
        this.tree = new TwoPhaseNaiveMCTSNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gs, null, this.ef.upperBound(gs), this.node_creation_ID++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gs;
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long start;
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long end = start = System.currentTimeMillis();
        long count = 0L;
        while (this.iteration(this.playerForThisComputation)) {
            end = System.currentTimeMillis();
            if ((this.TIME_BUDGET < 0 || end - start < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++count < (long)this.ITERATIONS_BUDGET)) continue;
        }
        this.total_time += end - start;
        ++this.total_cycles_executed;
    }

    public boolean iteration(int player) throws Exception {
        TwoPhaseNaiveMCTSNode leaf;
        if ((leaf = this.tree.selectLeaf(player, 1 - player, this.phase1_epsilon_l, this.phase1_epsilon_g, this.phase1_epsilon_0, this.phase1_global_strategy, this.phase2_epsilon_l, this.phase2_epsilon_g, this.phase2_epsilon_0, this.phase2_global_strategy, this.phase1_budget, this.MAX_TREE_DEPTH, this.node_creation_ID++)) != null) {
            GameState gs2 = leaf.gs.clone();
            this.simulate(gs2, gs2.getTime() + this.MAXSIMULATIONTIME);
            int time = gs2.getTime() - this.gs_to_start_from.getTime();
            double evaluation = (double)this.ef.evaluate(player, 1 - player, gs2) * Math.pow(0.99, (double)time / 10.0);
            leaf.propagateEvaluation((float)evaluation, null);
            ++this.total_runs;
        } else {
            System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        int idx = this.getMostVisitedActionIdx();
        if (idx == -1) {
            if (DEBUG >= 1) {
                System.out.println("TwoPhaseNaiveMCTS no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        if (DEBUG >= 2) {
            this.tree.showNode(0, 1, this.ef);
        }
        if (DEBUG >= 1) {
            NaiveMCTSNode best = (NaiveMCTSNode)this.tree.children.get(idx);
            System.out.println("TwoPhaseNaiveMCTS selected children " + this.tree.actions.get(idx) + " explored " + best.visit_count + " Avg evaluation: " + best.accum_evaluation / (double)best.visit_count);
        }
        return (PlayerAction)this.tree.actions.get(idx);
    }

    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        int bestIdx = -1;
        NaiveMCTSNode best = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int i = 0; i < this.tree.children.size(); ++i) {
            NaiveMCTSNode child = (NaiveMCTSNode)this.tree.children.get(i);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + child.accum_evaluation / (double)child.visit_count);
            }
            if (best != null && child.visit_count <= best.visit_count) continue;
            best = child;
            bestIdx = i;
        }
        return bestIdx;
    }

    public int getHighestEvaluationActionIdx() {
        ++this.total_actions_issued;
        int bestIdx = -1;
        NaiveMCTSNode best = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int i = 0; i < this.tree.children.size(); ++i) {
            NaiveMCTSNode child = (NaiveMCTSNode)this.tree.children.get(i);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + child.accum_evaluation / (double)child.visit_count);
            }
            if (best != null && !(child.accum_evaluation / (double)child.visit_count > best.accum_evaluation / (double)best.visit_count)) continue;
            best = child;
            bestIdx = i;
        }
        return bestIdx;
    }

    public void simulate(GameState gs, int time) throws Exception {
        boolean gameover = false;
        do {
            if (gs.isComplete()) {
                gameover = gs.cycle();
                continue;
            }
            gs.issue(this.randomAI.getAction(0, gs));
            gs.issue(this.randomAI.getAction(1, gs));
        } while (!gameover && gs.getTime() < time);
    }

    public NaiveMCTSNode getTree() {
        return this.tree;
    }

    public GameState getGameStateToStartFrom() {
        return this.gs_to_start_from;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + "," + this.MAX_TREE_DEPTH + "," + this.phase1_epsilon_l + ", " + this.phase1_epsilon_g + ", " + this.phase1_epsilon_0 + ", " + this.phase2_epsilon_l + ", " + this.phase2_epsilon_g + ", " + this.phase2_epsilon_0 + ", " + this.phase1_budget + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public String statisticsString() {
        return "Total runs: " + this.total_runs + ", runs per action: " + (float)this.total_runs / (float)this.total_actions_issued + ", runs per cycle: " + (float)this.total_runs / (float)this.total_cycles_executed + ", averate time per cycle: " + (float)this.total_time / (float)this.total_cycles_executed + ", max branching factor: " + this.max_actions_so_far;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        parameters.add(new ParameterSpecification("E1_l", Float.TYPE, 0.3));
        parameters.add(new ParameterSpecification("E1_g", Float.TYPE, 0.0));
        parameters.add(new ParameterSpecification("E1_0", Float.TYPE, 1.0));
        parameters.add(new ParameterSpecification("E2_l", Float.TYPE, 0.3));
        parameters.add(new ParameterSpecification("E2_g", Float.TYPE, 0.0));
        parameters.add(new ParameterSpecification("E2_0", Float.TYPE, 0.0));
        parameters.add(new ParameterSpecification("Phase1_Budget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        parameters.add(new ParameterSpecification("ForceExplorationOfNonSampledActions", Boolean.TYPE, true));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.MAXSIMULATIONTIME = a_pola;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int a_mtd) {
        this.MAX_TREE_DEPTH = a_mtd;
    }

    public float getE1_l() {
        return this.phase1_epsilon_l;
    }

    public void setE1_l(float a_e1_l) {
        this.phase1_epsilon_l = a_e1_l;
    }

    public float getE1_g() {
        return this.phase1_epsilon_g;
    }

    public void setE1_g(float a_e1_g) {
        this.phase1_epsilon_g = a_e1_g;
    }

    public float getE1_0() {
        return this.phase1_epsilon_0;
    }

    public void setE1_0(float a_e1_0) {
        this.phase1_epsilon_0 = a_e1_0;
    }

    public float getE2_l() {
        return this.phase2_epsilon_l;
    }

    public void setE2_l(float a_e2_l) {
        this.phase2_epsilon_l = a_e2_l;
    }

    public float getE2_g() {
        return this.phase2_epsilon_g;
    }

    public void setE2_g(float a_e2_g) {
        this.phase2_epsilon_g = a_e2_g;
    }

    public float getE2_0() {
        return this.phase2_epsilon_0;
    }

    public void setE2_0(float a_e2_0) {
        this.phase2_epsilon_0 = a_e2_0;
    }

    public int getPhase1_Budget() {
        return this.phase1_budget;
    }

    public void setPhase1_Budget(int a_p1b) {
        this.phase1_budget = a_p1b;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI a_dp) {
        this.randomAI = a_dp;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }

    public boolean getForceExplorationOfNonSampledActions() {
        return this.forceExplorationOfNonSampledActions;
    }

    public void setForceExplorationOfNonSampledActions(boolean fensa) {
        this.forceExplorationOfNonSampledActions = fensa;
    }
}

