/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;

public class DownsamplingUCTNode {
    public static int DEBUG = 0;
    static Random r = new Random();
    static float C = 0.05f;
    public int type;
    DownsamplingUCTNode parent;
    public GameState gs;
    int depth = 0;
    boolean hasMoreActions = true;
    PlayerActionGenerator moveGenerator;
    public List<PlayerAction> actions;
    public List<DownsamplingUCTNode> children;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;

    public DownsamplingUCTNode(int maxplayer, int minplayer, GameState a_gs, DownsamplingUCTNode a_parent, long MAXACTIONS, float bound) throws Exception {
        this.parent = a_parent;
        this.gs = a_gs;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = bound;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(maxplayer) || this.gs.canExecuteAnyAction(minplayer))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(maxplayer)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(a_gs, maxplayer);
            this.moveGenerator.randomizeOrder();
        } else if (this.gs.canExecuteAnyAction(minplayer)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(a_gs, minplayer);
            this.moveGenerator.randomizeOrder();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public DownsamplingUCTNode UCTSelectLeaf(int maxplayer, int minplayer, long MAXACTIONS, long cutOffTime, int max_depth) throws Exception {
        if (this.depth >= max_depth) {
            return this;
        }
        if (this.moveGenerator != null && this.actions == null) {
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<DownsamplingUCTNode>();
            if (this.moveGenerator.getSize() > 2L * MAXACTIONS) {
                int i = 0;
                while ((long)i < MAXACTIONS) {
                    this.actions.add(this.moveGenerator.getRandom());
                    ++i;
                }
            } else {
                PlayerAction pa = null;
                long count = 0L;
                do {
                    if ((pa = this.moveGenerator.getNextAction(cutOffTime)) == null) continue;
                    this.actions.add(pa);
                    if (++count >= 2L * MAXACTIONS) break;
                } while (pa != null);
                while ((long)this.actions.size() > MAXACTIONS) {
                    this.actions.remove(r.nextInt(this.actions.size()));
                }
            }
        }
        if (this.hasMoreActions) {
            if (this.moveGenerator == null) {
                return this;
            }
            if (this.children.size() >= this.actions.size()) {
                this.hasMoreActions = false;
            } else {
                PlayerAction a = this.actions.get(this.children.size());
                GameState gs2 = this.gs.cloneIssue(a);
                DownsamplingUCTNode node = new DownsamplingUCTNode(maxplayer, minplayer, gs2.clone(), this, MAXACTIONS, this.evaluation_bound);
                this.children.add(node);
                return node;
            }
        }
        double best_score = 0.0;
        DownsamplingUCTNode best = null;
        for (DownsamplingUCTNode child : this.children) {
            double exploitation = (double)child.accum_evaluation / (double)child.visit_count;
            double exploration = Math.sqrt(Math.log(this.visit_count) / (double)child.visit_count);
            exploitation = this.type == 0 ? (exploitation + (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound) : -(exploitation - (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound);
            double tmp = (double)C * exploitation + exploration;
            if (best != null && !(tmp > best_score)) continue;
            best = child;
            best_score = tmp;
        }
        if (best == null) {
            return this;
        }
        return best.UCTSelectLeaf(maxplayer, minplayer, MAXACTIONS, cutOffTime, max_depth);
    }

    public void showNode(int depth, int maxdepth) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                DownsamplingUCTNode child = this.children.get(i);
                for (int j = 0; j < depth; ++j) {
                    System.out.print("    ");
                }
                System.out.println("child " + this.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + (double)child.accum_evaluation / (double)child.visit_count);
                if (depth >= maxdepth) continue;
                child.showNode(depth + 1, maxdepth);
            }
        }
    }
}

