/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;

public class UCTNode {
    static Random r = new Random();
    public static float C = 0.05f;
    public int type;
    UCTNode parent;
    public GameState gs;
    int depth = 0;
    boolean hasMoreActions = true;
    PlayerActionGenerator moveGenerator;
    public List<PlayerAction> actions;
    public List<UCTNode> children;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;

    public UCTNode(int maxplayer, int minplayer, GameState a_gs, UCTNode a_parent, float bound) throws Exception {
        this.parent = a_parent;
        this.gs = a_gs;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = bound;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(maxplayer) || this.gs.canExecuteAnyAction(minplayer))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(maxplayer)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(a_gs, maxplayer);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNode>();
        } else if (this.gs.canExecuteAnyAction(minplayer)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(a_gs, minplayer);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNode>();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public UCTNode UCTSelectLeaf(int maxplayer, int minplayer, long cutOffTime, int max_depth) throws Exception {
        if (this.depth >= max_depth) {
            return this;
        }
        if (this.hasMoreActions) {
            if (this.moveGenerator == null) {
                return this;
            }
            PlayerAction a = this.moveGenerator.getNextAction(cutOffTime);
            if (a != null) {
                this.actions.add(a);
                GameState gs2 = this.gs.cloneIssue(a);
                UCTNode node = new UCTNode(maxplayer, minplayer, gs2.clone(), this, this.evaluation_bound);
                this.children.add(node);
                return node;
            }
            this.hasMoreActions = false;
        }
        double best_score = 0.0;
        UCTNode best = null;
        for (UCTNode child : this.children) {
            double tmp = this.childValue(child);
            if (best != null && !(tmp > best_score)) continue;
            best = child;
            best_score = tmp;
        }
        if (best == null) {
            return this;
        }
        return best.UCTSelectLeaf(maxplayer, minplayer, cutOffTime, max_depth);
    }

    public double childValue(UCTNode child) {
        double exploitation = (double)child.accum_evaluation / (double)child.visit_count;
        double exploration = Math.sqrt(Math.log(this.visit_count) / (double)child.visit_count);
        exploitation = this.type == 0 ? ((double)this.evaluation_bound + exploitation) / (double)(2.0f * this.evaluation_bound) : ((double)this.evaluation_bound - exploitation) / (double)(2.0f * this.evaluation_bound);
        double tmp = (double)C * exploitation + exploration;
        return tmp;
    }

    public void showNode(int depth, int maxdepth) {
        int mostVisitedIdx = -1;
        Object mostVisited = null;
        for (int i = 0; i < this.children.size(); ++i) {
            UCTNode child = this.children.get(i);
            for (int j = 0; j < depth; ++j) {
                System.out.print("    ");
            }
            System.out.println("child explored " + child.visit_count + " Avg evaluation: " + (double)child.accum_evaluation / (double)child.visit_count + " : " + this.actions.get(i));
            if (depth >= maxdepth) continue;
            child.showNode(depth + 1, maxdepth);
        }
    }
}

