/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;

public class UCTNodeFirstPlayUrgency {
    public static int DEBUG = 0;
    static Random r = new Random();
    public static float C = 0.05f;
    public int type;
    UCTNodeFirstPlayUrgency parent;
    public GameState gs;
    int depth = 0;
    boolean hasMoreActions = true;
    PlayerActionGenerator moveGenerator;
    public List<PlayerAction> actions;
    HashMap<Long, UCTNodeFirstPlayUrgency> childrenMap = new LinkedHashMap<Long, UCTNodeFirstPlayUrgency>();
    public List<UCTNodeFirstPlayUrgency> children;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;
    double FPUvalue = 0.0;

    public UCTNodeFirstPlayUrgency(int maxplayer, int minplayer, GameState a_gs, UCTNodeFirstPlayUrgency a_parent, float bound, double a_FPUValue) throws Exception {
        this.parent = a_parent;
        this.gs = a_gs;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = bound;
        this.FPUvalue = a_FPUValue;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(maxplayer) || this.gs.canExecuteAnyAction(minplayer))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(maxplayer)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(a_gs, maxplayer);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNodeFirstPlayUrgency>();
        } else if (this.gs.canExecuteAnyAction(minplayer)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(a_gs, minplayer);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNodeFirstPlayUrgency>();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public UCTNodeFirstPlayUrgency UCTSelectLeaf(int maxplayer, int minplayer, long cutOffTime, int max_depth) throws Exception {
        if (this.depth >= max_depth) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        double best_score = 0.0;
        UCTNodeFirstPlayUrgency best = null;
        if (DEBUG >= 1) {
            System.out.println("UCTNodeFirstPlayUrgency.UCTSelectLeaf:");
        }
        for (UCTNodeFirstPlayUrgency child : this.children) {
            double tmp = this.childValue(child);
            if (DEBUG >= 1) {
                System.out.println("  " + tmp);
            }
            if (best != null && !(tmp > best_score)) continue;
            best = child;
            best_score = tmp;
        }
        if (best != null && best_score > this.FPUvalue) {
            return best.UCTSelectLeaf(maxplayer, minplayer, cutOffTime, max_depth);
        }
        if (this.moveGenerator != null) {
            int attemptsLeft;
            PlayerAction a = this.moveGenerator.getRandom();
            long index = this.moveGenerator.getActionIndex(a);
            for (attemptsLeft = 50; this.childrenMap.containsKey(index) && attemptsLeft > 0; --attemptsLeft) {
                a = this.moveGenerator.getRandom();
                index = this.moveGenerator.getActionIndex(a);
            }
            if (attemptsLeft > 0) {
                this.actions.add(a);
                GameState gs2 = this.gs.cloneIssue(a);
                UCTNodeFirstPlayUrgency node = new UCTNodeFirstPlayUrgency(maxplayer, minplayer, gs2.clone(), this, this.evaluation_bound, this.FPUvalue);
                this.children.add(node);
                this.childrenMap.put(index, node);
                return node;
            }
        }
        if (best == null) {
            return this;
        }
        return best.UCTSelectLeaf(maxplayer, minplayer, cutOffTime, max_depth);
    }

    public double childValue(UCTNodeFirstPlayUrgency child) {
        double exploitation = (double)child.accum_evaluation / (double)child.visit_count;
        double exploration = Math.sqrt(Math.log(this.visit_count) / (double)child.visit_count);
        exploitation = this.type == 0 ? (exploitation + (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound) : -(exploitation - (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound);
        double tmp = exploitation + (double)C * exploration;
        return tmp;
    }

    public void showNode(int depth, int maxdepth) {
        int mostVisitedIdx = -1;
        Object mostVisited = null;
        for (int i = 0; i < this.children.size(); ++i) {
            UCTNodeFirstPlayUrgency child = this.children.get(i);
            for (int j = 0; j < depth; ++j) {
                System.out.print("    ");
            }
            System.out.println("child explored " + child.visit_count + " Avg evaluation: " + (double)child.accum_evaluation / (double)child.visit_count + " : " + this.actions.get(i));
            if (depth >= maxdepth) continue;
            child.showNode(depth + 1, maxdepth);
        }
    }
}

