/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.uct.UCTUnitActionsNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class UCTUnitActions
extends AIWithComputationBudget
implements InterruptibleAI {
    public static final int DEBUG = 0;
    EvaluationFunction ef;
    Random r = new Random();
    AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from;
    UCTUnitActionsNode tree;
    int MAX_TREE_DEPTH = 10;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    int MAXSIMULATIONTIME = 1024;
    int playerForThisComputation;

    public UCTUnitActions(UnitTypeTable utt) {
        this(100, -1, 100, 10, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public UCTUnitActions(int available_time, int available_playouts, int lookahead, int max_depth, AI policy, EvaluationFunction a_ef) {
        super(available_time, available_playouts);
        this.MAXSIMULATIONTIME = lookahead;
        this.randomAI = policy;
        this.MAX_TREE_DEPTH = max_depth;
        this.ef = a_ef;
    }

    @Override
    public void printStats() {
        if (this.total_cycles_executed > 0L && this.total_actions_issued > 0L) {
            System.out.println("Average runs per cycle: " + (double)this.total_runs / (double)this.total_cycles_executed);
            System.out.println("Average runs per action: " + (double)this.total_runs / (double)this.total_actions_issued);
        }
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.tree = null;
    }

    @Override
    public AI clone() {
        return new UCTUnitActions(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.randomAI, this.ef);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) {
        this.playerForThisComputation = a_player;
        float evaluation_bound = this.ef.upperBound(gs);
        this.tree = new UCTUnitActionsNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gs, null, evaluation_bound);
        this.gs_to_start_from = gs;
    }

    public void resetSearch() {
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long start;
        long end = start = System.currentTimeMillis();
        long count = 0L;
        do {
            UCTUnitActionsNode leaf;
            if ((leaf = this.tree.UCTSelectLeaf(this.playerForThisComputation, 1 - this.playerForThisComputation, this.MAX_TREE_DEPTH)) == null) {
                System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
                break;
            }
            GameState gs2 = leaf.gs.clone();
            this.simulate(gs2, gs2.getTime() + this.MAXSIMULATIONTIME);
            int time = gs2.getTime() - this.gs_to_start_from.getTime();
            double evaluation = (double)this.ef.evaluate(this.playerForThisComputation, 1 - this.playerForThisComputation, gs2) * Math.pow(0.99, (double)time / 10.0);
            while (leaf != null) {
                leaf.accum_evaluation = (float)((double)leaf.accum_evaluation + evaluation);
                ++leaf.visit_count;
                leaf = leaf.parent;
            }
            ++this.total_runs;
            end = System.currentTimeMillis();
        } while ((this.TIME_BUDGET < 0 || end - start < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++count < (long)this.ITERATIONS_BUDGET));
        ++this.total_cycles_executed;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        if (this.tree.children == null) {
            return new PlayerAction();
        }
        return this.getMostVisited(this.tree, this.gs_to_start_from.getTime());
    }

    public PlayerAction getMostVisited(UCTUnitActionsNode current, int time) {
        if (current.type != 0 || current.gs.getTime() != time) {
            return null;
        }
        int mostVisitedIdx = -1;
        UCTUnitActionsNode mostVisited = null;
        for (int i = 0; i < current.children.size(); ++i) {
            UCTUnitActionsNode child = current.children.get(i);
            if (mostVisited != null && child.visit_count <= mostVisited.visit_count) continue;
            mostVisited = child;
            mostVisitedIdx = i;
        }
        if (mostVisitedIdx == -1) {
            return null;
        }
        PlayerAction mostVisitedAction = current.actions.get(mostVisitedIdx);
        PlayerAction restOfAction = this.getMostVisited(mostVisited, time);
        if (restOfAction != null) {
            mostVisitedAction = mostVisitedAction.merge(restOfAction);
        }
        return mostVisitedAction;
    }

    public void simulate(GameState gs, int time) throws Exception {
        boolean gameover = false;
        do {
            if (gs.isComplete()) {
                gameover = gs.cycle();
                continue;
            }
            gs.issue(this.randomAI.getAction(0, gs));
            gs.issue(this.randomAI.getAction(1, gs));
        } while (!gameover && gs.getTime() < time);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + ", " + this.MAX_TREE_DEPTH + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        parameters.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.MAXSIMULATIONTIME = a_pola;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int a_mtd) {
        this.MAX_TREE_DEPTH = a_mtd;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI a_dp) {
        this.randomAI = a_dp;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }
}

