/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.Unit;

public class UCTUnitActionsNode {
    static Random r = new Random();
    static float C = 0.05f;
    public int type;
    UCTUnitActionsNode parent;
    public GameState gs;
    int depth = 0;
    public List<PlayerAction> actions;
    public List<UCTUnitActionsNode> children;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;

    public UCTUnitActionsNode(int maxplayer, int minplayer, GameState a_gs, UCTUnitActionsNode a_parent, float bound) {
        this.parent = a_parent;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.gs = a_gs;
        this.evaluation_bound = bound;
        PhysicalGameState pgs = a_gs.getPhysicalGameState();
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(maxplayer) || this.gs.canExecuteAnyAction(minplayer))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(maxplayer)) {
            this.type = 0;
            this.actions = null;
            for (Unit u : pgs.getUnits()) {
                if (u.getPlayer() != maxplayer || a_gs.getActionAssignment(u) != null) continue;
                this.actions = a_gs.getPlayerActionsSingleUnit(u);
                break;
            }
            if (this.actions == null) {
                System.err.println("UCTUnitActionNode: error when generating maxplayer node!");
            }
            this.children = new ArrayList<UCTUnitActionsNode>();
        } else if (this.gs.canExecuteAnyAction(minplayer)) {
            this.type = 1;
            this.actions = null;
            for (Unit u : pgs.getUnits()) {
                if (u.getPlayer() != minplayer || a_gs.getActionAssignment(u) != null) continue;
                this.actions = a_gs.getPlayerActionsSingleUnit(u);
                break;
            }
            if (this.actions == null) {
                System.err.println("UCTUnitActionNode: error when generating minplayer node!");
            }
            this.children = new ArrayList<UCTUnitActionsNode>();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public UCTUnitActionsNode UCTSelectLeaf(int maxplayer, int minplayer, int max_depth) {
        PlayerAction a;
        if (this.depth >= max_depth) {
            return this;
        }
        if (this.children == null || this.actions == null) {
            return this;
        }
        if (this.children.size() < this.actions.size() && (a = this.actions.get(this.children.size())) != null) {
            GameState gs2 = this.gs.cloneIssue(a);
            UCTUnitActionsNode node = new UCTUnitActionsNode(maxplayer, minplayer, gs2.clone(), this, this.evaluation_bound);
            this.children.add(node);
            return node;
        }
        double best_score = 0.0;
        UCTUnitActionsNode best = null;
        for (UCTUnitActionsNode child : this.children) {
            double exploitation = (double)child.accum_evaluation / (double)child.visit_count;
            double exploration = Math.sqrt(Math.log((double)this.visit_count / (double)child.visit_count));
            exploitation = this.type == 0 ? (exploitation + (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound) : -(exploitation - (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound);
            double tmp = (double)C * exploitation + exploration;
            if (best != null && !(tmp > best_score)) continue;
            best = child;
            best_score = tmp;
        }
        if (best == null) {
            return this;
        }
        return best.UCTSelectLeaf(maxplayer, minplayer, max_depth);
    }

    public void showNode(int depth, int maxdepth) {
        int mostVisitedIdx = -1;
        Object mostVisited = null;
        for (int i = 0; i < this.children.size(); ++i) {
            UCTUnitActionsNode child = this.children.get(i);
            for (int j = 0; j < depth; ++j) {
                System.out.print("    ");
            }
            System.out.println("child " + this.actions.get(i) + " explored " + child.visit_count + " Avg evaluation: " + (double)child.accum_evaluation / (double)child.visit_count);
            if (depth >= maxdepth) continue;
            child.showNode(depth + 1, maxdepth);
        }
    }
}

