/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.ABCD;

import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.MiniMaxResult;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;

public class ABCD
extends AI {
    public static int DEBUG = 0;
    int nLeaves = 0;
    int nNodes = 0;
    int max_depth_so_far = 0;
    long max_branching_so_far = 0L;
    long max_leaves_so_far = 0L;
    long max_nodes_so_far = 0L;
    int MAXDEPTH = 4;
    AI playoutAI;
    int maxPlayoutTime = 100;
    EvaluationFunction ef;
    protected int defaultNONEduration = 8;

    public ABCD(UnitTypeTable utt) {
        this(4, new WorkerRush(utt, new AStarPathFinding()), 100, new SimpleSqrtEvaluationFunction3());
    }

    public ABCD(int md, AI a_playoutAI, int a_maxPlayoutTime, EvaluationFunction a_ef) {
        this.MAXDEPTH = md;
        this.playoutAI = a_playoutAI;
        this.maxPlayoutTime = a_maxPlayoutTime;
        this.ef = a_ef;
    }

    @Override
    public void reset() {
        this.max_depth_so_far = 0;
        this.max_branching_so_far = 0L;
        this.max_leaves_so_far = 0L;
        this.max_nodes_so_far = 0L;
    }

    @Override
    public AI clone() {
        return new ABCD(this.MAXDEPTH, this.playoutAI, this.maxPlayoutTime, this.ef);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player) && gs.winner() == -1) {
            PlayerAction pa = this.ABCD(player, gs, this.MAXDEPTH);
            pa.fillWithNones(gs, player, this.defaultNONEduration);
            return pa;
        }
        return new PlayerAction();
    }

    public PlayerAction ABCD(int player, GameState gs, int depthLeft) throws Exception {
        long start = System.currentTimeMillis();
        float alpha = -EvaluationFunction.VICTORY;
        float beta = EvaluationFunction.VICTORY;
        int maxplayer = player;
        int minplayer = 1 - player;
        if (DEBUG >= 1) {
            System.out.println("Starting ABCD... " + player);
        }
        if ((long)this.nLeaves > this.max_leaves_so_far) {
            this.max_leaves_so_far = this.nLeaves;
        }
        if ((long)this.nNodes > this.max_nodes_so_far) {
            this.max_nodes_so_far = this.nNodes;
        }
        this.nLeaves = 0;
        this.nNodes = 0;
        MiniMaxResult bestMove = this.ABCD(gs, maxplayer, minplayer, alpha, beta, depthLeft, maxplayer);
        if (DEBUG >= 1) {
            System.out.println("ABCD: " + bestMove + " in " + (System.currentTimeMillis() - start));
        }
        return bestMove.action;
    }

    public MiniMaxResult ABCD(GameState gs, int maxplayer, int minplayer, float alpha, float beta, int depthLeft, int nextPlayerInSimultaneousNode) throws Exception {
        ++this.nNodes;
        if (depthLeft <= 0 || gs.winner() != -1) {
            ++this.nLeaves;
            GameState gs2 = gs.clone();
            AI playoutAI1 = this.playoutAI.clone();
            AI playoutAI2 = this.playoutAI.clone();
            int timeOut = gs2.getTime() + this.maxPlayoutTime;
            boolean gameover = false;
            while (!gameover && gs2.getTime() < timeOut) {
                if (gs2.isComplete()) {
                    gameover = gs2.cycle();
                    continue;
                }
                gs2.issue(playoutAI1.getAction(0, gs2));
                gs2.issue(playoutAI2.getAction(1, gs2));
            }
            return new MiniMaxResult(null, this.ef.evaluate(maxplayer, minplayer, gs2), gs2);
        }
        int toMove = -1;
        if (gs.canExecuteAnyAction(maxplayer)) {
            if (gs.canExecuteAnyAction(minplayer)) {
                toMove = nextPlayerInSimultaneousNode;
                nextPlayerInSimultaneousNode = 1 - nextPlayerInSimultaneousNode;
            } else {
                toMove = maxplayer;
            }
        } else if (gs.canExecuteAnyAction(minplayer)) {
            toMove = minplayer;
        }
        if (toMove == maxplayer) {
            PlayerActionGenerator actions2 = new PlayerActionGenerator(gs, maxplayer);
            long l = actions2.getSize();
            if (l > this.max_branching_so_far) {
                this.max_branching_so_far = l;
            }
            MiniMaxResult best = null;
            PlayerAction next = null;
            do {
                if ((next = actions2.getNextAction(-1L)) == null) continue;
                GameState gs2 = gs.cloneIssue(next);
                MiniMaxResult tmp = this.ABCD(gs2, maxplayer, minplayer, alpha, beta, depthLeft - 1, nextPlayerInSimultaneousNode);
                alpha = Math.max(alpha, tmp.evaluation);
                if (best == null || tmp.evaluation > best.evaluation) {
                    best = tmp;
                    best.action = next;
                }
                if (!(beta <= alpha)) continue;
                return best;
            } while (next != null);
            return best;
        }
        if (toMove == minplayer) {
            PlayerActionGenerator actions3 = new PlayerActionGenerator(gs, minplayer);
            long l = actions3.getSize();
            if (l > this.max_branching_so_far) {
                this.max_branching_so_far = l;
            }
            MiniMaxResult best = null;
            PlayerAction next = null;
            do {
                if ((next = actions3.getNextAction(-1L)) == null) continue;
                GameState gs2 = gs.cloneIssue(next);
                MiniMaxResult tmp = this.ABCD(gs2, maxplayer, minplayer, alpha, beta, depthLeft - 1, nextPlayerInSimultaneousNode);
                beta = Math.min(beta, tmp.evaluation);
                if (best == null || tmp.evaluation < best.evaluation) {
                    best = tmp;
                    best.action = next;
                }
                if (!(beta <= alpha)) continue;
                return best;
            } while (next != null);
            return best;
        }
        GameState gs2 = gs.clone();
        while (!(gs2.winner() != -1 || gs2.gameover() || gs2.canExecuteAnyAction(maxplayer) || gs2.canExecuteAnyAction(minplayer))) {
            gs2.cycle();
        }
        return this.ABCD(gs2, maxplayer, minplayer, alpha, beta, depthLeft, nextPlayerInSimultaneousNode);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.MAXDEPTH + ", " + this.playoutAI + ", " + this.maxPlayoutTime + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("MaxDepth", Integer.TYPE, 4));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("PlayoutAI", AI.class, this.playoutAI));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getMaxDepth() {
        return this.MAXDEPTH;
    }

    public void setMaxDepth(int a_md) {
        this.MAXDEPTH = a_md;
    }

    public int getPlayoutLookahead() {
        return this.maxPlayoutTime;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.maxPlayoutTime = a_pola;
    }

    public AI getPlayoutAI() {
        return this.playoutAI;
    }

    public void setPlayoutAI(AI a_dp) {
        this.playoutAI = a_dp;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }
}

