/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.ABCD;

import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.ABCD.ABCDNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;
import util.Pair;

public class IDABCD
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    int MAX_DEPTH = 50;
    int avg_depth_so_far = 0;
    int count_depth_so_far = 0;
    long avg_branching_so_far = 0L;
    int count_branching_so_far = 0;
    long avg_leaves_so_far = 0L;
    int count_leaves_so_far = 0;
    long avg_nodes_so_far = 0L;
    int count_nodes_so_far = 0;
    long max_potential_branching_so_far = 0L;
    long avg_potential_branching_so_far = 0L;
    int count_potential_branching_so_far = 0;
    int nPlayouts = 0;
    int nLeaves = 0;
    int nNodes = 0;
    int max_depth_so_far = 0;
    long max_branching_so_far = 0L;
    long max_leaves_so_far = 0L;
    long max_nodes_so_far = 0L;
    AI playoutAI;
    int maxPlayoutTime = 100;
    EvaluationFunction ef;
    boolean performGreedyActionScan = false;
    int max_consecutive_frames_searching_so_far = 0;
    GameState gs_to_start_from;
    int consecutive_frames_searching = 0;
    int last_depth = 1;
    int last_nleaves = 0;
    int last_nnodes = 0;
    int last_time_depth = 0;
    int time_depth = 0;
    int max_time_depth_so_far = 0;
    long avg_time_depth_so_far = 0L;
    double count_time_depth_so_far = 0.0;
    boolean treeIsComplete = true;
    List<ABCDNode> stack;
    Pair<PlayerAction, Float> lastResult;
    PlayerAction bestMove;
    int playerForThisComputation;

    public IDABCD(UnitTypeTable utt) {
        this(100, -1, new WorkerRush(utt, new AStarPathFinding()), 100, new SimpleSqrtEvaluationFunction3(), true);
    }

    public IDABCD(int tpc, int ppc, AI a_playoutAI, int a_maxPlayoutTime, EvaluationFunction a_ef, boolean a_performGreedyActionScan) {
        super(tpc, ppc);
        this.playoutAI = a_playoutAI;
        this.maxPlayoutTime = a_maxPlayoutTime;
        this.ef = a_ef;
        this.performGreedyActionScan = a_performGreedyActionScan;
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.consecutive_frames_searching = 0;
        this.stack = null;
        this.lastResult = null;
        this.bestMove = null;
        this.treeIsComplete = true;
        this.max_depth_so_far = 0;
        this.max_branching_so_far = 0L;
        this.max_leaves_so_far = 0L;
        this.max_nodes_so_far = 0L;
        this.avg_depth_so_far = 0;
        this.count_depth_so_far = 0;
        this.avg_branching_so_far = 0L;
        this.count_branching_so_far = 0;
        this.avg_leaves_so_far = 0L;
        this.count_leaves_so_far = 0;
        this.avg_nodes_so_far = 0L;
        this.count_nodes_so_far = 0;
        this.avg_time_depth_so_far = 0L;
        this.count_time_depth_so_far = 0.0;
        this.max_time_depth_so_far = 0;
        this.max_potential_branching_so_far = 0L;
        this.avg_potential_branching_so_far = 0L;
        this.count_potential_branching_so_far = 0;
    }

    @Override
    public AI clone() {
        return new IDABCD(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.playoutAI, this.maxPlayoutTime, this.ef, this.performGreedyActionScan);
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        this.consecutive_frames_searching = 0;
        this.stack = null;
        this.last_depth = 1;
        this.last_nleaves = 0;
        this.last_nnodes = 0;
        this.last_time_depth = 0;
        this.gs_to_start_from = gs;
        this.playerForThisComputation = a_player;
        this.bestMove = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        int maxplayer = this.playerForThisComputation;
        int minplayer = 1 - this.playerForThisComputation;
        int depth = 1;
        long startTime = System.currentTimeMillis();
        long cutOffTime = startTime + (long)this.TIME_BUDGET;
        if (this.TIME_BUDGET <= 0) {
            cutOffTime = 0L;
        }
        this.nPlayouts = 0;
        if (this.bestMove == null && this.performGreedyActionScan) {
            this.bestMove = this.greedyActionScan(this.gs_to_start_from, this.playerForThisComputation, cutOffTime, this.ITERATIONS_BUDGET);
        }
        if (cutOffTime > 0L && System.currentTimeMillis() >= cutOffTime) {
            return;
        }
        ++this.consecutive_frames_searching;
        do {
            if (this.stack != null) {
                depth = this.last_depth;
            }
            if (DEBUG >= 1) {
                System.out.println("  next depth: " + depth);
            }
            long currentTime = System.currentTimeMillis();
            PlayerAction tmp = this.searchOutsideStack(this.gs_to_start_from, maxplayer, minplayer, depth, cutOffTime, this.ITERATIONS_BUDGET, false);
            if (DEBUG >= 1) {
                System.out.println("    Time taken: " + (System.currentTimeMillis() - currentTime) + ", nPlayouts: " + this.nPlayouts);
            }
            if (tmp != null) {
                this.bestMove = tmp;
                if (depth > this.max_depth_so_far) {
                    this.max_depth_so_far = depth;
                }
            }
            if (this.stack.isEmpty()) {
                if ((long)this.nLeaves > this.max_leaves_so_far) {
                    this.max_leaves_so_far = this.nLeaves;
                }
                if ((long)this.nNodes > this.max_nodes_so_far) {
                    this.max_nodes_so_far = this.nNodes;
                }
                this.last_nleaves = this.nLeaves;
                this.last_nnodes = this.nNodes;
                this.last_time_depth = this.time_depth;
                this.stack = null;
                if (this.treeIsComplete || ++depth > this.MAX_DEPTH) break;
            }
            this.nLeaves = 0;
            this.nNodes = 0;
            this.time_depth = 0;
        } while ((this.ITERATIONS_BUDGET <= 0 || this.nPlayouts < this.ITERATIONS_BUDGET) && (cutOffTime <= 0L || System.currentTimeMillis() < cutOffTime));
        this.last_depth = depth;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        this.avg_depth_so_far += this.last_depth;
        ++this.count_depth_so_far;
        this.avg_leaves_so_far += (long)this.last_nleaves;
        ++this.count_leaves_so_far;
        this.avg_nodes_so_far += (long)this.last_nnodes;
        ++this.count_nodes_so_far;
        this.avg_time_depth_so_far += (long)this.last_time_depth;
        this.count_time_depth_so_far += 1.0;
        if (this.last_time_depth > this.max_time_depth_so_far) {
            this.max_time_depth_so_far = this.last_time_depth;
        }
        if (this.bestMove == null) {
            PlayerActionGenerator pag = new PlayerActionGenerator(this.gs_to_start_from, this.playerForThisComputation);
            return pag.getRandom();
        }
        return this.bestMove;
    }

    public PlayerAction greedyActionScan(GameState gs, int player, long cutOffTime, int maxPlayouts) throws Exception {
        PlayerAction best = null;
        float bestScore = 0.0f;
        PlayerActionGenerator pag = new PlayerActionGenerator(gs, player);
        PlayerAction pa = null;
        do {
            if ((pa = pag.getNextAction(cutOffTime)) != null) {
                GameState gs2 = gs.cloneIssue(pa);
                float score = this.ef.evaluate(player, 1 - player, gs2);
                if (best == null || score > bestScore) {
                    best = pa;
                    bestScore = score;
                }
            }
            if (cutOffTime <= 0L || System.currentTimeMillis() <= cutOffTime) continue;
            return best;
        } while (pa != null);
        return best;
    }

    public PlayerAction searchOutsideStack(GameState initial_gs, int maxplayer, int minplayer, int depth, long cutOffTime, int maxPlayouts, boolean needAResult) throws Exception {
        ABCDNode head;
        if (this.stack == null) {
            this.nLeaves = 0;
            this.time_depth = 0;
            this.stack = new LinkedList<ABCDNode>();
            head = new ABCDNode(-1, 0, initial_gs, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, 0);
            this.stack.add(head);
            this.treeIsComplete = true;
        } else {
            if (this.stack.isEmpty()) {
                return (PlayerAction)this.lastResult.m_a;
            }
            head = this.stack.get(this.stack.size() - 1);
        }
        block6: while (!(this.stack.isEmpty() || cutOffTime > 0L && System.currentTimeMillis() >= cutOffTime || maxPlayouts > 0 && this.nPlayouts >= maxPlayouts)) {
            ABCDNode current = this.stack.get(0);
            if (DEBUG >= 2) {
                for (int i = 0; i < current.depth; ++i) {
                    System.out.print(" ");
                }
                System.out.println("Node: " + current.type);
            }
            switch (current.type) {
                case -1: {
                    int winner = current.gs.winner();
                    boolean gameover = current.gs.gameover();
                    if (current.depth >= depth || winner != -1 || gameover) {
                        if (current.gs.getTime() - initial_gs.getTime() > this.time_depth) {
                            this.time_depth = current.gs.getTime() - initial_gs.getTime();
                        }
                        ++this.nLeaves;
                        ++this.nNodes;
                        ++this.nPlayouts;
                        if (DEBUG >= 2) {
                            for (int i = 0; i < current.depth; ++i) {
                                System.out.print(" ");
                            }
                            System.out.println("playout!");
                        }
                        GameState gs2 = current.gs.clone();
                        AI playoutAI1 = this.playoutAI.clone();
                        AI playoutAI2 = this.playoutAI.clone();
                        int timeOut = gs2.getTime() + this.maxPlayoutTime;
                        if (!gs2.gameover()) {
                            this.treeIsComplete = false;
                        }
                        gameover = false;
                        while (!gameover && gs2.getTime() < timeOut) {
                            if (gs2.isComplete()) {
                                gameover = gs2.cycle();
                                continue;
                            }
                            gs2.issue(playoutAI1.getAction(0, gs2));
                            gs2.issue(playoutAI2.getAction(1, gs2));
                        }
                        this.lastResult = new Pair<Object, Float>(null, Float.valueOf(this.ef.evaluate(maxplayer, minplayer, gs2)));
                        this.stack.remove(0);
                        break;
                    }
                    current.type = 2;
                    if (current.gs.canExecuteAnyAction(maxplayer)) {
                        if (current.gs.canExecuteAnyAction(minplayer)) {
                            current.type = current.nextPlayerInSimultaneousNode;
                            current.nextPlayerInSimultaneousNode = 1 - current.nextPlayerInSimultaneousNode;
                            break;
                        }
                        current.type = 0;
                        break;
                    }
                    if (!current.gs.canExecuteAnyAction(minplayer)) continue block6;
                    current.type = 1;
                    break;
                }
                case 0: {
                    GameState gs2;
                    PlayerAction next;
                    ++this.nNodes;
                    if (current.actions == null) {
                        current.actions = new PlayerActionGenerator(current.gs, maxplayer);
                        current.actions.randomizeOrder();
                        long l = current.actions.getSize();
                        if (DEBUG >= 2) {
                            for (int i = 0; i < current.depth; ++i) {
                                System.out.print(" ");
                            }
                            System.out.println("PlayerGenerator moves: " + l + "(cutOffTime: " + cutOffTime + ")");
                        }
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        this.avg_potential_branching_so_far += l;
                        ++this.count_potential_branching_so_far;
                        current.best = null;
                        next = current.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        gs2 = current.gs.cloneIssue(next);
                        this.stack.add(0, new ABCDNode(-1, current.depth + 1, gs2, current.alpha, current.beta, current.nextPlayerInSimultaneousNode));
                        break;
                    }
                    current.alpha = Math.max(current.alpha, ((Float)this.lastResult.m_b).floatValue());
                    if (current.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)current.best.m_b).floatValue()) {
                        current.best = this.lastResult;
                        current.best.m_a = current.actions.getLastAction();
                    }
                    PlayerAction next2 = current.actions.getNextAction(cutOffTime);
                    if (DEBUG >= 2) {
                        for (int i = 0; i < current.depth; ++i) {
                            System.out.print(" ");
                        }
                        System.out.println("alpha: " + current.alpha + ", beta: " + current.beta + ", next: " + next2);
                    }
                    if (current.beta <= current.alpha || next2 == null) {
                        this.lastResult = current.best;
                        this.stack.remove(0);
                        if (current.actions.getGenerated() > this.max_branching_so_far) {
                            this.max_branching_so_far = current.actions.getGenerated();
                        }
                        this.avg_branching_so_far += current.actions.getGenerated();
                        ++this.count_branching_so_far;
                        break;
                    }
                    GameState gs22 = current.gs.cloneIssue(next2);
                    this.stack.add(0, new ABCDNode(-1, current.depth + 1, gs22, current.alpha, current.beta, current.nextPlayerInSimultaneousNode));
                    break;
                }
                case 1: {
                    GameState gs2;
                    PlayerAction next;
                    ++this.nNodes;
                    if (current.actions == null) {
                        current.actions = new PlayerActionGenerator(current.gs, minplayer);
                        current.actions.randomizeOrder();
                        long l = current.actions.getSize();
                        if (DEBUG >= 2) {
                            for (int i = 0; i < current.depth; ++i) {
                                System.out.print(" ");
                            }
                            System.out.println("PlayerGenerator moves: " + l);
                        }
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        this.avg_potential_branching_so_far += l;
                        ++this.count_potential_branching_so_far;
                        current.best = null;
                        next = current.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        gs2 = current.gs.cloneIssue(next);
                        this.stack.add(0, new ABCDNode(-1, current.depth + 1, gs2, current.alpha, current.beta, current.nextPlayerInSimultaneousNode));
                        break;
                    }
                    current.beta = Math.min(current.beta, ((Float)this.lastResult.m_b).floatValue());
                    if (current.best == null || ((Float)this.lastResult.m_b).floatValue() < ((Float)current.best.m_b).floatValue()) {
                        current.best = this.lastResult;
                        current.best.m_a = current.actions.getLastAction();
                    }
                    PlayerAction next3 = current.actions.getNextAction(cutOffTime);
                    if (current.beta <= current.alpha || next3 == null) {
                        this.lastResult = current.best;
                        this.stack.remove(0);
                        if (current.actions.getGenerated() > this.max_branching_so_far) {
                            this.max_branching_so_far = current.actions.getGenerated();
                        }
                        this.avg_branching_so_far += current.actions.getGenerated();
                        ++this.count_branching_so_far;
                        break;
                    }
                    GameState gs23 = current.gs.cloneIssue(next3);
                    this.stack.add(0, new ABCDNode(-1, current.depth + 1, gs23, current.alpha, current.beta, current.nextPlayerInSimultaneousNode));
                    break;
                }
                case 2: {
                    ++this.nNodes;
                    current.gs = current.gs.clone();
                    while (!(current.gs.winner() != -1 || current.gs.gameover() || current.gs.canExecuteAnyAction(maxplayer) || current.gs.canExecuteAnyAction(minplayer))) {
                        current.gs.cycle();
                    }
                    current.type = -1;
                }
            }
        }
        if (this.stack.isEmpty()) {
            return (PlayerAction)this.lastResult.m_a;
        }
        if (needAResult) {
            if (head.best != null) {
                return (PlayerAction)head.best.m_a;
            }
            return head.actions.getRandom();
        }
        return null;
    }

    @Override
    public String statisticsString() {
        return "avg depth: " + (double)this.avg_depth_so_far / (double)this.count_depth_so_far + " , max depth: " + this.max_depth_so_far + " , avg branching factor: " + (double)this.avg_branching_so_far / (double)this.count_branching_so_far + " , max branching factor: " + this.max_branching_so_far + " , avg potential branching factor: " + (double)this.avg_potential_branching_so_far / (double)this.count_potential_branching_so_far + " , max potential branching factor: " + this.max_potential_branching_so_far + " , avg leaves: " + (double)this.avg_leaves_so_far / (double)this.count_leaves_so_far + " , max leaves: " + this.max_leaves_so_far + " , avg nodes: " + (double)this.avg_nodes_so_far / (double)this.count_nodes_so_far + " , max nodes: " + this.max_nodes_so_far + " , avg time depth: " + (double)this.avg_time_depth_so_far / this.count_time_depth_so_far + " , max time depth: " + this.max_time_depth_so_far;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.playoutAI + ", " + this.maxPlayoutTime + ", " + this.ef + ", " + this.performGreedyActionScan + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutAI", AI.class, this.playoutAI));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        parameters.add(new ParameterSpecification("PerformGreedyActionScan", Boolean.TYPE, true));
        return parameters;
    }

    public AI getPlayoutAI() {
        return this.playoutAI;
    }

    public void setPlayoutAI(AI a_dp) {
        this.playoutAI = a_dp;
    }

    public int getPlayoutLookahead() {
        return this.maxPlayoutTime;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.maxPlayoutTime = a_pola;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }

    public boolean getPerformGreedyActionScan() {
        return this.performGreedyActionScan;
    }

    public void setPerformGreedyActionScan(boolean a_pgas) {
        this.performGreedyActionScan = a_pgas;
    }
}

