/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.RTMiniMax;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.EvaluationFunctionForwarding;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.RTMiniMax.RTMiniMaxNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;
import util.Pair;

public class IDRTMinimax
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    static int minCT = -1;
    static int maxCT = -1;
    static int nLeaves = 0;
    public long max_branching_so_far = 0L;
    public long max_leaves_so_far = 0L;
    int LOOKAHEAD = 1;
    protected int defaultNONEduration = 8;
    EvaluationFunction ef;
    int max_depth_so_far = 0;
    long max_potential_branching_so_far = 0L;
    int max_consecutive_frames_searching_so_far = 0;
    GameState gs_to_start_from;
    int consecutive_frames_searching = 0;
    int last_lookAhead = 1;
    List<RTMiniMaxNode> stack;
    Pair<PlayerAction, Float> lastResult;
    PlayerAction bestMove;
    Random r = new Random();
    int playerForThisComputation;

    public IDRTMinimax(UnitTypeTable utt) {
        this(100, new SimpleSqrtEvaluationFunction3());
    }

    public IDRTMinimax(int available_time, EvaluationFunction a_ef) {
        super(available_time, -1);
        this.ef = a_ef;
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.consecutive_frames_searching = 0;
        this.stack = null;
        this.lastResult = null;
        this.bestMove = null;
    }

    @Override
    public AI clone() {
        return new IDRTMinimax(this.TIME_BUDGET, this.ef);
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        this.playerForThisComputation = a_player;
        this.stack = null;
        this.last_lookAhead = 1;
        this.gs_to_start_from = gs;
        this.bestMove = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        int maxplayer = this.playerForThisComputation;
        int minplayer = 1 - this.playerForThisComputation;
        int lookAhead = 1;
        long startTime = System.currentTimeMillis();
        long cutOffTime = startTime + (long)this.TIME_BUDGET;
        if (this.bestMove == null) {
            this.bestMove = this.greedyActionScan(this.gs_to_start_from, this.playerForThisComputation, cutOffTime);
        }
        if (System.currentTimeMillis() >= cutOffTime) {
            return;
        }
        ++this.consecutive_frames_searching;
        do {
            if (this.stack == null) {
                if ((long)nLeaves > this.max_leaves_so_far) {
                    this.max_leaves_so_far = nLeaves;
                }
                minCT = -1;
                maxCT = -1;
                nLeaves = 0;
            } else {
                lookAhead = this.last_lookAhead;
            }
            PlayerAction tmp = this.timeBoundedRealTimeMinimaxABOutsideStack(this.gs_to_start_from, maxplayer, minplayer, this.gs_to_start_from.getTime() + lookAhead, cutOffTime, false);
            if (tmp != null) {
                this.bestMove = tmp;
                if (lookAhead > this.max_depth_so_far) {
                    this.max_depth_so_far = lookAhead;
                }
            }
            if (!this.stack.isEmpty()) continue;
            this.stack = null;
            int nextLookAhead = Math.max(minCT + 1 - this.gs_to_start_from.getTime(), lookAhead + 4);
            if (minCT == -1 && maxCT == -1 || nextLookAhead <= lookAhead) {
                return;
            }
            lookAhead = nextLookAhead;
        } while (System.currentTimeMillis() - startTime < (long)this.TIME_BUDGET);
        this.last_lookAhead = lookAhead;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        return this.bestMove;
    }

    public PlayerAction timeBoundedRealTimeMinimaxABOutsideStack(GameState initial_gs, int maxplayer, int minplayer, int lookAhead, long cutOffTime, boolean needAResult) throws Exception {
        RTMiniMaxNode head;
        if (this.stack == null) {
            this.stack = new LinkedList<RTMiniMaxNode>();
            head = new RTMiniMaxNode(0, initial_gs, -EvaluationFunctionForwarding.VICTORY, EvaluationFunctionForwarding.VICTORY);
            this.stack.add(head);
        } else {
            if (this.stack.isEmpty()) {
                return (PlayerAction)this.lastResult.m_a;
            }
            head = this.stack.get(this.stack.size() - 1);
        }
        block6: while (!this.stack.isEmpty() && System.currentTimeMillis() < cutOffTime) {
            RTMiniMaxNode current = this.stack.get(0);
            switch (current.type) {
                case -1: {
                    int winner = current.gs.winner();
                    if (current.gs.getTime() >= lookAhead || winner != -1) {
                        if (winner == -1) {
                            int CT = current.gs.getNextChangeTime();
                            if (minCT == -1 || CT < minCT) {
                                minCT = CT;
                            }
                            if (maxCT == -1 || CT > maxCT) {
                                maxCT = CT;
                            }
                        }
                        ++nLeaves;
                        this.lastResult = new Pair<Object, Float>(null, Float.valueOf(this.ef.evaluate(maxplayer, minplayer, current.gs)));
                        this.stack.remove(0);
                        break;
                    }
                    if (current.gs.canExecuteAnyAction(maxplayer)) {
                        current.type = 0;
                        break;
                    }
                    if (current.gs.canExecuteAnyAction(minplayer)) {
                        current.type = 1;
                        break;
                    }
                    current.type = 2;
                    break;
                }
                case 0: {
                    GameState gs2;
                    PlayerAction next;
                    if (current.actions == null) {
                        current.actions = new PlayerActionGenerator(current.gs, maxplayer);
                        long l = current.actions.getSize();
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        current.best = null;
                        next = current.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        gs2 = current.gs.cloneIssue(next);
                        this.stack.add(0, new RTMiniMaxNode(-1, gs2, current.alpha, current.beta));
                        break;
                    }
                    current.alpha = Math.max(current.alpha, ((Float)this.lastResult.m_b).floatValue());
                    if (current.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)current.best.m_b).floatValue()) {
                        current.best = this.lastResult;
                        current.best.m_a = current.actions.getLastAction();
                    }
                    PlayerAction next2 = current.actions.getNextAction(cutOffTime);
                    if (current.beta <= current.alpha || next2 == null) {
                        this.lastResult = current.best;
                        this.stack.remove(0);
                        if (current.actions.getGenerated() <= this.max_branching_so_far) continue block6;
                        this.max_branching_so_far = current.actions.getGenerated();
                        break;
                    }
                    GameState gs22 = current.gs.cloneIssue(next2);
                    this.stack.add(0, new RTMiniMaxNode(-1, gs22, current.alpha, current.beta));
                    break;
                }
                case 1: {
                    GameState gs2;
                    PlayerAction next;
                    if (current.actions == null) {
                        current.actions = new PlayerActionGenerator(current.gs, minplayer);
                        long l = current.actions.getSize();
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        current.best = null;
                        next = current.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        gs2 = current.gs.cloneIssue(next);
                        this.stack.add(0, new RTMiniMaxNode(-1, gs2, current.alpha, current.beta));
                        break;
                    }
                    current.beta = Math.min(current.beta, ((Float)this.lastResult.m_b).floatValue());
                    if (current.best == null || ((Float)this.lastResult.m_b).floatValue() < ((Float)current.best.m_b).floatValue()) {
                        current.best = this.lastResult;
                        current.best.m_a = current.actions.getLastAction();
                    }
                    PlayerAction next3 = current.actions.getNextAction(cutOffTime);
                    if (current.beta <= current.alpha || next3 == null) {
                        this.lastResult = current.best;
                        this.stack.remove(0);
                        if (current.actions.getGenerated() <= this.max_branching_so_far) continue block6;
                        this.max_branching_so_far = current.actions.getGenerated();
                        break;
                    }
                    GameState gs23 = current.gs.cloneIssue(next3);
                    this.stack.add(0, new RTMiniMaxNode(-1, gs23, current.alpha, current.beta));
                    break;
                }
                case 2: {
                    current.gs = current.gs.clone();
                    while (!(current.gs.winner() != -1 || current.gs.gameover() || current.gs.canExecuteAnyAction(maxplayer) || current.gs.canExecuteAnyAction(minplayer))) {
                        current.gs.cycle();
                    }
                    current.type = -1;
                }
            }
        }
        if (this.stack.isEmpty()) {
            return (PlayerAction)this.lastResult.m_a;
        }
        if (needAResult) {
            if (head.best != null) {
                return (PlayerAction)head.best.m_a;
            }
            return head.actions.getRandom();
        }
        return null;
    }

    public PlayerAction greedyActionScan(GameState gs, int player, long cutOffTime) throws Exception {
        PlayerAction best = null;
        float bestScore = 0.0f;
        PlayerActionGenerator pag = new PlayerActionGenerator(gs, player);
        PlayerAction pa = null;
        do {
            if ((pa = pag.getNextAction(cutOffTime)) != null) {
                GameState gs2 = gs.cloneIssue(pa);
                float score = this.ef.evaluate(player, 1 - player, gs2);
                if (best == null || score > bestScore) {
                    best = pa;
                    bestScore = score;
                }
            }
            if (System.currentTimeMillis() <= cutOffTime) continue;
            return best;
        } while (pa != null);
        return best;
    }

    @Override
    public String statisticsString() {
        return "max depth: " + this.max_depth_so_far + " , max branching factor (potential): " + this.max_branching_so_far + "(" + this.max_potential_branching_so_far + ") , max leaves: " + this.max_leaves_so_far + " , max consecutive frames: " + this.max_consecutive_frames_searching_so_far;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }
}

