/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.RTMiniMax;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.RTMiniMax.IDRTMinimax;
import ai.minimax.RTMiniMax.RTMiniMaxNode;
import ai.minimax.RTMiniMax.RTMiniMaxRandomizedRootNode;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;
import util.Pair;

public class IDRTMinimaxRandomized
extends IDRTMinimax {
    int m_repeats = 10;

    public IDRTMinimaxRandomized(UnitTypeTable utt) {
        this(100, 10, new SimpleSqrtEvaluationFunction3());
    }

    public IDRTMinimaxRandomized(int tpc, int repeats, EvaluationFunction a_ef) {
        super(tpc, a_ef);
    }

    @Override
    public AI clone() {
        return new IDRTMinimaxRandomized(this.TIME_BUDGET, this.m_repeats, this.ef);
    }

    public PlayerAction timeBoundedRealTimeMinimaxRandomizedABOutsideStack(GameState initial_gs, int maxplayer, int minplayer, int lookAhead, long cutOffTime, boolean needAResult) throws Exception {
        RTMiniMaxNode head;
        if (this.stack == null) {
            this.stack = new LinkedList();
            head = new RTMiniMaxRandomizedRootNode(initial_gs);
            this.stack.add(head);
        } else {
            if (this.stack.isEmpty()) {
                return (PlayerAction)this.lastResult.m_a;
            }
            head = (RTMiniMaxNode)this.stack.get(this.stack.size() - 1);
        }
        block7: while (!this.stack.isEmpty() && System.currentTimeMillis() < cutOffTime) {
            RTMiniMaxNode current = (RTMiniMaxNode)this.stack.get(0);
            switch (current.type) {
                case -1: {
                    int winner = current.gs.winner();
                    if (current.gs.getTime() >= lookAhead || winner != -1) {
                        if (winner == -1) {
                            int CT = current.gs.getNextChangeTime();
                            if (minCT == -1 || CT < minCT) {
                                minCT = CT;
                            }
                            if (maxCT == -1 || CT > maxCT) {
                                maxCT = CT;
                            }
                        }
                        ++nLeaves;
                        this.lastResult = new Pair<Object, Float>(null, Float.valueOf(this.ef.evaluate(maxplayer, minplayer, current.gs)));
                        this.stack.remove(0);
                        break;
                    }
                    if (current.gs.canExecuteAnyAction(maxplayer)) {
                        if (this.stack.size() == 1 || !current.gs.canExecuteAnyAction(minplayer)) {
                            current.type = 0;
                            break;
                        }
                        current.type = this.r.nextInt(2) + 1;
                        break;
                    }
                    if (current.gs.canExecuteAnyAction(minplayer)) {
                        current.type = 1;
                        break;
                    }
                    current.type = 2;
                    break;
                }
                case 3: {
                    int i;
                    RTMiniMaxRandomizedRootNode currentRR = (RTMiniMaxRandomizedRootNode)current;
                    if (currentRR.actions == null) {
                        currentRR.actions = new PlayerActionGenerator(currentRR.gs, maxplayer);
                        currentRR.scores = new float[this.m_repeats];
                        currentRR.iterations_run = 0;
                        long l = currentRR.actions.getSize();
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        currentRR.best = null;
                        PlayerAction next = currentRR.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        GameState gs2 = currentRR.gs.cloneIssue(next);
                        this.stack.add(0, new RTMiniMaxNode(-1, gs2, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY));
                        break;
                    }
                    currentRR.scores[currentRR.iterations_run] = ((Float)this.lastResult.m_b).floatValue();
                    ++currentRR.iterations_run;
                    if (currentRR.iterations_run < this.m_repeats) {
                        PlayerAction next = currentRR.actions.getLastAction();
                        if (next == null) {
                            System.out.println("getLastAction returned null!!! time: " + System.currentTimeMillis() + "  cutOff: " + cutOffTime);
                            System.out.println("Action generator status:");
                            System.out.println(currentRR.actions);
                        }
                        GameState gs2 = currentRR.gs.cloneIssue(next);
                        this.stack.add(0, new RTMiniMaxNode(-1, gs2, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY));
                        break;
                    }
                    float mean = 0.0f;
                    float std_dev = 0.0f;
                    for (i = 0; i < this.m_repeats; ++i) {
                        mean += currentRR.scores[i];
                    }
                    mean /= (float)this.m_repeats;
                    for (i = 0; i < this.m_repeats; ++i) {
                        std_dev += (mean - currentRR.scores[i]) * (mean - currentRR.scores[i]);
                    }
                    std_dev /= (float)this.m_repeats;
                    std_dev = (float)Math.sqrt(std_dev);
                    float score = mean - std_dev;
                    this.lastResult.m_b = Float.valueOf(score);
                    if (currentRR.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)currentRR.best.m_b).floatValue()) {
                        currentRR.best = this.lastResult;
                        currentRR.best.m_a = currentRR.actions.getLastAction();
                    }
                    currentRR.iterations_run = 0;
                    PlayerAction next = currentRR.actions.getNextAction(cutOffTime);
                    if (next == null) {
                        this.lastResult = currentRR.best;
                        this.stack.remove(0);
                        if (currentRR.actions.getGenerated() <= this.max_branching_so_far) continue block7;
                        this.max_branching_so_far = current.actions.getGenerated();
                        break;
                    }
                    GameState gs2 = currentRR.gs.cloneIssue(next);
                    this.stack.add(0, new RTMiniMaxNode(-1, gs2, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY));
                    break;
                }
                case 0: {
                    GameState gs2;
                    PlayerAction next;
                    if (current.actions == null) {
                        current.actions = new PlayerActionGenerator(current.gs, maxplayer);
                        long l = current.actions.getSize();
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        current.best = null;
                        next = current.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        gs2 = current.gs.cloneIssue(next);
                        this.stack.add(0, new RTMiniMaxNode(-1, gs2, current.alpha, current.beta));
                        break;
                    }
                    current.alpha = Math.max(current.alpha, ((Float)this.lastResult.m_b).floatValue());
                    if (current.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)current.best.m_b).floatValue()) {
                        current.best = this.lastResult;
                        current.best.m_a = current.actions.getLastAction();
                    }
                    PlayerAction next2 = current.actions.getNextAction(cutOffTime);
                    if (current.beta <= current.alpha || next2 == null) {
                        this.lastResult = current.best;
                        this.stack.remove(0);
                        if (current.actions.getGenerated() <= this.max_branching_so_far) continue block7;
                        this.max_branching_so_far = current.actions.getGenerated();
                        break;
                    }
                    GameState gs22 = current.gs.cloneIssue(next2);
                    this.stack.add(0, new RTMiniMaxNode(-1, gs22, current.alpha, current.beta));
                    break;
                }
                case 1: {
                    GameState gs2;
                    PlayerAction next;
                    if (current.actions == null) {
                        current.actions = new PlayerActionGenerator(current.gs, minplayer);
                        long l = current.actions.getSize();
                        if (l > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l;
                        }
                        current.best = null;
                        next = current.actions.getNextAction(cutOffTime);
                        if (next == null) break;
                        gs2 = current.gs.cloneIssue(next);
                        this.stack.add(0, new RTMiniMaxNode(-1, gs2, current.alpha, current.beta));
                        break;
                    }
                    current.beta = Math.min(current.beta, ((Float)this.lastResult.m_b).floatValue());
                    if (current.best == null || ((Float)this.lastResult.m_b).floatValue() < ((Float)current.best.m_b).floatValue()) {
                        current.best = this.lastResult;
                        current.best.m_a = current.actions.getLastAction();
                    }
                    PlayerAction next3 = current.actions.getNextAction(cutOffTime);
                    if (current.beta <= current.alpha || next3 == null) {
                        this.lastResult = current.best;
                        this.stack.remove(0);
                        if (current.actions.getGenerated() <= this.max_branching_so_far) continue block7;
                        this.max_branching_so_far = current.actions.getGenerated();
                        break;
                    }
                    GameState gs23 = current.gs.cloneIssue(next3);
                    this.stack.add(0, new RTMiniMaxNode(-1, gs23, current.alpha, current.beta));
                    break;
                }
                case 2: {
                    current.gs = current.gs.clone();
                    while (!(current.gs.winner() != -1 || current.gs.gameover() || current.gs.canExecuteAnyAction(maxplayer) || current.gs.canExecuteAnyAction(minplayer))) {
                        current.gs.cycle();
                    }
                    current.type = -1;
                }
            }
        }
        if (this.stack.isEmpty()) {
            return (PlayerAction)this.lastResult.m_a;
        }
        if (needAResult) {
            if (head.best != null) {
                return (PlayerAction)head.best.m_a;
            }
            return head.actions.getRandom();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.m_repeats + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        List<ParameterSpecification> parameters = super.getParameters();
        parameters.add(new ParameterSpecification("Repeats", Integer.TYPE, 10));
        return parameters;
    }

    public int getRepeats() {
        return this.m_repeats;
    }

    public void setRepeats(int a_r) {
        this.m_repeats = a_r;
    }
}

