/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.RTMiniMax;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.MiniMaxResult;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;

public class RTMinimax
extends AI {
    static int minCT = -1;
    static int maxCT = -1;
    static int nLeaves = 0;
    public long max_branching_so_far = 0L;
    public long max_leaves_so_far = 0L;
    int LOOKAHEAD = 40;
    protected int defaultNONEduration = 8;
    EvaluationFunction ef;

    public RTMinimax(UnitTypeTable utt) {
        this(50, new SimpleSqrtEvaluationFunction3());
    }

    public RTMinimax(int la, EvaluationFunction a_ef) {
        this.LOOKAHEAD = la;
        this.ef = a_ef;
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new RTMinimax(this.LOOKAHEAD, this.ef);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player) && gs.winner() == -1) {
            PlayerAction pa = this.realTimeMinimaxAB(player, gs, this.LOOKAHEAD);
            pa.fillWithNones(gs, player, this.defaultNONEduration);
            return pa;
        }
        return new PlayerAction();
    }

    public PlayerAction greedyActionScan(GameState gs, int player, long cutOffTime) throws Exception {
        PlayerAction best = null;
        float bestScore = 0.0f;
        PlayerActionGenerator pag = new PlayerActionGenerator(gs, player);
        PlayerAction pa = null;
        do {
            if ((pa = pag.getNextAction(cutOffTime)) != null) {
                GameState gs2 = gs.cloneIssue(pa);
                float score = this.ef.evaluate(player, 1 - player, gs2);
                if (best == null || score > bestScore) {
                    best = pa;
                    bestScore = score;
                }
            }
            if (System.currentTimeMillis() <= cutOffTime) continue;
            return best;
        } while (pa != null);
        return best;
    }

    public PlayerAction realTimeMinimaxAB(int player, GameState gs, int lookAhead) {
        long start = System.currentTimeMillis();
        float alpha = -EvaluationFunction.VICTORY;
        float beta = EvaluationFunction.VICTORY;
        int maxplayer = player;
        int minplayer = 1 - player;
        System.out.println("Starting realTimeMinimaxAB...");
        if ((long)nLeaves > this.max_leaves_so_far) {
            this.max_leaves_so_far = nLeaves;
        }
        minCT = -1;
        maxCT = -1;
        nLeaves = 0;
        MiniMaxResult bestMove = this.realTimeMinimaxAB(gs, maxplayer, minplayer, alpha, beta, gs.getTime() + lookAhead, 0);
        System.out.println("realTimeMinimax: " + bestMove + " in " + (System.currentTimeMillis() - start));
        return bestMove.action;
    }

    public MiniMaxResult realTimeMinimaxAB(GameState gs, int maxplayer, int minplayer, float alpha, float beta, int lookAhead, int depth) {
        if (gs.getTime() >= lookAhead || gs.winner() != -1) {
            int CT = gs.getNextChangeTime();
            if (minCT == -1 || CT < minCT) {
                minCT = CT;
            }
            if (maxCT == -1 || CT > maxCT) {
                maxCT = CT;
            }
            ++nLeaves;
            return new MiniMaxResult(null, this.ef.evaluate(maxplayer, minplayer, gs), gs);
        }
        if (gs.canExecuteAnyAction(maxplayer)) {
            List<PlayerAction> actions_max = gs.getPlayerActions(maxplayer);
            int l = actions_max.size();
            if ((long)l > this.max_branching_so_far) {
                this.max_branching_so_far = l;
            }
            MiniMaxResult best = null;
            for (PlayerAction action_max : actions_max) {
                GameState gs2 = gs.cloneIssue(action_max);
                MiniMaxResult tmp = this.realTimeMinimaxAB(gs2, maxplayer, minplayer, alpha, beta, lookAhead, depth + 1);
                alpha = Math.max(alpha, tmp.evaluation);
                if (best == null || tmp.evaluation > best.evaluation) {
                    best = tmp;
                    best.action = action_max;
                }
                if (!(beta <= alpha)) continue;
                return best;
            }
            return best;
        }
        if (gs.canExecuteAnyAction(minplayer)) {
            List<PlayerAction> actions_min = gs.getPlayerActions(minplayer);
            int l = actions_min.size();
            if ((long)l > this.max_branching_so_far) {
                this.max_branching_so_far = l;
            }
            MiniMaxResult best = null;
            for (PlayerAction action_min : actions_min) {
                GameState gs2 = gs.cloneIssue(action_min);
                MiniMaxResult tmp = this.realTimeMinimaxAB(gs2, maxplayer, minplayer, alpha, beta, lookAhead, depth + 1);
                beta = Math.min(beta, tmp.evaluation);
                if (best == null || tmp.evaluation < best.evaluation) {
                    best = tmp;
                    best.action = action_min;
                }
                if (!(beta <= alpha)) continue;
                return best;
            }
            return best;
        }
        GameState gs2 = gs.clone();
        while (!(gs2.winner() != -1 || gs2.gameover() || gs2.canExecuteAnyAction(maxplayer) || gs2.canExecuteAnyAction(minplayer))) {
            gs2.cycle();
        }
        return this.realTimeMinimaxAB(gs2, maxplayer, minplayer, alpha, beta, lookAhead, depth + 1);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.LOOKAHEAD + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("LookAhead", Integer.TYPE, 50));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getLookAhead() {
        return this.LOOKAHEAD;
    }

    public void setLookAhead(int a_la) {
        this.LOOKAHEAD = a_la;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }
}

