/*
 * Decompiled with CFR 0.152.
 */
package ai.montecarlo;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;

public class MonteCarlo
extends AIWithComputationBudget
implements InterruptibleAI {
    public static final int DEBUG = 0;
    EvaluationFunction ef;
    Random r = new Random();
    AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    PlayerActionGenerator moveGenerator;
    boolean allMovesGenerated = false;
    List<PlayerActionTableEntry> actions;
    GameState gs_to_start_from;
    int run = 0;
    int playerForThisComputation;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    long MAXACTIONS = 100L;
    int MAXSIMULATIONTIME = 1024;

    public MonteCarlo(UnitTypeTable utt) {
        this(100, -1, 100, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public MonteCarlo(int available_time, int playouts_per_cycle, int lookahead, AI policy, EvaluationFunction a_ef) {
        super(available_time, playouts_per_cycle);
        this.MAXACTIONS = -1L;
        this.MAXSIMULATIONTIME = lookahead;
        this.randomAI = policy;
        this.ef = a_ef;
    }

    public MonteCarlo(int available_time, int playouts_per_cycle, int lookahead, long maxactions, AI policy, EvaluationFunction a_ef) {
        super(available_time, playouts_per_cycle);
        this.MAXACTIONS = maxactions;
        this.MAXSIMULATIONTIME = lookahead;
        this.randomAI = policy;
        this.ef = a_ef;
    }

    @Override
    public void printStats() {
        if (this.total_cycles_executed > 0L && this.total_actions_issued > 0L) {
            System.out.println("Average runs per cycle: " + (double)this.total_runs / (double)this.total_cycles_executed);
            System.out.println("Average runs per action: " + (double)this.total_runs / (double)this.total_actions_issued);
        }
    }

    @Override
    public void reset() {
        this.moveGenerator = null;
        this.actions = null;
        this.gs_to_start_from = null;
        this.run = 0;
    }

    @Override
    public AI clone() {
        return new MonteCarlo(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAXACTIONS, this.randomAI, this.ef);
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) throws Exception {
        this.playerForThisComputation = a_player;
        this.gs_to_start_from = gs;
        this.moveGenerator = new PlayerActionGenerator(gs, this.playerForThisComputation);
        this.moveGenerator.randomizeOrder();
        this.allMovesGenerated = false;
        this.actions = null;
        this.run = 0;
    }

    public void resetSearch() {
        this.gs_to_start_from = null;
        this.moveGenerator = null;
        this.actions = null;
        this.run = 0;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long cutOffTime;
        long start = System.currentTimeMillis();
        int nruns = 0;
        long l = cutOffTime = this.TIME_BUDGET > 0 ? System.currentTimeMillis() + (long)this.TIME_BUDGET : 0L;
        if (this.TIME_BUDGET <= 0) {
            cutOffTime = 0L;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<PlayerActionTableEntry>();
            if (this.MAXACTIONS > 0L && this.moveGenerator.getSize() > 2L * this.MAXACTIONS) {
                int i = 0;
                while ((long)i < this.MAXACTIONS) {
                    PlayerActionTableEntry pate = new PlayerActionTableEntry();
                    pate.pa = this.moveGenerator.getRandom();
                    this.actions.add(pate);
                    ++i;
                }
                this.max_actions_so_far = Math.max(this.moveGenerator.getSize(), this.max_actions_so_far);
            } else {
                PlayerAction pa;
                long count = 0L;
                do {
                    if ((pa = this.moveGenerator.getNextAction(cutOffTime)) == null) continue;
                    PlayerActionTableEntry pate = new PlayerActionTableEntry();
                    pate.pa = pa;
                    this.actions.add(pate);
                    if (this.MAXACTIONS > 0L && ++count >= 2L * this.MAXACTIONS) break;
                } while (pa != null);
                this.max_actions_so_far = Math.max((long)this.actions.size(), this.max_actions_so_far);
                while (this.MAXACTIONS > 0L && (long)this.actions.size() > this.MAXACTIONS) {
                    this.actions.remove(this.r.nextInt(this.actions.size()));
                }
            }
        }
        while (!(this.TIME_BUDGET > 0 && System.currentTimeMillis() - start >= (long)this.TIME_BUDGET || this.ITERATIONS_BUDGET > 0 && nruns >= this.ITERATIONS_BUDGET)) {
            this.monteCarloRun(this.playerForThisComputation, this.gs_to_start_from);
            ++nruns;
        }
        ++this.total_cycles_executed;
    }

    public void monteCarloRun(int player, GameState gs) throws Exception {
        int idx = this.run % this.actions.size();
        PlayerActionTableEntry pate = this.actions.get(idx);
        GameState gs2 = gs.cloneIssue(pate.pa);
        GameState gs3 = gs2.clone();
        this.simulate(gs3, gs3.getTime() + this.MAXSIMULATIONTIME);
        int time = gs3.getTime() - gs2.getTime();
        pate.accum_evaluation = (float)((double)pate.accum_evaluation + (double)this.ef.evaluate(player, 1 - player, gs3) * Math.pow(0.99, (double)time / 10.0));
        ++pate.visit_count;
        ++this.run;
        ++this.total_runs;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        PlayerActionTableEntry best = null;
        for (PlayerActionTableEntry pate : this.actions) {
            if (best != null && !(pate.accum_evaluation / (float)pate.visit_count > best.accum_evaluation / (float)best.visit_count)) continue;
            best = pate;
        }
        if (best == null) {
            PlayerActionTableEntry pate = new PlayerActionTableEntry();
            pate.pa = this.moveGenerator.getRandom();
            System.err.println("MonteCarlo.getBestActionSoFar: best action was null!!! action.size() = " + this.actions.size());
        }
        ++this.total_actions_issued;
        return best.pa;
    }

    public void simulate(GameState gs, int time) throws Exception {
        boolean gameover = false;
        do {
            if (gs.isComplete()) {
                gameover = gs.cycle();
                continue;
            }
            gs.issue(this.randomAI.getAction(0, gs));
            gs.issue(this.randomAI.getAction(1, gs));
        } while (!gameover && gs.getTime() < time);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + "," + this.ITERATIONS_BUDGET + "," + this.MAXSIMULATIONTIME + "," + this.MAXACTIONS + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("MaxActions", Long.TYPE, 100));
        parameters.add(new ParameterSpecification("playoutAI", AI.class, this.randomAI));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.MAXSIMULATIONTIME = a_pola;
    }

    public long getMaxActions() {
        return this.MAXACTIONS;
    }

    public void setMaxActions(long a_ma) {
        this.MAXACTIONS = a_ma;
    }

    public AI getplayoutAI() {
        return this.randomAI;
    }

    public void setplayoutAI(AI a_dp) {
        this.randomAI = a_dp;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }

    public class PlayerActionTableEntry {
        PlayerAction pa;
        float accum_evaluation = 0.0f;
        int visit_count = 0;
    }
}

