/*
 * Decompiled with CFR 0.152.
 */
package ai.montecarlo.lsi;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.montecarlo.lsi.Sampling;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;

public class LSI
extends AIWithComputationBudget {
    public static final int DEBUG = 0;
    private static final double NORMALIZATION_EPSILON = 0.01;
    private Random rnd = new Random();
    private int lookAhead;
    private double split;
    private EstimateType estimateType;
    private EstimateReuseType estimateReuseType;
    private GenerateType generateType;
    private Sampling.AgentOrderingType agentOrderingType;
    private EvaluateType evaluateType;
    private boolean eliteReuse;
    private RelaxationType relaxationType;
    private int relaxationLimit;
    private boolean epochal;
    private AI simulationAi;
    private EvaluationFunction evalFunction;
    private int nofPlays = 0;
    private int nofNoops = 0;
    private int nofSamples = 0;
    private int nofPlayedUnits = 0;
    private int nofActions = 0;
    private Sampling sampling;
    private LinkedHashMap<PlayerAction, Pair<Double, Integer>> elitePlayerActions = new LinkedHashMap();
    private Set<Unit> nextEpochUnits = new HashSet<Unit>();
    private Set<Unit> epochUnits;
    private int actionCount;

    public LSI(UnitTypeTable utt) {
        this(100, 100, 0.25, EstimateType.RANDOM_TAIL, EstimateReuseType.ALL, GenerateType.PER_AGENT, Sampling.AgentOrderingType.ENTROPY, EvaluateType.HALVING, false, RelaxationType.NONE, 2, false, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public LSI(int availableSimulationCount, int lookAhead, double split, EstimateType estimateType, EstimateReuseType estimateReuseType, GenerateType generateType, Sampling.AgentOrderingType agentOrderingType, EvaluateType evaluateType, boolean eliteReuse, RelaxationType relaxationType, int relaxationLimit, boolean epochal, AI simulationAi, EvaluationFunction evalFunction) {
        super(-1, availableSimulationCount);
        this.lookAhead = lookAhead;
        this.split = split;
        this.estimateType = estimateType;
        this.estimateReuseType = estimateReuseType;
        this.generateType = generateType;
        this.agentOrderingType = agentOrderingType;
        this.evaluateType = evaluateType;
        this.relaxationType = relaxationType;
        this.relaxationLimit = relaxationLimit;
        this.eliteReuse = eliteReuse;
        this.epochal = epochal;
        this.simulationAi = simulationAi;
        this.evalFunction = evalFunction;
        this.sampling = new Sampling(agentOrderingType, lookAhead, simulationAi, evalFunction);
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new LSI(this.ITERATIONS_BUDGET, this.lookAhead, this.split, this.estimateType, this.estimateReuseType, this.generateType, this.agentOrderingType, this.evaluateType, this.eliteReuse, this.relaxationType, this.relaxationLimit, this.epochal, this.simulationAi, this.evalFunction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PlayerAction getAction(int player, GameState gameState) throws Exception {
        if (!gameState.canExecuteAnyAction(player) || gameState.winner() != -1) {
            return new PlayerAction();
        }
        this.sampling.resetSimulationCount();
        this.elitePlayerActions.clear();
        List<Sampling.UnitActionTableEntry> unitActionTable = this.prepareUnitActionTable(gameState, player);
        HashSet<Unit> units = new HashSet<Unit>();
        for (Sampling.UnitActionTableEntry unitActionTableEntry : unitActionTable) {
            units.add(unitActionTableEntry.u);
        }
        if (this.epochal) {
            if (this.epochUnits == null) {
                this.epochUnits = new HashSet<Unit>(units);
            }
            for (Sampling.UnitActionTableEntry unitActionTableEntry : unitActionTable) {
                if (this.epochUnits.contains(unitActionTableEntry.u) || this.nextEpochUnits.contains(unitActionTableEntry.u)) continue;
                if (this.epochUnits.isEmpty()) {
                    this.epochUnits.add(unitActionTableEntry.u);
                    continue;
                }
                this.nextEpochUnits.add(unitActionTableEntry.u);
            }
            Iterator<Sampling.UnitActionTableEntry> iterator = unitActionTable.iterator();
            while (iterator.hasNext()) {
                Sampling.UnitActionTableEntry unitActionTableEntry = iterator.next();
                if (this.epochUnits.contains(unitActionTableEntry.u)) continue;
                iterator.remove();
            }
        }
        if (this.relaxationType == RelaxationType.PRE_RANDOM) {
            List<Integer> indices = this.getRelaxedAgentIndicesRandom(unitActionTable);
            for (int index : indices) {
                unitActionTable.remove(index);
            }
        }
        PlayerAction playerAction = new PlayerAction();
        if (!unitActionTable.isEmpty()) {
            Object var6_13 = null;
            Set<PlayerAction> actionSet = null;
            if (this.estimateType.equals((Object)EstimateType.ALL_COMBINATIONS)) {
                actionSet = this.sampling.generatePlayerActionAll(unitActionTable, player, gameState, true);
                this.sampling.increaseSimulationCount((double)this.ITERATIONS_BUDGET * this.split);
            } else {
                switch (this.estimateType) {
                    case RANDOM: {
                        List<double[]> list = this.stageGenerateRandom(player, gameState, unitActionTable);
                        this.sampling.increaseSimulationCount((double)this.ITERATIONS_BUDGET * this.split);
                        break;
                    }
                    case NOOP_TAIL: {
                        List<double[]> list = this.stageGenerateNoopTail(player, gameState, unitActionTable);
                        break;
                    }
                    case RANDOM_TAIL: {
                        List<double[]> list = this.stageGenerateRandomTail(player, gameState, unitActionTable);
                        break;
                    }
                    case RANDOM_TAIL_ELITE: {
                        List<double[]> list = this.stageGenerateRandomTailElite(player, gameState, unitActionTable);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown EstimateType");
                    }
                }
                switch (this.relaxationType) {
                    case MAX: 
                    case MEAN: 
                    case MEDIAN: 
                    case MAX_ENT: 
                    case MIN_ENT: {
                        void var6_18;
                        actionSet = this.stageChoosePlayerActionsAllRelaxation((List<double[]>)var6_18, player, gameState, unitActionTable);
                        break;
                    }
                    default: {
                        void var6_18;
                        actionSet = this.stageChoosePlayerActionByDist((List<double[]>)var6_18, player, gameState, unitActionTable);
                    }
                }
            }
            switch (this.evaluateType) {
                case HALVING: {
                    playerAction = this.stageEvaluateHalvingFill(actionSet, player, gameState);
                    break;
                }
                case HALVING_ELITE: {
                    playerAction = this.stageEvaluateEliteHalving(actionSet, player, gameState);
                    break;
                }
                case BEST: {
                    playerAction = this.stageEvaluateBest(actionSet, player, gameState);
                }
            }
            switch (this.relaxationType) {
                case POST_RANDOM: {
                    List<Integer> indices = this.getRelaxedAgentIndicesRandom(unitActionTable);
                    for (Integer index : indices) {
                        playerAction.getActions().remove(index);
                    }
                    break;
                }
                case POST_MAX_DIFF: 
                case POST_MAX_TIME_NORMALIZE: 
                case POST_ENTROPY_MAX: 
                case POST_ENTROPY_MIN: {
                    if (unitActionTable.size() - this.relaxationLimit < 1) break;
                    int noToRemove = unitActionTable.size() - this.relaxationLimit;
                    List<Pair<Integer, Double>> evaluatedIndices = new ArrayList<Pair<Integer, Double>>();
                    for (int i = 0; i < unitActionTable.size(); ++i) {
                        double d = 0.0;
                        switch (this.relaxationType) {
                            case POST_MAX_DIFF: {
                                void var6_19;
                                d = this.sampling.difference(unitActionTable, (List<double[]>)var6_19, playerAction, i);
                                break;
                            }
                            case POST_MAX_TIME_NORMALIZE: {
                                void var6_19;
                                Sampling.UnitActionTableEntry entry3 = unitActionTable.get(i);
                                d = Double.NEGATIVE_INFINITY;
                                for (int j = 0; j < entry3.nactions; ++j) {
                                    double duration = entry3.actions.get(j).ETA(entry3.u);
                                    double eval = ((double[])var6_19.get(entry3.idx))[j] / duration;
                                    if (!(eval > d)) continue;
                                    d = eval;
                                }
                                break;
                            }
                            case POST_ENTROPY_MAX: 
                            case POST_ENTROPY_MIN: {
                                void var6_19;
                                d = this.sampling.entropy((double[])var6_19.get(i));
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown relaxationType!");
                            }
                        }
                        evaluatedIndices.add(new Pair<Integer, Double>(i, d));
                    }
                    switch (this.relaxationType) {
                        case POST_MAX_DIFF: 
                        case POST_MAX_TIME_NORMALIZE: 
                        case POST_ENTROPY_MAX: {
                            evaluatedIndices.sort(new Comparator<Pair<Integer, Double>>(){

                                @Override
                                public int compare(Pair<Integer, Double> p1, Pair<Integer, Double> p2) {
                                    return ((Double)p1.m_b).compareTo((Double)p2.m_b);
                                }
                            });
                            break;
                        }
                        case POST_ENTROPY_MIN: {
                            evaluatedIndices.sort(new Comparator<Pair<Integer, Double>>(){

                                @Override
                                public int compare(Pair<Integer, Double> p1, Pair<Integer, Double> p2) {
                                    return ((Double)p2.m_b).compareTo((Double)p1.m_b);
                                }
                            });
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown relaxationType!");
                        }
                    }
                    evaluatedIndices = evaluatedIndices.subList(0, noToRemove);
                    evaluatedIndices.sort(new Comparator<Pair<Integer, Double>>(){

                        @Override
                        public int compare(Pair<Integer, Double> p1, Pair<Integer, Double> p2) {
                            return ((Integer)p2.m_a).compareTo((Integer)p1.m_a);
                        }
                    });
                    for (Pair pair : evaluatedIndices) {
                        playerAction.getActions().remove((Integer)pair.m_a);
                    }
                    break;
                }
            }
        }
        if (this.epochal) {
            for (Pair<Unit, UnitAction> actionPair : playerAction.getActions()) {
                this.epochUnits.remove(actionPair.m_a);
            }
            if (this.epochUnits.isEmpty()) {
                this.epochUnits = new HashSet<Unit>(this.nextEpochUnits);
                this.nextEpochUnits.clear();
            }
        }
        this.incrementActionCounter(playerAction, unitActionTable);
        return playerAction;
    }

    private List<double[]> stageGenerateNoopTail(int player, GameState gameState, List<Sampling.UnitActionTableEntry> unitActionTable) throws Exception {
        PlayerAction currentPA = new PlayerAction();
        currentPA.fillWithNones(gameState, player, 10);
        int reducedActionCount = this.actionCount;
        int i = 0;
        for (Sampling.UnitActionTableEntry entry : unitActionTable) {
            for (UnitAction action : entry.actions) {
                PlayerAction neighbourPA = currentPA.clone();
                neighbourPA.getActions().set(i, new Pair<Unit, UnitAction>(entry.u, action));
                if (this.isPlayerActionValid(gameState, neighbourPA)) continue;
                --reducedActionCount;
            }
            ++i;
        }
        ArrayList<double[]> distributions = new ArrayList<double[]>();
        i = 0;
        for (Sampling.UnitActionTableEntry entry : unitActionTable) {
            double[] distribution = new double[entry.nactions];
            int idx = 0;
            double min = Double.POSITIVE_INFINITY;
            for (UnitAction action : entry.actions) {
                PlayerAction neighbourPA = currentPA.clone();
                neighbourPA.getActions().set(i, new Pair<Unit, UnitAction>(entry.u, action));
                if (this.isPlayerActionValid(gameState, neighbourPA)) {
                    double eval;
                    distribution[idx] = eval = this.sampling.evaluatePlayerAction(player, gameState, neighbourPA, (int)((double)this.ITERATIONS_BUDGET * this.split / (double)reducedActionCount));
                    if (eval < min) {
                        min = eval;
                    }
                } else {
                    distribution[idx] = Double.NEGATIVE_INFINITY;
                }
                ++idx;
            }
            for (int j = 0; j < distribution.length; ++j) {
                if (Double.isInfinite(distribution[j])) {
                    distribution[j] = 0.0;
                }
                if (distribution[j] == Double.MIN_VALUE) {
                    distribution[j] = 0.01;
                } else {
                    int n = j;
                    distribution[n] = distribution[n] - (min - 0.01);
                }
                if (!(distribution[j] < 0.0) && !Double.isNaN(distribution[j])) continue;
                System.err.println("Negative/NaN distribution!");
            }
            distributions.add(distribution);
            ++i;
        }
        return distributions;
    }

    private List<double[]> stageGenerateRandomTail(int player, GameState gameState, List<Sampling.UnitActionTableEntry> unitActionTable) throws Exception {
        ArrayList<double[]> distributions = new ArrayList<double[]>();
        ArrayList<double[]> actionDist = new ArrayList<double[]>();
        for (Sampling.UnitActionTableEntry entry : unitActionTable) {
            double[] armsDist = new double[entry.nactions];
            actionDist.add(armsDist);
            for (int i = 0; i < armsDist.length; ++i) {
                armsDist[i] = 0.0;
            }
        }
        int sample = 0;
        boolean completeOnce = false;
        block6: while (true) {
            int agentIndex = 0;
            for (Sampling.UnitActionTableEntry entry : unitActionTable) {
                int actionIndex = 0;
                for (UnitAction action : entry.actions) {
                    PlayerAction neighbourPA = new PlayerAction();
                    LinkedList<Integer> agentOrder = new LinkedList<Integer>();
                    for (int i = 0; i < unitActionTable.size(); ++i) {
                        if (i == agentIndex) continue;
                        agentOrder.add(i);
                    }
                    Collections.shuffle(agentOrder);
                    agentOrder.add(0, agentIndex);
                    ((double[])actionDist.get((int)agentIndex))[actionIndex] = 1.0;
                    neighbourPA = this.sampling.generatePlayerActionGivenDist(unitActionTable, player, gameState, actionDist, null);
                    ((double[])actionDist.get((int)agentIndex))[actionIndex] = 0.0;
                    PlayerAction orderedNeighbourPA = new PlayerAction();
                    for (Sampling.UnitActionTableEntry agentTableEntry : unitActionTable) {
                        for (Pair<Unit, UnitAction> neighbourPair : neighbourPA.getActions()) {
                            if (!((Unit)neighbourPair.m_a).equals(agentTableEntry.u)) continue;
                            orderedNeighbourPA.addUnitAction((Unit)neighbourPair.m_a, (UnitAction)neighbourPair.m_b);
                        }
                    }
                    neighbourPA = orderedNeighbourPA;
                    if (!this.isPlayerActionValid(gameState, neighbourPA)) {
                        throw new RuntimeException("Should generate only valid combinations!");
                    }
                    double eval = this.sampling.evaluatePlayerAction(player, gameState, neighbourPA, 1);
                    switch (this.estimateReuseType) {
                        case SINGLE: {
                            this.updateActionEvalSingle(unitActionTable, neighbourPA, agentIndex, eval);
                            break;
                        }
                        case ALL: {
                            this.updateActionEvalAll(unitActionTable, neighbourPA, agentIndex, eval);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown EstimateReusingType");
                        }
                    }
                    if ((double)(++sample) >= (double)this.ITERATIONS_BUDGET * this.split) break block6;
                    ++actionIndex;
                }
                ++agentIndex;
            }
            completeOnce = true;
        }
        if (!completeOnce) {
            System.err.println("Generate did not complete even one round! " + sample + " >= (" + this.ITERATIONS_BUDGET + " * " + this.split + ")");
        }
        for (Sampling.UnitActionTableEntry entry : unitActionTable) {
            Object min = Double.POSITIVE_INFINITY;
            for (Object accumEval : (Object)entry.accum_evaluation) {
                if (!(accumEval < min)) continue;
                min = accumEval;
            }
            for (int j = 0; j < entry.accum_evaluation.length; ++j) {
                if (entry.accum_evaluation[j] == Double.MIN_VALUE) {
                    if (this.eliteReuse) {
                        entry.accum_evaluation[j] = 0.01;
                    } else {
                        int n = j;
                        entry.accum_evaluation[n] = entry.accum_evaluation[n] - (min - 0.01);
                    }
                } else {
                    int n = j;
                    entry.accum_evaluation[n] = entry.accum_evaluation[n] - (min - 0.01);
                }
                if (!(entry.accum_evaluation[j] < 0.0) && !Double.isNaN(entry.accum_evaluation[j])) continue;
                System.err.println("Negative/NaN distribution!");
            }
            distributions.add(entry.accum_evaluation);
        }
        return distributions;
    }

    private List<double[]> stageGenerateRandom(int player, GameState gameState, List<Sampling.UnitActionTableEntry> unitActionTable) throws Exception {
        ArrayList<double[]> distributions = new ArrayList<double[]>();
        for (Sampling.UnitActionTableEntry entry : unitActionTable) {
            distributions.add(new double[entry.nactions]);
        }
        return distributions;
    }

    private List<double[]> stageGenerateRandomTailElite(int player, GameState gameState, List<Sampling.UnitActionTableEntry> unitActionTable) throws Exception {
        ArrayList<double[]> distributions = new ArrayList<double[]>();
        int sample = 0;
        while ((double)sample < (double)this.ITERATIONS_BUDGET * this.split) {
            int agentIndex = 0;
            for (Sampling.UnitActionTableEntry entry : unitActionTable) {
                block6: for (UnitAction action : entry.actions) {
                    PlayerAction neighbourPA = new PlayerAction();
                    for (Sampling.UnitActionTableEntry rndEntry : unitActionTable) {
                        neighbourPA.addUnitAction(rndEntry.u, rndEntry.actions.get(this.rnd.nextInt(rndEntry.nactions)));
                    }
                    neighbourPA.getActions().set(agentIndex, new Pair<Unit, UnitAction>(entry.u, action));
                    if (!this.isPlayerActionValid(gameState, neighbourPA)) continue;
                    ++sample;
                    double eval = this.sampling.evaluatePlayerAction(player, gameState, neighbourPA, 1);
                    if (this.eliteReuse) {
                        if (this.elitePlayerActions.containsKey(neighbourPA)) {
                            Pair<Double, Integer> evalPair = this.elitePlayerActions.get(neighbourPA);
                            double newEval = ((Double)evalPair.m_a * (double)((Integer)evalPair.m_b).intValue() + eval) / (double)((Integer)evalPair.m_b + 1);
                            this.elitePlayerActions.put(neighbourPA, new Pair<Double, Integer>(newEval, (Integer)evalPair.m_b + 1));
                        } else {
                            this.elitePlayerActions.put(neighbourPA, new Pair<Double, Integer>(eval, 1));
                        }
                    }
                    switch (this.estimateReuseType) {
                        case SINGLE: {
                            this.updateActionEvalSingle(unitActionTable, neighbourPA, agentIndex, eval);
                            continue block6;
                        }
                        case ALL: {
                            this.updateActionEvalAll(unitActionTable, neighbourPA, agentIndex, eval);
                            continue block6;
                        }
                    }
                    throw new RuntimeException("Unknown EstimateReusingType");
                }
                ++agentIndex;
            }
        }
        for (Sampling.UnitActionTableEntry entry : unitActionTable) {
            double min = Double.POSITIVE_INFINITY;
            for (double accumEval : entry.accum_evaluation) {
                if (!(accumEval < min)) continue;
                min = accumEval;
            }
            for (int j = 0; j < entry.accum_evaluation.length; ++j) {
                int n = j;
                entry.accum_evaluation[n] = entry.accum_evaluation[n] - (min - 0.01);
                if (!(entry.accum_evaluation[j] < 0.0) && !Double.isNaN(entry.accum_evaluation[j])) continue;
                System.err.println("Negative/NaN distribution!");
            }
            distributions.add(entry.accum_evaluation);
        }
        return distributions;
    }

    private void updateActionEvalSingle(List<Sampling.UnitActionTableEntry> unitActionTable, PlayerAction playerAction, int agentIndex, double eval) {
        int actionIndex = 0;
        Sampling.UnitActionTableEntry agentEntry = unitActionTable.get(agentIndex);
        for (UnitAction unitAction : agentEntry.actions) {
            if (unitAction.equals(playerAction.getActions().get((int)agentIndex).m_b)) {
                agentEntry.accum_evaluation[actionIndex] = (agentEntry.accum_evaluation[actionIndex] * (double)agentEntry.visit_count[actionIndex] + eval) / (double)(agentEntry.visit_count[actionIndex] + 1);
                int n = actionIndex;
                agentEntry.visit_count[n] = agentEntry.visit_count[n] + 1;
            }
            ++actionIndex;
        }
    }

    private void updateActionEvalAll(List<Sampling.UnitActionTableEntry> unitActionTable, PlayerAction playerAction, int agentIndex, double eval) {
        agentIndex = 0;
        for (Sampling.UnitActionTableEntry agentEntry : unitActionTable) {
            int actionIndex = 0;
            for (UnitAction unitAction : agentEntry.actions) {
                if (unitAction.equals(playerAction.getActions().get((int)agentIndex).m_b)) {
                    agentEntry.accum_evaluation[actionIndex] = (agentEntry.accum_evaluation[actionIndex] * (double)agentEntry.visit_count[actionIndex] + eval) / (double)(agentEntry.visit_count[actionIndex] + 1);
                    int n = actionIndex;
                    agentEntry.visit_count[n] = agentEntry.visit_count[n] + 1;
                }
                ++actionIndex;
            }
            ++agentIndex;
        }
    }

    private Set<PlayerAction> stageChoosePlayerActionsAllRelaxation(List<double[]> distributions, int player, GameState gameState, List<Sampling.UnitActionTableEntry> unitActionTable) throws Exception {
        if (this.relaxationLimit > 0 && unitActionTable.size() - this.relaxationLimit >= 1) {
            List<Pair<Integer, Double>> choseActList = new LinkedList<Pair<Integer, Double>>();
            for (int j = 0; j < distributions.size(); ++j) {
                double value;
                double[] dArray = distributions.get(j);
                switch (this.relaxationType) {
                    case MAX: {
                        Arrays.sort(dArray);
                        value = dArray[dArray.length - 1];
                        break;
                    }
                    case MEAN: {
                        double sum = 0.0;
                        for (double val : dArray) {
                            sum += val;
                        }
                        value = sum / (double)dArray.length;
                        break;
                    }
                    case MEDIAN: {
                        Arrays.sort(dArray);
                        if (dArray.length % 2 == 0) {
                            value = (dArray[dArray.length / 2] + dArray[dArray.length / 2 - 1]) / 2.0;
                            break;
                        }
                        value = dArray[(int)Math.floor(dArray.length / 2)];
                        break;
                    }
                    case MAX_ENT: {
                        value = this.sampling.entropy(dArray);
                        break;
                    }
                    case MIN_ENT: {
                        value = 1.0 / this.sampling.entropy(dArray);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown RelaxationType!");
                    }
                }
                choseActList.add(new Pair<Integer, Double>(j, value));
            }
            choseActList.sort(new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> p1, Pair<Integer, Double> p2) {
                    double eval1 = (Double)p1.m_b;
                    double eval2 = (Double)p2.m_b;
                    return Double.compare(eval1, eval2);
                }
            });
            choseActList = choseActList.subList(0, choseActList.size() - this.relaxationLimit);
            choseActList.sort(new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> p1, Pair<Integer, Double> p2) {
                    double eval1 = ((Integer)p1.m_a).intValue();
                    double eval2 = ((Integer)p2.m_a).intValue();
                    return Double.compare(eval2, eval1);
                }
            });
            for (Pair pair : choseActList) {
                unitActionTable.remove((Integer)pair.m_a);
            }
        }
        return this.sampling.generatePlayerActionAll(unitActionTable, player, gameState, false);
    }

    private Set<PlayerAction> stageChoosePlayerActionByDist(List<double[]> distributions, int player, GameState gameState, List<Sampling.UnitActionTableEntry> unitActionTable) throws Exception {
        int budget = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        int actionCount = 1;
        while ((int)((double)(budget / ++actionCount) / Math.ceil(Sampling.log(actionCount, 2.0))) != 1) {
        }
        HashSet<PlayerAction> actionSet = new HashSet<PlayerAction>();
        for (int r = 0; r < actionCount; ++r) {
            PlayerAction playerAction;
            switch (this.generateType) {
                case PER_AGENT: {
                    playerAction = this.sampling.generatePlayerActionGivenDist(unitActionTable, player, gameState, distributions, null);
                    break;
                }
                case ONE_DIST: {
                    playerAction = this.sampling.generatePlayerActionOneDist(unitActionTable, player, gameState, distributions);
                    break;
                }
                default: {
                    throw new RuntimeException("Unkonwn GenerateType");
                }
            }
            if (actionSet.contains(playerAction)) continue;
            actionSet.add(playerAction);
        }
        return actionSet;
    }

    private PlayerAction stageEvaluateHalving(Set<PlayerAction> actionSet, int player, GameState gameState) throws Exception {
        int budget = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        List<Pair<PlayerAction, Double>> actionList = new LinkedList<Pair<PlayerAction, Double>>();
        for (PlayerAction playerAction : actionSet) {
            actionList.add(new Pair<PlayerAction, Double>(playerAction, 0.0));
        }
        this.actionCount = actionList.size();
        double log2ceil = Math.ceil(Sampling.log(this.actionCount, 2.0));
        int rSup = this.log2int(this.actionCount);
        int residueActionCount = this.actionCount;
        int residueSampleCount = 0;
        for (int r = 0; r < rSup; ++r) {
            int sampleCount = (int)((double)(budget / residueActionCount) / log2ceil);
            residueSampleCount += sampleCount * residueActionCount;
            residueActionCount /= 2;
        }
        int residue = budget - residueSampleCount;
        int sampleCountSum = 0;
        for (int r = 0; r < rSup - 1; ++r) {
            int sampleCount = (int)((double)(budget / actionList.size()) / log2ceil);
            residue -= residue / actionList.size() * actionList.size();
            actionList = this.sampling.halvedOriginalSampling(actionList, gameState, player, sampleCount += residue / actionList.size(), sampleCountSum);
            sampleCountSum += sampleCount;
        }
        actionList = this.sampling.halvedOriginalSampling(actionList, gameState, player, (budget - this.sampling.getSimulationCount()) / actionList.size(), sampleCountSum);
        return (PlayerAction)actionList.get((int)0).m_a;
    }

    private PlayerAction stageEvaluateHalvingFill(Set<PlayerAction> actionSet, int player, GameState gameState) throws Exception {
        int budget = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        List<Pair<PlayerAction, Double>> actionList = new LinkedList<Pair<PlayerAction, Double>>();
        for (PlayerAction playerAction : actionSet) {
            actionList.add(new Pair<PlayerAction, Double>(playerAction, 0.0));
        }
        this.actionCount = actionList.size();
        int noOfLayers = this.log2int(this.actionCount);
        int residueActionCount = this.actionCount;
        int residueSampleCount = 0;
        for (int r = 0; r < noOfLayers; ++r) {
            int sampleCount = budget / residueActionCount / noOfLayers;
            residueSampleCount += sampleCount * residueActionCount;
            residueActionCount /= 2;
        }
        int residue = budget - residueSampleCount;
        int sampleCountSum = 0;
        for (int r = 0; r < noOfLayers; ++r) {
            int sampleCount = budget / actionList.size() / noOfLayers;
            residue -= residue / actionList.size() * actionList.size();
            actionList = this.sampling.halvedOriginalSamplingFill(actionList, gameState, player, sampleCount += residue / actionList.size(), sampleCountSum);
            sampleCountSum += sampleCount;
        }
        return (PlayerAction)((Pair)actionList.get((int)0)).m_a;
    }

    private PlayerAction stageEvaluateEliteHalving(Set<PlayerAction> actionSet, int player, GameState gameState) throws Exception {
        int budget = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        List<Pair<PlayerAction, Pair<Double, Integer>>> actionList = new LinkedList<Pair<PlayerAction, Pair<Double, Integer>>>();
        for (PlayerAction playerAction : actionSet) {
            actionList.add(new Pair<PlayerAction, Pair<Double, Integer>>(playerAction, new Pair<Double, Integer>(0.0, 0)));
        }
        if (this.eliteReuse) {
            ArrayList<Map.Entry<PlayerAction, Pair<Double, Integer>>> eliteEntries = new ArrayList<Map.Entry<PlayerAction, Pair<Double, Integer>>>(this.elitePlayerActions.entrySet());
            eliteEntries.sort(new Comparator<Map.Entry<PlayerAction, Pair<Double, Integer>>>(){

                @Override
                public int compare(Map.Entry<PlayerAction, Pair<Double, Integer>> e1, Map.Entry<PlayerAction, Pair<Double, Integer>> e2) {
                    double eval1 = (Double)e1.getValue().m_a / (double)((Integer)e1.getValue().m_b).intValue();
                    double eval2 = (Double)e2.getValue().m_a / (double)((Integer)e2.getValue().m_b).intValue();
                    return Double.compare(eval2, eval1);
                }
            });
            while (!eliteEntries.isEmpty()) {
                Map.Entry eliteEntry = (Map.Entry)eliteEntries.remove(0);
                if (actionSet.contains(eliteEntry.getKey())) {
                    Iterator iterator = actionList.iterator();
                    while (iterator.hasNext()) {
                        Pair searchEntry = (Pair)iterator.next();
                        if (!((PlayerAction)searchEntry.m_a).equals(eliteEntry.getKey())) continue;
                        iterator.remove();
                        break;
                    }
                } else {
                    actionSet.add((PlayerAction)eliteEntry.getKey());
                }
                actionList.add(new Pair(eliteEntry.getKey(), eliteEntry.getValue()));
                if (actionList.size() < this.actionCount) continue;
                break;
            }
        }
        this.actionCount = actionList.size();
        double log2ceil = Math.ceil(Sampling.log(this.actionCount, 2.0));
        int rSup = this.log2int(this.actionCount);
        int residueActionCount = this.actionCount;
        int residueSampleCount = 0;
        for (int r = 0; r < rSup; ++r) {
            int sampleCount = (int)((double)(budget / residueActionCount) / log2ceil);
            residueSampleCount += sampleCount * residueActionCount;
            residueActionCount /= 2;
        }
        int residue = budget - residueSampleCount;
        for (int r = 0; r < rSup - 1; ++r) {
            int sampleCount = (int)((double)(budget / actionList.size()) / log2ceil);
            residue -= residue / actionList.size() * actionList.size();
            actionList = this.sampling.halvedSampling(actionList, gameState, player, sampleCount += residue / actionList.size());
        }
        actionList = this.sampling.halvedSampling(actionList, gameState, player, (this.ITERATIONS_BUDGET - this.sampling.getSimulationCount()) / actionList.size());
        return (PlayerAction)actionList.get((int)0).m_a;
    }

    private PlayerAction stageEvaluateBest(Set<PlayerAction> actionSet, int player, GameState gameState) throws Exception {
        Integer n;
        Object object;
        int budget = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        LinkedList<Pair<PlayerAction, Pair<Double, Integer>>> actionList = new LinkedList<Pair<PlayerAction, Pair<Double, Integer>>>();
        for (PlayerAction playerAction : actionSet) {
            actionList.add(new Pair<PlayerAction, Pair<Double, Integer>>(playerAction, new Pair<Double, Integer>(0.0, 0)));
        }
        this.actionCount = actionList.size();
        for (Pair pair : actionList) {
            double eval = this.sampling.evaluatePlayerAction(player, gameState, (PlayerAction)pair.m_a, 1);
            object = (Pair)pair.m_b;
            Double.valueOf((Double)((Pair)object).m_a + eval);
            ((Pair)object).m_a = ((Pair)object).m_a;
            object = (Pair)pair.m_b;
            n = (Integer)((Pair)object).m_b;
            ((Pair)object).m_b = (Integer)((Pair)object).m_b + 1;
            Integer n2 = ((Pair)object).m_b;
        }
        for (int i = 0; i <= budget - this.actionCount; ++i) {
            actionList.sort(new Comparator<Pair<PlayerAction, Pair<Double, Integer>>>(){

                @Override
                public int compare(Pair<PlayerAction, Pair<Double, Integer>> p1, Pair<PlayerAction, Pair<Double, Integer>> p2) {
                    double eval1 = (Double)((Pair)p1.m_b).m_a / (double)((Integer)((Pair)p1.m_b).m_b).intValue();
                    double eval2 = (Double)((Pair)p2.m_b).m_a / (double)((Integer)((Pair)p2.m_b).m_b).intValue();
                    return Double.compare(eval2, eval1);
                }
            });
            double d = this.sampling.evaluatePlayerAction(player, gameState, (PlayerAction)((Pair)actionList.get((int)0)).m_a, 1);
            Pair pair = (Pair)((Pair)actionList.get((int)0)).m_b;
            Double.valueOf((Double)pair.m_a + d);
            pair.m_a = pair.m_a;
            pair = (Pair)((Pair)actionList.get((int)0)).m_b;
            object = (Integer)pair.m_b;
            pair.m_b = (Integer)pair.m_b + 1;
            n = pair.m_b;
        }
        return (PlayerAction)((Pair)actionList.get((int)0)).m_a;
    }

    private void incrementActionCounter(PlayerAction playerAction, List<Sampling.UnitActionTableEntry> unitActionTableEntry) {
        ++this.nofPlays;
        this.nofNoops += playerAction.hasNamNoneActions();
        this.nofSamples += this.sampling.getSimulationCount();
        this.nofPlayedUnits += playerAction.getActions().size();
        for (Sampling.UnitActionTableEntry actionTableEntry : unitActionTableEntry) {
            this.nofActions += actionTableEntry.nactions;
        }
    }

    private int log2int(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    private boolean isPlayerActionValid(GameState gs, PlayerAction playerAction) {
        ResourceUsage stateResourceUsage = new ResourceUsage();
        PhysicalGameState pgs = gs.getPhysicalGameState();
        for (Unit u : pgs.getUnits()) {
            UnitActionAssignment uaa = gs.getUnitActions().get(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, pgs);
            stateResourceUsage.merge(ru);
        }
        ResourceUsage actionResourceUsage = new ResourceUsage();
        for (Pair<Unit, UnitAction> element : playerAction.getActions()) {
            ResourceUsage resourceUsage = ((UnitAction)element.m_b).resourceUsage((Unit)element.m_a, pgs);
            actionResourceUsage.merge(resourceUsage);
        }
        playerAction.setResourceUsage(actionResourceUsage);
        return playerAction.consistentWith(stateResourceUsage, gs);
    }

    private List<Sampling.UnitActionTableEntry> prepareUnitActionTable(GameState gameState, int player) throws Exception {
        ArrayList<Sampling.UnitActionTableEntry> unitActionTable = new ArrayList<Sampling.UnitActionTableEntry>();
        this.actionCount = 0;
        PlayerActionGenerator moveGenerator = new PlayerActionGenerator(gameState, player);
        int idx = 0;
        for (Pair<Unit, List<UnitAction>> choice : moveGenerator.getChoices()) {
            Sampling.UnitActionTableEntry ae = new Sampling.UnitActionTableEntry();
            ae.idx = idx;
            ae.u = (Unit)choice.m_a;
            ae.nactions = ((List)choice.m_b).size();
            ae.actions = (List)choice.m_b;
            ae.accum_evaluation = new double[ae.nactions];
            ae.visit_count = new int[ae.nactions];
            for (int i = 0; i < ae.nactions; ++i) {
                ae.accum_evaluation[i] = Double.MIN_VALUE;
                ae.visit_count[i] = 0;
            }
            unitActionTable.add(ae);
            ++idx;
            this.actionCount += ae.nactions;
        }
        return unitActionTable;
    }

    private List<Integer> getRelaxedAgentIndicesRandom(List<Sampling.UnitActionTableEntry> unitActionTable) {
        List<Integer> indices = new ArrayList<Integer>();
        int noToRemove = unitActionTable.size() - this.relaxationLimit;
        if (noToRemove > 0) {
            for (int i = 0; i < unitActionTable.size(); ++i) {
                indices.add(i);
            }
            Collections.shuffle(indices);
            indices = indices.subList(0, noToRemove);
            Collections.sort(indices);
            Collections.reverse(indices);
        }
        return indices;
    }

    public void printState(List<Sampling.UnitActionTableEntry> unitActionTable, HashMap<Long, PlayerActionTableEntry> playerActionTable) {
        System.out.println("Unit actions table:");
        for (Sampling.UnitActionTableEntry uat : unitActionTable) {
            System.out.println("Actions for unit " + uat.u);
            for (int i = 0; i < uat.nactions; ++i) {
                System.out.println("   " + uat.actions.get(i) + " visited " + uat.visit_count[i] + " with average evaluation " + uat.accum_evaluation[i] / (double)uat.visit_count[i]);
            }
        }
        System.out.println("Player actions:");
        for (PlayerActionTableEntry pate : playerActionTable.values()) {
            System.out.println(pate.pa + " visited " + pate.visit_count + " with average evaluation " + pate.accum_evaluation / (float)pate.visit_count);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.ITERATIONS_BUDGET + ", " + this.lookAhead + ", " + this.split + ", " + (Object)((Object)this.estimateType) + ", " + (Object)((Object)this.estimateReuseType) + ", " + (Object)((Object)this.generateType) + ", " + (Object)((Object)this.agentOrderingType) + ", " + (Object)((Object)this.evaluateType) + ", " + this.eliteReuse + ", " + (Object)((Object)this.relaxationType) + ", " + this.relaxationLimit + ", " + this.epochal + ", " + this.simulationAi + ", " + this.evalFunction + ")";
    }

    @Override
    public String statisticsString() {
        return this.nofPlays + "\t" + this.nofNoops + "\t" + this.nofSamples + "\t" + (double)this.nofPlayedUnits / (double)this.nofPlays + "\t" + (double)this.nofActions / (double)this.nofPlays;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, 500));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        ParameterSpecification ps_split = new ParameterSpecification("Split", Double.TYPE, 0.25);
        ps_split.setRange(0.0, 1.0);
        parameters.add(ps_split);
        ParameterSpecification ps_et = new ParameterSpecification("EstimateType", EstimateType.class, (Object)EstimateType.RANDOM_TAIL);
        ps_et.addPossibleValue((Object)EstimateType.RANDOM_TAIL);
        ps_et.addPossibleValue((Object)EstimateType.RANDOM_TAIL_ELITE);
        ps_et.addPossibleValue((Object)EstimateType.NOOP_TAIL);
        ps_et.addPossibleValue((Object)EstimateType.RANDOM);
        ps_et.addPossibleValue((Object)EstimateType.ALL_COMBINATIONS);
        parameters.add(ps_et);
        ParameterSpecification ert_et = new ParameterSpecification("EstimateReuseType", EstimateReuseType.class, (Object)EstimateReuseType.ALL);
        ert_et.addPossibleValue((Object)EstimateReuseType.ALL);
        ert_et.addPossibleValue((Object)EstimateReuseType.SINGLE);
        parameters.add(ert_et);
        ParameterSpecification gt_et = new ParameterSpecification("GenerateType", GenerateType.class, (Object)GenerateType.PER_AGENT);
        gt_et.addPossibleValue((Object)GenerateType.ONE_DIST);
        gt_et.addPossibleValue((Object)GenerateType.PER_AGENT);
        parameters.add(gt_et);
        ParameterSpecification aot_et = new ParameterSpecification("AgentOrderingType", Sampling.AgentOrderingType.class, (Object)Sampling.AgentOrderingType.ENTROPY);
        aot_et.addPossibleValue((Object)Sampling.AgentOrderingType.RANDOM);
        aot_et.addPossibleValue((Object)Sampling.AgentOrderingType.ENTROPY);
        parameters.add(aot_et);
        ParameterSpecification et_et = new ParameterSpecification("EvaluateType", EvaluateType.class, (Object)EvaluateType.HALVING);
        et_et.addPossibleValue((Object)EvaluateType.HALVING);
        et_et.addPossibleValue((Object)EvaluateType.HALVING_ELITE);
        et_et.addPossibleValue((Object)EvaluateType.BEST);
        parameters.add(et_et);
        parameters.add(new ParameterSpecification("EliteReuse", Boolean.TYPE, false));
        ParameterSpecification rt_et = new ParameterSpecification("RelaxationType", RelaxationType.class, (Object)RelaxationType.NONE);
        rt_et.addPossibleValue((Object)RelaxationType.NONE);
        rt_et.addPossibleValue((Object)RelaxationType.PRE_RANDOM);
        rt_et.addPossibleValue((Object)RelaxationType.EPOCH);
        rt_et.addPossibleValue((Object)RelaxationType.MAX);
        rt_et.addPossibleValue((Object)RelaxationType.MEAN);
        rt_et.addPossibleValue((Object)RelaxationType.MEDIAN);
        rt_et.addPossibleValue((Object)RelaxationType.MAX_ENT);
        rt_et.addPossibleValue((Object)RelaxationType.MIN_ENT);
        rt_et.addPossibleValue((Object)RelaxationType.POST_RANDOM);
        rt_et.addPossibleValue((Object)RelaxationType.POST_ENTROPY_MAX);
        rt_et.addPossibleValue((Object)RelaxationType.POST_ENTROPY_MIN);
        rt_et.addPossibleValue((Object)RelaxationType.POST_MAX_DIFF);
        rt_et.addPossibleValue((Object)RelaxationType.POST_MAX_TIME_NORMALIZE);
        parameters.add(rt_et);
        parameters.add(new ParameterSpecification("RelaxationLimit", Integer.TYPE, 2));
        parameters.add(new ParameterSpecification("Epochal", Boolean.TYPE, this.epochal));
        parameters.add(new ParameterSpecification("SimulationAI", AI.class, this.simulationAi));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.lookAhead;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.lookAhead = a_pola;
    }

    public double getSplit() {
        return this.split;
    }

    public void setSplit(double a_split) {
        this.split = a_split;
    }

    public EstimateType getEstimateType() {
        return this.estimateType;
    }

    public void setEstimateType(EstimateType a) {
        this.estimateType = a;
    }

    public EstimateReuseType getEstimateReuseType() {
        return this.estimateReuseType;
    }

    public void setEstimateReuseType(EstimateReuseType a) {
        this.estimateReuseType = a;
    }

    public GenerateType getGenerateType() {
        return this.generateType;
    }

    public void setGenerateType(GenerateType a) {
        this.generateType = a;
    }

    public Sampling.AgentOrderingType getAgentOrderingType() {
        return this.agentOrderingType;
    }

    public void setAgentOrderingType(Sampling.AgentOrderingType a) {
        this.agentOrderingType = a;
    }

    public EvaluateType getEvaluateType() {
        return this.evaluateType;
    }

    public void setEvaluateType(EvaluateType a) {
        this.evaluateType = a;
    }

    public boolean getEliteReuse() {
        return this.eliteReuse;
    }

    public void setEliteReuse(boolean a) {
        this.eliteReuse = a;
    }

    public RelaxationType getRelaxationType() {
        return this.relaxationType;
    }

    public void setRelaxationType(RelaxationType a) {
        this.relaxationType = a;
    }

    public int getRelaxationLimit() {
        return this.relaxationLimit;
    }

    public void setRelaxationLimit(int a) {
        this.relaxationLimit = a;
    }

    public boolean getEpochal() {
        return this.epochal;
    }

    public void setEpochal(boolean a) {
        this.epochal = a;
    }

    public AI getSimulationAI() {
        return this.simulationAi;
    }

    public void setSimulationAI(AI a) {
        this.simulationAi = a;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evalFunction;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.evalFunction = a_ef;
    }

    class PlayerActionTableEntry {
        long code;
        int[] selectedUnitActions;
        PlayerAction pa;
        float accum_evaluation;
        int visit_count;

        PlayerActionTableEntry() {
        }
    }

    public static enum RelaxationType {
        NONE,
        PRE_RANDOM,
        EPOCH,
        MAX,
        MEAN,
        MEDIAN,
        MAX_ENT,
        MIN_ENT,
        POST_RANDOM,
        POST_ENTROPY_MAX,
        POST_ENTROPY_MIN,
        POST_MAX_DIFF,
        POST_MAX_TIME_NORMALIZE;

    }

    public static enum EvaluateType {
        HALVING,
        HALVING_ELITE,
        BEST;

    }

    public static enum GenerateType {
        ONE_DIST,
        PER_AGENT;

    }

    public static enum EstimateReuseType {
        ALL,
        SINGLE;

    }

    public static enum EstimateType {
        RANDOM_TAIL,
        RANDOM_TAIL_ELITE,
        NOOP_TAIL,
        RANDOM,
        ALL_COMBINATIONS;

    }
}

