/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio;

import ai.RandomBiasedAI;
import ai.abstraction.LightRush;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerRush;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PortfolioAI
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    int LOOKAHEAD = 500;
    AI[] strategies;
    boolean[] deterministic;
    EvaluationFunction evaluation;
    GameState gs_to_start_from;
    double[][] scores;
    int[][] counts;
    int nplayouts = 0;
    int playerForThisComputation;

    public PortfolioAI(UnitTypeTable utt) {
        this(new AI[]{new WorkerRush(utt), new LightRush(utt), new RangedRush(utt), new RandomBiasedAI()}, new boolean[]{true, true, true, false}, 100, -1, 100, new SimpleSqrtEvaluationFunction3());
    }

    public PortfolioAI(AI[] s, boolean[] d, int time, int max_playouts, int la, EvaluationFunction e) {
        super(time, max_playouts);
        this.LOOKAHEAD = la;
        this.strategies = s;
        this.deterministic = d;
        this.evaluation = e;
    }

    @Override
    public void reset() {
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int a_player, GameState gs) {
        int n = this.strategies.length;
        this.scores = new double[n][n];
        this.counts = new int[n][n];
        this.playerForThisComputation = a_player;
        this.gs_to_start_from = gs;
        this.nplayouts = 0;
    }

    public void resetSearch() {
        this.scores = null;
        this.counts = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        boolean anyChange;
        int n = this.strategies.length;
        boolean timeout = false;
        long start = System.currentTimeMillis();
        do {
            anyChange = false;
            for (int i = 0; i < n && !timeout; ++i) {
                for (int j = 0; j < n && !timeout; ++j) {
                    if (this.counts[i][j] == 0 || !this.deterministic[i] || !this.deterministic[j]) {
                        anyChange = true;
                        AI ai1 = this.strategies[i].clone();
                        AI ai2 = this.strategies[j].clone();
                        GameState gs2 = this.gs_to_start_from.clone();
                        ai1.reset();
                        ai2.reset();
                        int timeLimit = gs2.getTime() + this.LOOKAHEAD;
                        boolean gameover = false;
                        while (!gameover && gs2.getTime() < timeLimit) {
                            if (gs2.isComplete()) {
                                gameover = gs2.cycle();
                                continue;
                            }
                            gs2.issue(ai1.getAction(this.playerForThisComputation, gs2));
                            gs2.issue(ai2.getAction(1 - this.playerForThisComputation, gs2));
                        }
                        double[] dArray = this.scores[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + (double)this.evaluation.evaluate(this.playerForThisComputation, 1 - this.playerForThisComputation, gs2);
                        int[] nArray = this.counts[i];
                        int n3 = j;
                        nArray[n3] = nArray[n3] + 1;
                        ++this.nplayouts;
                    }
                    if (this.ITERATIONS_BUDGET > 0 && this.nplayouts >= this.ITERATIONS_BUDGET) {
                        timeout = true;
                    }
                    if (this.TIME_BUDGET <= 0 || System.currentTimeMillis() <= start + (long)this.TIME_BUDGET) continue;
                    timeout = true;
                }
            }
        } while (anyChange && !timeout);
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        int n = this.strategies.length;
        if (DEBUG >= 1) {
            int j;
            int i;
            System.out.println("PortfolioAI, game cycle: " + this.gs_to_start_from.getTime());
            System.out.println("  counts:");
            for (i = 0; i < n; ++i) {
                System.out.print("    ");
                for (j = 0; j < n; ++j) {
                    System.out.print(this.counts[i][j] + "\t");
                }
                System.out.println("");
            }
            System.out.println("  scores:");
            for (i = 0; i < n; ++i) {
                System.out.print("    ");
                for (j = 0; j < n; ++j) {
                    System.out.print(this.scores[i][j] / (double)this.counts[i][j] + "\t");
                }
                System.out.println("");
            }
        }
        double bestMaxScore = 0.0;
        int bestMax = -1;
        for (int i = 0; i < n; ++i) {
            double bestMinScore = 0.0;
            int bestMin = -1;
            for (int j = 0; j < n; ++j) {
                double s = this.scores[i][j] / (double)this.counts[i][j];
                if (bestMin != -1 && !(s < bestMinScore)) continue;
                bestMin = j;
                bestMinScore = s;
            }
            if (bestMax != -1 && !(bestMinScore > bestMaxScore)) continue;
            bestMax = i;
            bestMaxScore = bestMinScore;
        }
        if (DEBUG >= 1) {
            System.out.println("PortfolioAI: selected " + bestMax + "  with score: " + bestMaxScore);
        }
        AI ai = this.strategies[bestMax].clone();
        ai.reset();
        return ai.getAction(this.playerForThisComputation, this.gs_to_start_from);
    }

    @Override
    public AI clone() {
        return new PortfolioAI(this.strategies, this.deterministic, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.LOOKAHEAD, this.evaluation);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.LOOKAHEAD + ", " + this.evaluation + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.LOOKAHEAD;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.LOOKAHEAD = a_pola;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evaluation;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.evaluation = a_ef;
    }
}

