/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import ai.portfolio.portfoliogreedysearch.UnitScriptAttack;
import ai.portfolio.portfoliogreedysearch.UnitScriptBuild;
import ai.portfolio.portfoliogreedysearch.UnitScriptHarvest;
import ai.portfolio.portfoliogreedysearch.UnitScriptIdle;
import ai.portfolio.portfoliogreedysearch.UnitScriptTrain;
import ai.portfolio.portfoliogreedysearch.UnitScriptsAI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class PGSAI
extends AIWithComputationBudget {
    public static int DEBUG = 0;
    int LOOKAHEAD = 500;
    int I = 1;
    int R = 1;
    EvaluationFunction evaluation;
    HashMap<UnitType, List<UnitScript>> scripts;
    UnitTypeTable utt;
    PathFinding pf;
    UnitScript defaultScript;
    long start_time = 0L;
    int nplayouts = 0;

    public PGSAI(UnitTypeTable utt) {
        this(100, -1, 100, 1, 1, new SimpleSqrtEvaluationFunction3(), utt, new AStarPathFinding());
    }

    public PGSAI(int time, int max_playouts, int la, int a_I, int a_R, EvaluationFunction e, UnitTypeTable a_utt, PathFinding a_pf) {
        super(time, max_playouts);
        this.LOOKAHEAD = la;
        this.I = a_I;
        this.R = a_R;
        this.evaluation = e;
        this.utt = a_utt;
        this.pf = a_pf;
        UnitScriptHarvest harvest = new UnitScriptHarvest(this.pf, this.utt);
        UnitScriptBuild buildBarracks = new UnitScriptBuild(this.pf, this.utt.getUnitType("Barracks"));
        UnitScriptBuild buildBase = new UnitScriptBuild(this.pf, this.utt.getUnitType("Base"));
        UnitScriptAttack attack = new UnitScriptAttack(this.pf);
        UnitScriptIdle idle = new UnitScriptIdle();
        UnitScriptTrain trainWorker = new UnitScriptTrain(this.utt.getUnitType("Worker"));
        UnitScriptTrain trainLight = new UnitScriptTrain(this.utt.getUnitType("Light"));
        UnitScriptTrain trainHeavy = new UnitScriptTrain(this.utt.getUnitType("Heavy"));
        UnitScriptTrain trainRanged = new UnitScriptTrain(this.utt.getUnitType("Ranged"));
        this.defaultScript = idle;
        this.scripts = new HashMap();
        ArrayList<UnitScript> l = new ArrayList<UnitScript>();
        l.add(harvest);
        l.add(buildBarracks);
        l.add(buildBase);
        l.add(attack);
        l.add(idle);
        this.scripts.put(this.utt.getUnitType("Worker"), l);
        l = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Base"), l);
        l.add(trainWorker);
        l.add(idle);
        l = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Barracks"), l);
        l.add(trainLight);
        l.add(trainHeavy);
        l.add(trainRanged);
        l.add(idle);
        l = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Light"), l);
        l.add(attack);
        l.add(idle);
        l = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Heavy"), l);
        l.add(attack);
        l.add(idle);
        l = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Ranged"), l);
        l.add(attack);
        l.add(idle);
    }

    @Override
    public void reset() {
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        int i;
        if (gs.winner() != -1) {
            return new PlayerAction();
        }
        if (!gs.canExecuteAnyAction(player)) {
            return new PlayerAction();
        }
        if (DEBUG >= 1) {
            System.out.println("PGSAI " + player + "(MAX_TIME = " + this.TIME_BUDGET + ", I: " + this.I + ", R: " + this.R + ")");
        }
        ArrayList<Unit> playerUnits = new ArrayList<Unit>();
        ArrayList<Unit> enemyUnits = new ArrayList<Unit>();
        for (Unit u : gs.getUnits()) {
            if (u.getPlayer() == player) {
                playerUnits.add(u);
                continue;
            }
            if (u.getPlayer() < 0) continue;
            enemyUnits.add(u);
        }
        int n1 = playerUnits.size();
        int n2 = enemyUnits.size();
        UnitScript[] playerScripts = new UnitScript[n1];
        UnitScript[] enemyScripts = new UnitScript[n2];
        for (i = 0; i < n1; ++i) {
            playerScripts[i] = this.defaultScript((Unit)playerUnits.get(i), gs);
        }
        for (i = 0; i < n2; ++i) {
            enemyScripts[i] = this.defaultScript((Unit)enemyUnits.get(i), gs);
        }
        this.start_time = System.currentTimeMillis();
        this.nplayouts = 0;
        this.improve(player, playerScripts, playerUnits, enemyScripts, enemyUnits, gs);
        for (int r = 0; r < this.R; ++r) {
            this.improve(1 - player, enemyScripts, enemyUnits, playerScripts, playerUnits, gs);
            this.improve(player, playerScripts, playerUnits, enemyScripts, enemyUnits, gs);
        }
        PlayerAction pa = new PlayerAction();
        ResourceUsage ra = gs.getResourceUsage();
        for (int i2 = 0; i2 < n1; ++i2) {
            ResourceUsage ra2;
            UnitAction ua;
            Unit u = (Unit)playerUnits.get(i2);
            if (gs.getUnitAction(u) != null) continue;
            UnitScript s = playerScripts[i2];
            if (s != null) {
                s = s.instantiate(u, gs);
            }
            if (s == null || (ua = s.getAction(u, gs)) == null || !ra.consistentWith(ra2 = ua.resourceUsage(u, gs.getPhysicalGameState()), gs)) continue;
            pa.addUnitAction(u, ua);
            ra.merge(ra2);
        }
        pa.fillWithNones(gs, player, 10);
        return pa;
    }

    public UnitScript defaultScript(Unit u, GameState gs) {
        List<UnitScript> l = this.scripts.get(u.getType());
        return l.get(0).instantiate(u, gs);
    }

    public void improve(int player, UnitScript[] scriptsToImprove, List<Unit> units, UnitScript[] otherScripts, List<Unit> otherUnits, GameState gs) throws Exception {
        for (int i = 0; i < this.I; ++i) {
            if (DEBUG >= 1) {
                System.out.println("Improve player " + player + "(" + i + "/" + this.I + ")");
            }
            for (int u = 0; u < scriptsToImprove.length; ++u) {
                if (this.ITERATIONS_BUDGET > 0 && this.nplayouts >= this.ITERATIONS_BUDGET) {
                    if (DEBUG >= 1) {
                        System.out.println("nplayouts>=MAX_PLAYOUTS");
                    }
                    return;
                }
                if (this.TIME_BUDGET > 0 && System.currentTimeMillis() >= this.start_time + (long)this.TIME_BUDGET) {
                    if (DEBUG >= 1) {
                        System.out.println("Time out!");
                    }
                    return;
                }
                Unit unit = units.get(u);
                double bestEvaluation = 0.0;
                UnitScript bestScript = null;
                List<UnitScript> candidates = this.scripts.get(unit.getType());
                for (UnitScript us : candidates) {
                    UnitScript s = us.instantiate(unit, gs);
                    if (s == null) continue;
                    scriptsToImprove[u] = s;
                    double e = this.playout(player, scriptsToImprove, units, otherScripts, otherUnits, gs);
                    if (DEBUG >= 2) {
                        System.out.println("  " + unit + " -> " + s.getClass().toString() + " -> " + e);
                    }
                    if (bestScript != null && !(e > bestEvaluation)) continue;
                    bestScript = us;
                    bestEvaluation = e;
                    if (DEBUG < 2) continue;
                    System.out.println("    new best: " + e);
                }
                scriptsToImprove[u] = bestScript;
            }
        }
    }

    public double playout(int player, UnitScript[] scripts1, List<Unit> units1, UnitScript[] scripts2, List<Unit> units2, GameState gs) throws Exception {
        ++this.nplayouts;
        UnitScriptsAI ai1 = new UnitScriptsAI(scripts1, units1, this.scripts, this.defaultScript);
        UnitScriptsAI ai2 = new UnitScriptsAI(scripts2, units2, this.scripts, this.defaultScript);
        GameState gs2 = gs.clone();
        ((AI)ai1).reset();
        ((AI)ai2).reset();
        int timeLimit = gs2.getTime() + this.LOOKAHEAD;
        boolean gameover = false;
        while (!gameover && gs2.getTime() < timeLimit) {
            if (gs2.isComplete()) {
                gameover = gs2.cycle();
                continue;
            }
            gs2.issue(((AI)ai1).getAction(player, gs2));
            gs2.issue(((AI)ai2).getAction(1 - player, gs2));
        }
        double e = this.evaluation.evaluate(player, 1 - player, gs2);
        return e;
    }

    @Override
    public AI clone() {
        return new PGSAI(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.LOOKAHEAD, this.I, this.R, this.evaluation, this.utt, this.pf);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.LOOKAHEAD + ", " + this.I + ", " + this.R + ", " + this.evaluation + ", " + this.pf + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("I", Integer.TYPE, 1));
        parameters.add(new ParameterSpecification("R", Integer.TYPE, 1));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return parameters;
    }

    public int getPlayoutLookahead() {
        return this.LOOKAHEAD;
    }

    public void setPlayoutLookahead(int a_pola) {
        this.LOOKAHEAD = a_pola;
    }

    public int getI() {
        return this.I;
    }

    public void setI(int a) {
        this.I = a;
    }

    public int getR() {
        return this.R;
    }

    public void setR(int a) {
        this.R = a;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evaluation;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.evaluation = a_ef;
    }

    public PathFinding getPathFinding() {
        return this.pf;
    }

    public void setPathFinding(PathFinding a_pf) {
        this.pf = a_pf;
    }
}

