/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.abstraction.AbstractAction;
import ai.abstraction.Attack;
import ai.abstraction.pathfinding.PathFinding;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import rts.GameState;
import rts.UnitAction;
import rts.units.Unit;

public class UnitScriptAttack
extends UnitScript {
    AbstractAction action;
    PathFinding pf;

    public UnitScriptAttack(PathFinding a_pf) {
        this.pf = a_pf;
    }

    @Override
    public UnitAction getAction(Unit u, GameState gs) {
        if (this.action.completed(gs)) {
            return null;
        }
        return this.action.execute(gs);
    }

    @Override
    public UnitScript instantiate(Unit u, GameState gs) {
        Unit closestEnemy = this.closestEnemyUnit(u, gs);
        if (closestEnemy != null) {
            UnitScriptAttack script = new UnitScriptAttack(this.pf);
            script.action = new Attack(u, closestEnemy, this.pf);
            return script;
        }
        return null;
    }

    public Unit closestEnemyUnit(Unit u, GameState gs) {
        Unit closest = null;
        int closestDistance = 0;
        for (Unit u2 : gs.getPhysicalGameState().getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == u.getPlayer()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closest != null && d >= closestDistance) continue;
            closest = u2;
            closestDistance = d;
        }
        return closest;
    }
}

