/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.abstraction.AbstractAction;
import ai.abstraction.Build;
import ai.abstraction.pathfinding.PathFinding;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import rts.GameState;
import rts.PhysicalGameState;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;

public class UnitScriptBuild
extends UnitScript {
    AbstractAction action;
    PathFinding pf;
    UnitType ut;

    public UnitScriptBuild(PathFinding a_pf, UnitType a_ut) {
        this.pf = a_pf;
        this.ut = a_ut;
    }

    @Override
    public UnitAction getAction(Unit u, GameState gs) {
        if (this.action.completed(gs)) {
            return null;
        }
        return this.action.execute(gs);
    }

    @Override
    public UnitScript instantiate(Unit u, GameState gs) {
        int pos = this.findBuildingPosition(u, gs.getPhysicalGameState());
        if (pos != -1) {
            UnitScriptBuild script = new UnitScriptBuild(this.pf, this.ut);
            script.action = new Build(u, this.ut, pos % gs.getPhysicalGameState().getWidth(), pos / gs.getPhysicalGameState().getWidth(), this.pf);
            return script;
        }
        return null;
    }

    public int findBuildingPosition(Unit u, PhysicalGameState pgs) {
        int bestPos = -1;
        int bestScore = 0;
        for (int x = 0; x < pgs.getWidth(); ++x) {
            for (int y = 0; y < pgs.getHeight(); ++y) {
                int pos = x + y * pgs.getWidth();
                if (pgs.getUnitAt(x, y) != null) continue;
                int score = 0;
                score = -(Math.abs(u.getX() - x) + Math.abs(u.getY() - y));
                if (bestPos != -1 && score <= bestScore) continue;
                bestPos = pos;
                bestScore = score;
            }
        }
        return bestPos;
    }
}

