/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.abstraction.AbstractAction;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.PathFinding;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import rts.GameState;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class UnitScriptHarvest
extends UnitScript {
    AbstractAction action;
    PathFinding pf;
    UnitTypeTable utt;

    public UnitScriptHarvest(PathFinding a_pf, UnitTypeTable a_utt) {
        this.pf = a_pf;
        this.utt = a_utt;
    }

    @Override
    public UnitAction getAction(Unit u, GameState gs) {
        if (this.action.completed(gs)) {
            return null;
        }
        return this.action.execute(gs);
    }

    @Override
    public UnitScript instantiate(Unit u, GameState gs) {
        Unit closestResource = this.closestUnitOfType(u, gs, this.utt.getUnitType("Resource"), null);
        Unit closestBase = this.closestUnitOfType(u, gs, this.utt.getUnitType("Base"), u.getPlayer());
        if (closestResource != null && closestBase != null) {
            UnitScriptHarvest script = new UnitScriptHarvest(this.pf, this.utt);
            script.action = new Harvest(u, closestResource, closestBase, this.pf);
            return script;
        }
        return null;
    }

    public Unit closestUnitOfType(Unit u, GameState gs, UnitType type, Integer player) {
        Unit closest = null;
        int closestDistance = 0;
        for (Unit u2 : gs.getPhysicalGameState().getUnits()) {
            if (u2.getType() != type || player != null && u2.getPlayer() != player.intValue()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closest != null && d >= closestDistance) continue;
            closest = u2;
            closestDistance = d;
        }
        return closest;
    }
}

