/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;

public class UnitScriptsAI
extends AI {
    public static int DEBUG = 0;
    UnitScript[] scriptsInput;
    List<Unit> unitsInput;
    HashMap<Long, UnitScript> scripts = new HashMap();
    HashMap<UnitType, List<UnitScript>> allScripts;
    UnitScript defaultScript;

    public UnitScriptsAI(UnitScript[] a_scripts, List<Unit> a_units, HashMap<UnitType, List<UnitScript>> a_allScripts, UnitScript a_defaultScript) {
        this.scriptsInput = a_scripts;
        this.unitsInput = a_units;
        for (int i = 0; i < a_scripts.length; ++i) {
            this.scripts.put(a_units.get(i).getID(), a_scripts[i]);
        }
        this.allScripts = a_allScripts;
        this.defaultScript = a_defaultScript;
    }

    @Override
    public void reset() {
    }

    public void resetScripts(GameState gs) {
        for (Long ID : this.scripts.keySet()) {
            UnitScript s = this.scripts.get(ID);
            this.scripts.put(ID, s.instantiate(gs.getUnit(ID), gs));
        }
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        PlayerAction pa = new PlayerAction();
        ResourceUsage ru = gs.getResourceUsage();
        for (Unit u : gs.getUnits()) {
            ResourceUsage ru2;
            UnitAction ua;
            if (u.getPlayer() != player || gs.getUnitAction(u) != null) continue;
            UnitScript s = this.scripts.get(u.getID());
            if (s != null) {
                s = s.instantiate(u, gs);
            }
            if (s == null) {
                s = this.allScripts.get(u.getType()).get(0).instantiate(u, gs);
                if (s == null) {
                    s = this.defaultScript.instantiate(u, gs);
                }
                this.scripts.put(u.getID(), s);
            }
            if ((ua = s.getAction(u, gs)) == null || !ru.consistentWith(ru2 = ua.resourceUsage(u, gs.getPhysicalGameState()), gs)) continue;
            pa.addUnitAction(u, ua);
            ru.merge(ru2);
        }
        pa.fillWithNones(gs, player, 10);
        return pa;
    }

    @Override
    public AI clone() {
        return new UnitScriptsAI(this.scriptsInput, this.unitsInput, this.allScripts, this.defaultScript);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("Scripts", List.class, this.scriptsInput));
        parameters.add(new ParameterSpecification("Units", List.class, this.unitsInput));
        parameters.add(new ParameterSpecification("AllScripts", HashMap.class, this.allScripts));
        parameters.add(new ParameterSpecification("DefaultScript", UnitScript.class, this.defaultScript));
        return parameters;
    }
}

