/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.ParameterSpecification;
import ai.puppet.BasicChoicePoint;
import ai.puppet.ConfigurableScript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class BasicConfigurableScript
extends ConfigurableScript<BasicChoicePoint> {
    Random r = new Random();
    UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType lightType;
    UnitType heavyType;
    UnitType rangedType;
    UnitType resourceType;
    int resourcesUsed;
    int nbases;
    int nbarracks;
    int nresources;
    int ownresources;
    int abandonedbases;
    int freeresources;
    int nworkers;
    private static final int BASE_RESOURCE_RADIUS = 8;

    public BasicConfigurableScript(UnitTypeTable a_utt) {
        this(a_utt, new FloodFillPathFinding());
    }

    public BasicConfigurableScript(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_pf);
        this.utt = a_utt;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.lightType = this.utt.getUnitType("Light");
        this.heavyType = this.utt.getUnitType("Heavy");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.resourceType = this.utt.getUnitType("Resource");
        this.choicePoints = new EnumMap(BasicChoicePoint.class);
        this.choices = new EnumMap(BasicChoicePoint.class);
        this.choicePointValues = BasicChoicePoint.values();
        this.reset();
    }

    @Override
    public ConfigurableScript<BasicChoicePoint> clone() {
        BasicConfigurableScript sc = new BasicConfigurableScript(this.utt, this.pf);
        sc.choices = this.choices.clone();
        sc.choicePoints = this.choicePoints.clone();
        sc.choicePointValues = (Enum[])((BasicChoicePoint[])this.choicePointValues).clone();
        return sc;
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player p = gs.getPlayer(player);
        this.resourcesUsed = gs.getResourceUsage().getResourcesUsed(player);
        this.nworkers = 0;
        this.nbases = 0;
        this.nbarracks = 0;
        this.nresources = 0;
        this.ownresources = 0;
        this.abandonedbases = 0;
        this.freeresources = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.workerType || u2.getPlayer() != p.getID()) continue;
            ++this.nworkers;
        }
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++this.nbases;
                if (!pgs.getUnitsAround(u2.getX(), u2.getY(), 8).stream().map(a -> a.getType() == this.resourceType).reduce((a, b) -> a != false || b != false).get().booleanValue()) {
                    ++this.abandonedbases;
                }
            }
            if (u2.getType() == this.barracksType && u2.getPlayer() == p.getID()) {
                ++this.nbarracks;
            }
            if (u2.getType() != this.resourceType) continue;
            ++this.nresources;
            if (pgs.getUnitsAround(u2.getX(), u2.getY(), 8).stream().map(a -> a.getPlayer() == p.getID() && a.getType() == this.baseType).reduce((a, b) -> a != false || b != false).get().booleanValue()) {
                ++this.ownresources;
            }
            if (pgs.getUnitsAround(u2.getX(), u2.getY(), 8).stream().map(a -> a.getPlayer() != 1 - p.getID() && a.getType() != this.baseType).reduce((a, b) -> a != false && b != false).get().booleanValue()) continue;
            ++this.freeresources;
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.baseType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.baseBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canAttack || u.getType().canHarvest || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.meleeUnitBehavior(u, p, gs);
        }
        LinkedList<Unit> workers = new LinkedList<Unit>();
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canHarvest || u.getPlayer() != player) continue;
            workers.add(u);
        }
        this.workersBehavior(workers, p, gs);
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.barracksType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.barracksBehavior(u, p, pgs);
        }
        return this.translateActions(player, gs);
    }

    public void baseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        if ((Integer)this.choices.get((Object)BasicChoicePoint.UNITTYPE) == this.workerType.ID && p.getResources() >= this.workerType.cost + this.resourcesUsed) {
            this.train(u, this.workerType);
            this.resourcesUsed += this.workerType.cost;
        }
    }

    public void barracksBehavior(Unit u, Player p, PhysicalGameState pgs) {
        UnitType toBuild = this.utt.getUnitType((Integer)this.choices.get((Object)BasicChoicePoint.UNITTYPE));
        if (!toBuild.canHarvest && p.getResources() >= toBuild.cost + this.resourcesUsed) {
            this.train(u, toBuild);
            this.resourcesUsed += toBuild.cost;
        }
    }

    public int manDist(Unit u1, Unit u2) {
        return Math.abs(u2.getX() - u1.getX()) + Math.abs(u2.getY() - u1.getY());
    }

    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : gs.getPhysicalGameState().getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = this.manDist(u, u2);
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            if (closestEnemy.getAttackRange() < u.getAttackRange() && this.sqDist(u, closestEnemy) <= closestEnemy.getAttackRange() * closestEnemy.getAttackRange()) {
                int xDiff = u.getX() - closestEnemy.getX();
                int yDiff = u.getY() - closestEnemy.getY();
                int targetX = u.getX();
                int targetY = u.getY();
                if (Math.abs(xDiff) > Math.abs(yDiff)) {
                    if (xDiff > 0 && targetX < gs.getPhysicalGameState().getWidth() - 1) {
                        targetX = u.getX() + 1;
                    } else if (xDiff < 0 && targetX > 0) {
                        targetX = u.getX() - 1;
                    }
                } else if (yDiff > 0 && targetY < gs.getPhysicalGameState().getHeight() - 1) {
                    targetY = u.getY() + 1;
                } else if (yDiff < 0 && targetY > 0) {
                    targetY = u.getY() - 1;
                }
                if (gs.free(targetX, targetY)) {
                    this.move(u, targetX, targetY);
                } else {
                    this.attack(u, closestEnemy);
                }
            } else {
                this.attack(u, closestEnemy);
            }
        }
    }

    public int sqDist(Unit u1, Unit u2) {
        int xDiff = Math.abs(u1.getX() - u2.getX());
        int yDiff = Math.abs(u1.getY() - u2.getY());
        return xDiff * xDiff + yDiff * yDiff;
    }

    public void workersBehavior(List<Unit> workers, Player p, GameState gs) {
        Unit u;
        PhysicalGameState pgs = gs.getPhysicalGameState();
        if (workers.isEmpty()) {
            return;
        }
        LinkedList<Unit> bases = new LinkedList<Unit>();
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.baseType || u2.getPlayer() != p.getID()) continue;
            bases.add(u2);
        }
        LinkedList<Unit> freeWorkers = new LinkedList<Unit>(workers);
        LinkedList<Integer> reservedPositions = new LinkedList<Integer>();
        if (this.nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + this.resourcesUsed) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
            this.resourcesUsed += this.baseType.cost;
        }
        if (this.nbarracks < this.nbases - this.abandonedbases && !this.utt.getUnitType((int)((Integer)this.choices.get((Object)((Object)BasicChoicePoint.UNITTYPE))).intValue()).canHarvest && p.getResources() >= this.barracksType.cost + this.resourcesUsed && !freeWorkers.isEmpty()) {
            u = (Unit)freeWorkers.remove(0);
            Unit b = (Unit)bases.get(this.nbarracks);
            this.buildIfNotAlreadyBuilding(u, this.barracksType, b.getX(), b.getY(), reservedPositions, p, pgs);
            this.resourcesUsed += this.barracksType.cost;
        }
        if ((Integer)this.choices.get((Object)BasicChoicePoint.EXPAND) > 0 && this.nbarracks >= 1 && this.nbases - this.abandonedbases <= 1 && this.freeresources > 0 && !freeWorkers.isEmpty()) {
            if (p.getResources() >= this.baseType.cost + this.resourcesUsed) {
                u = (Unit)freeWorkers.remove(0);
                Unit closestFreeResource = this.findClosest(u, (Unit unit) -> unit.getType() == this.resourceType && pgs.getUnitsAround(unit.getX(), unit.getY(), 10).stream().map(a -> a.getPlayer() != 1 - p.getID() && a.getType() != this.baseType).reduce((a, b) -> a != false && b != false).get() != false, pgs);
                if (closestFreeResource != null) {
                    this.buildIfNotAlreadyBuilding(u, this.baseType, closestFreeResource.getX(), closestFreeResource.getY(), reservedPositions, p, pgs);
                }
                this.resourcesUsed += this.baseType.cost;
            } else {
                this.resourcesUsed += this.baseType.cost;
            }
        }
        while ((Integer)this.choices.get((Object)BasicChoicePoint.UNITTYPE) == this.workerType.ID && freeWorkers.size() > 1) {
            this.meleeUnitBehavior((Unit)freeWorkers.remove(0), p, gs);
        }
        for (Unit u2 : freeWorkers) {
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u22 : pgs.getUnits()) {
                if (!u22.getType().isResource) continue;
                d = Math.abs(u22.getX() - u2.getX()) + Math.abs(u22.getY() - u2.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u22;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u22 : pgs.getUnits()) {
                if (!u22.getType().isStockpile || u22.getPlayer() != p.getID()) continue;
                d = Math.abs(u22.getX() - u2.getX()) + Math.abs(u22.getY() - u2.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u22;
                closestDistance = d;
            }
            if (closestResource == null || closestBase == null) continue;
            this.harvest(u2, closestResource, closestBase);
        }
    }

    public Unit findClosest(Unit from, Predicate<Unit> predicate, PhysicalGameState pgs) {
        Unit closestUnit = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (!predicate.test(u2)) continue;
            int d = Math.abs(u2.getX() - from.getX()) + Math.abs(u2.getY() - from.getY());
            if (closestUnit != null && d >= closestDistance) continue;
            closestUnit = u2;
            closestDistance = d;
        }
        return closestUnit;
    }

    public Unit findClosest(Unit from, UnitType targetType, PhysicalGameState pgs) {
        Unit closestUnit = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != targetType) continue;
            int d = Math.abs(u2.getX() - from.getX()) + Math.abs(u2.getY() - from.getY());
            if (closestUnit != null && d >= closestDistance) continue;
            closestUnit = u2;
            closestDistance = d;
        }
        return closestUnit;
    }

    public Unit findSecondClosest(Unit from, UnitType targetType, PhysicalGameState pgs) {
        return this.findClosest(from, targetType, this.findClosest(from, targetType, pgs), pgs);
    }

    public Unit findClosest(Unit from, UnitType targetType, Unit except, PhysicalGameState pgs) {
        Unit closestUnit = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != targetType || u2.getID() == except.getID()) continue;
            int d = Math.abs(u2.getX() - from.getX()) + Math.abs(u2.getY() - from.getY());
            if (closestUnit != null && d >= closestDistance) continue;
            closestUnit = u2;
            closestDistance = d;
        }
        return closestUnit;
    }

    public Unit findClosest(Unit from, UnitType targetType, Player targetPlayer, PhysicalGameState pgs) {
        Unit closestUnit = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != targetType || u2.getPlayer() != targetPlayer.getID()) continue;
            int d = Math.abs(u2.getX() - from.getX()) + Math.abs(u2.getY() - from.getY());
            if (closestUnit != null && d >= closestDistance) continue;
            closestUnit = u2;
            closestDistance = d;
        }
        return closestUnit;
    }

    public Unit findClosest(Unit from, Player targetPlayer, PhysicalGameState pgs) {
        Unit closestUnit = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() != targetPlayer.getID()) continue;
            int d = Math.abs(u2.getX() - from.getX()) + Math.abs(u2.getY() - from.getY());
            if (closestUnit != null && d >= closestDistance) continue;
            closestUnit = u2;
            closestDistance = d;
        }
        return closestUnit;
    }

    @Override
    public Collection<ConfigurableScript.Options> getApplicableChoicePoints(int player, GameState gs) {
        int nworkers = 0;
        int nbarracks = 0;
        int nbases = 0;
        int abandonedbases = 0;
        int ownresources = 0;
        int nresources = 0;
        int freeresources = 0;
        for (Unit u2 : gs.getPhysicalGameState().getUnits()) {
            if (u2.getPlayer() == player) {
                if (u2.getType() == this.workerType) {
                    ++nworkers;
                }
                if (u2.getType() == this.barracksType) {
                    ++nbarracks;
                }
                if (u2.getType() == this.baseType) {
                    ++nbases;
                    if (!gs.getPhysicalGameState().getUnitsAround(u2.getX(), u2.getY(), 8).stream().map(a -> a.getType() == this.resourceType).reduce((a, b) -> a != false || b != false).get().booleanValue()) {
                        ++abandonedbases;
                    }
                }
            }
            if (u2.getType() != this.resourceType) continue;
            ++nresources;
            if (gs.getPhysicalGameState().getUnitsAround(u2.getX(), u2.getY(), 8).stream().map(a -> a.getPlayer() == player && a.getType() == this.baseType).reduce((a, b) -> a != false || b != false).get().booleanValue()) {
                ++ownresources;
            }
            if (gs.getPhysicalGameState().getUnitsAround(u2.getX(), u2.getY(), 8).stream().map(a -> a.getType() == this.baseType).reduce((a, b) -> a != false || b != false).get().booleanValue()) continue;
            ++freeresources;
        }
        ArrayList<ConfigurableScript.Options> choices = new ArrayList<ConfigurableScript.Options>();
        if (nbarracks > 0) {
            choices.add(new ConfigurableScript.Options(this, BasicChoicePoint.UNITTYPE.ordinal(), new int[]{this.lightType.ID, this.rangedType.ID, this.heavyType.ID}));
        } else {
            choices.add(new ConfigurableScript.Options(this, BasicChoicePoint.UNITTYPE.ordinal(), new int[]{this.workerType.ID, this.lightType.ID, this.rangedType.ID, this.heavyType.ID}));
        }
        if (nbarracks < 1 || nbases - abandonedbases > 1 || freeresources == 0) {
            choices.add(new ConfigurableScript.Options(this, BasicChoicePoint.EXPAND.ordinal(), new int[]{0}));
        } else if (ownresources == 0) {
            choices.add(new ConfigurableScript.Options(this, BasicChoicePoint.EXPAND.ordinal(), new int[]{1}));
        } else {
            choices.add(new ConfigurableScript.Options(this, BasicChoicePoint.EXPAND.ordinal(), new int[]{0, 1}));
        }
        return choices;
    }

    @Override
    public void initializeChoices() {
        block4: for (BasicChoicePoint c : (BasicChoicePoint[])this.choicePointValues) {
            switch (c) {
                case UNITTYPE: {
                    this.choicePoints.put(c, new ConfigurableScript.Options(this, c.ordinal(), new int[]{this.lightType.ID, this.workerType.ID, this.rangedType.ID, this.heavyType.ID}));
                    continue block4;
                }
                case EXPAND: {
                    this.choicePoints.put(c, new ConfigurableScript.Options(this, c.ordinal(), new int[]{0, 1}));
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + "(");
        for (BasicChoicePoint c : BasicChoicePoint.values()) {
            str.append(c.toString()).append(",");
        }
        return str + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new FloodFillPathFinding()));
        return parameters;
    }
}

