/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.pathfinding.PathFinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import rts.GameState;
import util.Pair;

public abstract class ConfigurableScript<T extends Enum<T>>
extends AbstractionLayerAI {
    protected T[] choicePointValues;
    protected EnumMap<T, Options> choicePoints;
    protected EnumMap<T, Integer> choices;

    public ConfigurableScript(PathFinding a_pf) {
        super(a_pf);
    }

    @Override
    public void reset() {
        this.initializeChoices();
        this.setDefaultChoices();
    }

    public Collection<Options> getAllChoicePoints() {
        return this.choicePoints.values();
    }

    public void setChoices(Collection<Pair<Integer, Integer>> choices) {
        for (Pair<Integer, Integer> c : choices) {
            this.choices.put(this.choicePointValues[(Integer)c.m_a], (Integer)c.m_b);
        }
    }

    public void setDefaultChoices() {
        for (T c : this.choicePointValues) {
            this.choices.put(c, this.choicePoints.get(c).getOption(0));
        }
    }

    public ArrayList<ArrayList<Pair<Integer, Integer>>> getChoiceCombinations(int player, GameState gs) {
        Collection<Options> options = this.getApplicableChoicePoints(player, gs);
        int[] reps = new int[options.size() + 1];
        for (int j = 0; j < options.size(); ++j) {
            reps[j] = 1;
            int i = 0;
            for (Options o : options) {
                if (i++ < j) continue;
                int n = j;
                reps[n] = reps[n] * o.numOptions();
            }
        }
        reps[options.size()] = 1;
        int count = 1;
        for (Options o : options) {
            count *= o.numOptions();
        }
        ArrayList<ArrayList<Pair<Integer, Integer>>> combinations = new ArrayList<ArrayList<Pair<Integer, Integer>>>(count);
        for (int i = 0; i < count; ++i) {
            combinations.add(new ArrayList(options.size()));
        }
        int opt = 0;
        for (Options o : options) {
            for (int choi = 0; choi < o.numOptions(); ++choi) {
                for (int k = 0; k < reps[opt + 1]; ++k) {
                    int cycles = count / reps[opt];
                    for (int it = 0; it < cycles; ++it) {
                        combinations.get(it * reps[opt] + choi * reps[opt + 1] + k).add(new Pair<Integer, Integer>(opt, o.getOption(choi)));
                    }
                }
            }
            ++opt;
        }
        return combinations;
    }

    @Override
    public abstract ConfigurableScript<T> clone();

    public abstract Collection<Options> getApplicableChoicePoints(int var1, GameState var2);

    public abstract void initializeChoices();

    class Options {
        int id;
        int[] options;

        public Options(int id, int[] options) {
            this.id = id;
            this.options = options;
        }

        public int numOptions() {
            return this.options.length;
        }

        public int getOption(int o) {
            return this.options[o];
        }

        public Options clone() {
            return new Options(this.id, this.options);
        }

        public String toString() {
            return "(" + this.id + ",[" + this.options + "])";
        }
    }
}

