/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.evaluation.EvaluationFunction;
import ai.puppet.ConfigurableScript;
import rts.GameState;
import rts.PlayerAction;

public abstract class PuppetBase
extends AIWithComputationBudget {
    int PLAN_TIME;
    int PLAN_PLAYOUTS;
    int STEP_PLAYOUT_TIME;
    boolean PLAN;
    EvaluationFunction eval;
    ConfigurableScript<?> script;
    int lastSearchFrame;
    long lastSearchTime;
    int frameLeaves = 0;
    int totalLeaves = 0;
    long frameStartTime = 0L;
    long frameTime = 0L;
    long totalTime = 0L;

    PuppetBase(int max_time_per_frame, int max_playouts_per_frame, int max_plan_time, int max_plan_playouts, int step_playout_time, ConfigurableScript<?> script, EvaluationFunction evaluation) {
        super(max_time_per_frame, max_playouts_per_frame);
        assert (max_time_per_frame >= 0 || max_playouts_per_frame >= 0);
        this.PLAN_TIME = max_plan_time;
        this.PLAN_PLAYOUTS = max_plan_playouts;
        this.STEP_PLAYOUT_TIME = step_playout_time;
        this.PLAN = max_plan_time >= 0 || max_plan_playouts >= 0;
        this.script = script;
        this.eval = evaluation;
        this.lastSearchFrame = -1;
        this.lastSearchTime = -1L;
    }

    @Override
    public void reset() {
        this.lastSearchFrame = -1;
        this.lastSearchTime = -1L;
        this.script.reset();
        this.frameLeaves = 0;
        this.totalLeaves = 0;
        this.frameTime = 0L;
        this.totalTime = 0L;
    }

    boolean planBudgetExpired() {
        return this.PLAN_PLAYOUTS >= 0 && this.totalLeaves >= this.PLAN_PLAYOUTS || this.PLAN_TIME >= 0 && this.totalTime > (long)this.PLAN_TIME;
    }

    boolean frameBudgetExpired() {
        return this.ITERATIONS_BUDGET >= 0 && this.frameLeaves >= this.ITERATIONS_BUDGET || this.TIME_BUDGET >= 0 && this.frameTime > (long)this.TIME_BUDGET;
    }

    abstract void startNewComputation(int var1, GameState var2) throws Exception;

    abstract void computeDuringOneGameFrame() throws Exception;

    abstract PlayerAction getBestActionSoFar() throws Exception;

    static void simulate(GameState gs, AI ai1, AI ai2, int player1, int player2, int time) throws Exception {
        assert (player1 != player2);
        int timeOut = gs.getTime() + time;
        boolean gameover = gs.gameover();
        while (!gameover && gs.getTime() < timeOut) {
            if (gs.isComplete()) {
                gameover = gs.cycle();
                continue;
            }
            gs.issue(ai1.getAction(player1, gs));
            gs.issue(ai2.getAction(player2, gs));
        }
    }

    public int getPlanTimeBudget() {
        return this.PLAN_TIME;
    }

    public void setPlanTimeBudget(int a_ib) {
        this.PLAN_TIME = a_ib;
    }

    public int getPlanIterationsBudget() {
        return this.PLAN_PLAYOUTS;
    }

    public void setPlanIterationsBudget(int a_ib) {
        this.PLAN_PLAYOUTS = a_ib;
    }
}

