/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.puppet.Move;
import java.util.Random;
import rts.GameState;
import util.Pair;

class PuppetGameState {
    GameState gs;
    int hash;
    static final int MAX_DEPTH = 100;
    static final int MAX_CHOICE_POINTS = 10;
    static final int MAX_CHOICES = 10;
    static int[][][][] zobrist = new int[100][2][10][10];

    public PuppetGameState(GameState gs) {
        this.gs = gs.clone();
        Random rng = new Random();
        this.hash = rng.nextInt(Integer.MAX_VALUE);
    }

    public PuppetGameState(PuppetGameState gs) {
        this.gs = gs.gs;
        this.hash = gs.hash;
    }

    public PuppetGameState(PuppetGameState oldState, GameState newState, int depth, Move move1, Move move2) {
        this.gs = newState;
        this.hash = oldState.hash;
        this.hash = this.getHash(depth, move1, move2);
    }

    int getHash(int depth, Move move1, Move move2) {
        int _hash = this.hash;
        for (Pair<Integer, Integer> c : move1.choices) {
            _hash ^= zobrist[depth][0][(Integer)c.m_a][(Integer)c.m_b];
        }
        for (Pair<Integer, Integer> c : move2.choices) {
            _hash ^= zobrist[depth + 1][1][(Integer)c.m_a][(Integer)c.m_b];
        }
        return _hash;
    }

    int getHash(int depth, Move move) {
        int _hash = this.hash;
        for (Pair<Integer, Integer> c : move.choices) {
            _hash ^= zobrist[depth][0][(Integer)c.m_a][(Integer)c.m_b];
        }
        return _hash;
    }

    int getHash() {
        return this.hash;
    }

    static {
        Random rng = new Random();
        for (int depth = 0; depth < 100; ++depth) {
            for (int p = 0; p < 2; ++p) {
                for (int point = 0; point < 10; ++point) {
                    for (int choice = 0; choice < 10; ++choice) {
                        PuppetGameState.zobrist[depth][p][point][choice] = rng.nextInt(Integer.MAX_VALUE);
                    }
                }
            }
        }
    }
}

