/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.core.AI;
import ai.puppet.ConfigurableScript;
import ai.puppet.Move;
import ai.puppet.PuppetBase;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import util.Pair;

public class PuppetMCTSNode {
    GameState gs;
    float C;
    PuppetMCTSNode parent;
    ConfigurableScript<?> script;
    float evaluation_bound;
    List<PuppetMCTSNode> children = new ArrayList<PuppetMCTSNode>();
    Move prevMove;
    int nextPlayerInSimultaneousNode;
    Move[] actions;
    int[] visit_count;
    float[] accum_evaluation;
    int total_visit_count;
    int index;

    public String toString() {
        return this.bestChild() == null ? "" : " time:" + this.gs.getTime() + " " + this.actions[this.bestChild().index].toString(this.script) + ", score: " + this.bestChild().score() + "\n" + this.bestChild().toString();
    }

    float score() {
        assert (this.parent.visit_count[this.index] == this.total_visit_count);
        return this.parent.accum_evaluation[this.index] / (float)this.total_visit_count;
    }

    public PuppetMCTSNode(GameState gs, ConfigurableScript<?> script, float C, int nextPlayerInSimultaneousNode, float bound, PuppetMCTSNode parent, Move prevMove, int index) {
        this.gs = gs;
        this.script = script;
        this.C = C;
        this.nextPlayerInSimultaneousNode = nextPlayerInSimultaneousNode;
        this.evaluation_bound = bound;
        this.parent = parent;
        this.prevMove = prevMove;
        this.index = index;
        this.actions = (Move[])script.getChoiceCombinations(this.toMove(), gs).stream().map(e -> new Move((ArrayList<Pair<Integer, Integer>>)e, this.toMove())).toArray(Move[]::new);
        this.visit_count = new int[this.actions.length];
        this.accum_evaluation = new float[this.actions.length];
        this.total_visit_count = 0;
    }

    public PuppetMCTSNode(GameState gs, ConfigurableScript<?> script, float C, int nextPlayerInSimultaneousNode, float bound) {
        this(gs, script, C, nextPlayerInSimultaneousNode, bound, null, null, -1);
    }

    int toMove() {
        if (this.prevMove == null) {
            return this.nextPlayerInSimultaneousNode;
        }
        return 1 - this.prevMove.player;
    }

    PuppetMCTSNode bestChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        int best = -1;
        int best_visit_count = 0;
        for (int child = 0; child < this.children.size(); ++child) {
            int tmp = this.visit_count[child];
            if (best != -1 && tmp <= best_visit_count) continue;
            best = child;
            best_visit_count = tmp;
        }
        return this.children.get(best);
    }

    PuppetMCTSNode selectLeaf(int STEP_PLAYOUT_TIME) throws Exception {
        if (this.children.size() < this.actions.length) {
            Move m = this.actions[this.children.size()];
            if (this.prevMove == null) {
                PuppetMCTSNode node = new PuppetMCTSNode(this.gs, this.script, this.C, 1 - this.nextPlayerInSimultaneousNode, this.evaluation_bound, this, m, this.children.size());
                this.children.add(node);
                return node.selectLeaf(STEP_PLAYOUT_TIME);
            }
            if (this.gs.gameover()) {
                return this;
            }
            GameState gs2 = this.gs.clone();
            AI sc1 = this.script.clone();
            ((ConfigurableScript)sc1).reset();
            AI sc2 = this.script.clone();
            ((ConfigurableScript)sc2).reset();
            ((ConfigurableScript)sc1).setChoices(this.prevMove.choices);
            ((ConfigurableScript)sc2).setChoices(m.choices);
            PuppetBase.simulate(gs2, sc1, sc2, this.prevMove.player, m.player, STEP_PLAYOUT_TIME);
            PuppetMCTSNode node = new PuppetMCTSNode(gs2, this.script, this.C, this.nextPlayerInSimultaneousNode, this.evaluation_bound, this, null, this.children.size());
            this.children.add(node);
            return node;
        }
        double best_score = 0.0;
        int best = -1;
        for (int child = 0; child < this.children.size(); ++child) {
            double exploitation = (double)this.accum_evaluation[child] / (double)this.visit_count[child];
            double exploration = Math.sqrt(Math.log(this.total_visit_count) / (double)this.visit_count[child]);
            double tmp = (exploitation /= (double)this.evaluation_bound) + (double)this.C * exploration;
            if (best != -1 && !(tmp > best_score)) continue;
            best = child;
            best_score = tmp;
        }
        if (best == -1) {
            return this;
        }
        return this.children.get(best).selectLeaf(STEP_PLAYOUT_TIME);
    }

    void update(float ev, int player) {
        ++this.total_visit_count;
        if (this.parent != null) {
            int n = this.index;
            this.parent.accum_evaluation[n] = this.parent.accum_evaluation[n] + (this.player() == player ? ev : -ev);
            int n2 = this.index;
            this.parent.visit_count[n2] = this.parent.visit_count[n2] + 1;
            this.parent.update(ev, player);
        }
    }

    int player() {
        return this.parent != null ? this.parent.actions[this.index].player : -1;
    }
}

