/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.PuppetBase;
import ai.puppet.PuppetSearchAB;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PuppetNoPlan
extends AIWithComputationBudget
implements InterruptibleAI {
    PuppetBase puppet;

    public PuppetNoPlan(UnitTypeTable utt) {
        this(new PuppetSearchAB(100, -1, -1, -1, 100, new BasicConfigurableScript(utt, new FloodFillPathFinding()), new SimpleSqrtEvaluationFunction3()));
    }

    public PuppetNoPlan(PuppetBase puppet) {
        super(puppet.getTimeBudget(), puppet.getIterationsBudget());
        this.puppet = puppet;
    }

    @Override
    public final PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void setTimeBudget(int a_tb) {
        this.puppet.setTimeBudget(a_tb);
    }

    @Override
    public int getTimeBudget() {
        return this.puppet.getTimeBudget();
    }

    @Override
    public int getIterationsBudget() {
        return this.puppet.getIterationsBudget();
    }

    @Override
    public void setIterationsBudget(int a_ib) {
        this.puppet.setIterationsBudget(a_ib);
    }

    @Override
    public void startNewComputation(int player, GameState gs) throws Exception {
        this.puppet.startNewComputation(player, gs);
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        this.puppet.computeDuringOneGameFrame();
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        return this.puppet.getBestActionSoFar();
    }

    @Override
    public void reset() {
        this.puppet.reset();
    }

    @Override
    public AI clone() {
        PuppetNoPlan clone = new PuppetNoPlan((PuppetBase)this.puppet.clone());
        return clone;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.puppet.toString() + ")";
    }

    @Override
    public String statisticsString() {
        return this.puppet.statisticsString();
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return this.puppet.getParameters();
    }
}

