/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.CacheEntry;
import ai.puppet.CacheTable;
import ai.puppet.ConfigurableScript;
import ai.puppet.Entry;
import ai.puppet.Move;
import ai.puppet.MoveGenerator;
import ai.puppet.PuppetBase;
import ai.puppet.PuppetGameState;
import ai.puppet.TranspositionTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.Pair;

public class PuppetSearchAB
extends PuppetBase {
    protected int DEBUG = 0;
    protected int DEPTH;
    protected int MAXPLAYER = -1;
    Stack<ABCDNode> stack = new Stack();
    ABCDNode head;
    ABCDNode lastFinishedHead;
    Plan currentPlan;
    TranspositionTable TT = new TranspositionTable(100000);
    CacheTable CT = new CacheTable(100000);
    long allLeaves;
    long allTime;
    long allDepth;
    long allSearches;
    int ttHits = 0;
    int ttQueries = 0;
    int ctHits = 0;
    int ctQueries = 0;
    boolean tt = true;
    boolean ct = true;
    boolean reached;

    public PuppetSearchAB(UnitTypeTable utt) {
        this(100, -1, 5000, -1, 100, new BasicConfigurableScript(utt, new FloodFillPathFinding()), new SimpleSqrtEvaluationFunction3());
    }

    public PuppetSearchAB(int max_time_per_frame, int max_playouts_per_frame, int max_plan_time, int max_plan_playouts, int playout_time, ConfigurableScript<?> script, EvaluationFunction evaluation) {
        super(max_time_per_frame, max_playouts_per_frame, max_plan_time, max_plan_playouts, playout_time, script, evaluation);
        this.currentPlan = new Plan();
    }

    @Override
    public void reset() {
        super.reset();
        this.currentPlan = new Plan();
        this.stack.clear();
        this.head = null;
        this.lastFinishedHead = null;
        this.DEPTH = 0;
        this.clearStats();
    }

    @Override
    public AI clone() {
        PuppetSearchAB ps = new PuppetSearchAB(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAN_TIME, this.PLAN_PLAYOUTS, this.STEP_PLAYOUT_TIME, (ConfigurableScript<?>)this.script.clone(), this.eval);
        ps.currentPlan = this.currentPlan;
        ps.lastSearchFrame = this.lastSearchFrame;
        ps.lastSearchTime = this.lastSearchTime;
        return ps;
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        assert (this.PLAN) : "This method can only be called when using a standing plan";
        if (this.lastSearchFrame == -1 || this.stack.empty()) {
            if (this.DEBUG >= 1) {
                System.out.println("Restarting after " + (gs.getTime() - this.lastSearchFrame) + " frames, " + (System.currentTimeMillis() - this.lastSearchTime) + " ms");
            }
            this.startNewComputation(player, gs);
        }
        if (this.DEBUG >= 2) {
            System.out.println("Starting ABCD at frame " + gs.getTime() + ", player " + player + " with " + this.TIME_BUDGET + " ms");
        }
        if (!this.stack.empty()) {
            this.computeDuringOneGameFrame();
        }
        if (gs.canExecuteAnyAction(player) && gs.winner() == -1) {
            if (this.DEBUG >= 2) {
                System.out.println("Issuing move using choices: " + this.currentPlan.getChoices());
            }
            this.currentPlan.update(gs);
            this.script.setDefaultChoices();
            this.script.setChoices(this.currentPlan.getChoices());
            PlayerAction pa = this.script.getAction(player, gs);
            return pa;
        }
        return new PlayerAction();
    }

    @Override
    public String statisticsString() {
        return "Average Number of Leaves: " + this.allLeaves / this.allSearches + ", Average Depth: " + this.allDepth / this.allSearches + ", Average Time: " + this.allTime / this.allSearches;
    }

    void clearStats() {
        this.allDepth = 0L;
        this.allLeaves = 0L;
        this.allTime = 0L;
        this.allSearches = -1L;
    }

    @Override
    public void startNewComputation(int player, GameState gs) {
        this.MAXPLAYER = player;
        this.lastSearchFrame = gs.getTime();
        this.lastSearchTime = System.currentTimeMillis();
        this.stack.clear();
        this.stack.push(new ABCDNode(new PuppetGameState(gs.clone()), null, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, 0, this.MAXPLAYER, null));
        this.head = this.stack.peek();
        this.allLeaves += (long)this.totalLeaves;
        this.allTime += this.totalTime;
        this.allDepth += (long)this.DEPTH;
        ++this.allSearches;
        this.totalLeaves = 0;
        this.totalTime = 0L;
        this.DEPTH = 0;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        assert (!this.PLAN) : "This method can only be called when not using a standing plan";
        if (this.DEBUG >= 1) {
            System.out.println("ABCD:\n" + this.currentPlan + " in " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, leaves: " + this.totalLeaves);
        }
        this.script.setDefaultChoices();
        this.script.setChoices(this.currentPlan.getChoices());
        return this.script.getAction(this.MAXPLAYER, this.head.gs.gs);
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long prev = this.frameStartTime = System.currentTimeMillis();
        this.frameLeaves = 0;
        do {
            if (this.DEPTH == 0) {
                this.DEPTH += 2;
                this.reached = false;
            } else if (this.stack.empty()) {
                if (!this.reached) break;
                this.lastFinishedHead = this.head;
                if (this.DEBUG >= 2) {
                    System.out.println("ABCD:\n" + this.lastFinishedHead + " in " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, leaves: " + this.totalLeaves + ", depth: " + this.DEPTH);
                }
                this.DEPTH += 2;
                this.stack.push(new ABCDNode(new PuppetGameState(this.head.gs), null, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, 0, this.MAXPLAYER, null));
                this.head = this.stack.peek();
                this.reached = false;
            }
            this.iterativeABCD(this.DEPTH);
            if (this.stack.empty()) {
                this.lastFinishedHead = this.head;
            }
            long next = System.currentTimeMillis();
            this.totalTime += next - prev;
            prev = next;
            this.frameTime = prev - this.frameStartTime;
        } while (!this.frameBudgetExpired() && !this.searchDone());
        if (!this.PLAN) {
            this.currentPlan = new Plan(this.lastFinishedHead);
        }
        if (this.searchDone()) {
            if (this.DEBUG >= 1) {
                System.out.println(this.ttHits + "/" + this.ttQueries + " TT, " + this.ctHits + "/" + this.ctQueries + " CT");
            }
            this.stack.clear();
            this.currentPlan = new Plan(this.lastFinishedHead);
            if (this.DEBUG >= 1) {
                System.out.println("ABCD:\n" + this.currentPlan + " in " + this.totalTime + " ms, wall time: " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, leaves: " + this.totalLeaves);
            }
        }
    }

    boolean searchDone() {
        return this.PLAN && this.planBudgetExpired();
    }

    protected void iterativeABCD(int maxDepth) throws Exception {
        assert (maxDepth % 2 == 0);
        if (this.DEBUG >= 2) {
            System.out.println("ABCD at " + this.head.gs.gs.getTime());
        }
        while (!(this.stack.isEmpty() || this.frameBudgetExpired() || this.searchDone())) {
            Entry ttEntry;
            ABCDNode parent;
            if (this.DEBUG >= 2) {
                System.out.println(this.stack);
            }
            ABCDNode current = this.stack.peek();
            if (current.prevMove == null) {
                if (current.depth == maxDepth || current.gs.gs.gameover()) {
                    if (this.DEBUG >= 2) {
                        System.out.println("eval");
                    }
                    if (current.depth == maxDepth) {
                        this.reached = true;
                    }
                    ++this.frameLeaves;
                    ++this.totalLeaves;
                    this.stack.pop();
                    parent = this.stack.peek();
                    Result result = new Result(parent.nextMoves.last(), this.eval.evaluate(this.MAXPLAYER, 1 - this.MAXPLAYER, current.gs.gs));
                    parent.setResult(result, current);
                } else if (current.nextMoves.hasNext()) {
                    if (this.tt && current.nextMoves.current == 0) {
                        ttEntry = this.TT.lookup(current.gs);
                        ++this.ttQueries;
                        if (ttEntry != null) {
                            current.nextMoves.swapFront(ttEntry._bestMove);
                            ++this.ttHits;
                        }
                    }
                    if (this.DEBUG >= 2) {
                        System.out.println("current.nextMoves.hasNext()");
                    }
                    this.stack.push(new ABCDNode(current.gs, current.nextMoves.next(), current.alpha, current.beta, current.depth + 1, 1 - current.nextPlayerInSimultaneousNode, null));
                } else {
                    this.stack.pop();
                    if (!this.stack.empty()) {
                        parent = this.stack.peek();
                        parent.setResult(new Result(parent.nextMoves.last(), current.best.score), current);
                    }
                    if (this.tt) {
                        this.TT.store(current.gs, current.best.m, current.best.score, current.alpha, current.beta, maxDepth - current.depth);
                    }
                }
            } else if (current.nextMoves.hasNext()) {
                if (this.tt && current.nextMoves.current == 0) {
                    ttEntry = this.TT.lookup(current.gs, current.depth, current.prevMove);
                    ++this.ttQueries;
                    if (ttEntry != null) {
                        current.nextMoves.swapFront(ttEntry._bestMove);
                        ++this.ttHits;
                    }
                }
                Move next = current.nextMoves.next();
                PuppetGameState gs2 = null;
                if (this.ct) {
                    CacheEntry ctEntry = this.CT.lookup(current.gs, current.depth - 1, current.prevMove, next);
                    ++this.ctQueries;
                    if (ctEntry != null) {
                        gs2 = ctEntry._state;
                        ++this.ctHits;
                    }
                }
                if (gs2 == null) {
                    GameState gsTemp = current.gs.gs.clone();
                    AI sc1 = this.script.clone();
                    ((ConfigurableScript)sc1).reset();
                    AI sc2 = this.script.clone();
                    ((ConfigurableScript)sc2).reset();
                    ((ConfigurableScript)sc1).setChoices(current.prevMove.choices);
                    ((ConfigurableScript)sc2).setChoices(next.choices);
                    PuppetSearchAB.simulate(gsTemp, sc1, sc2, current.prevMove.player, next.player, this.STEP_PLAYOUT_TIME);
                    gs2 = new PuppetGameState(current.gs, gsTemp, current.depth - 1, current.prevMove, next);
                    if (this.ct) {
                        this.CT.store(current.gs, gs2);
                    }
                }
                this.stack.push(new ABCDNode(gs2, null, current.alpha, current.beta, current.depth + 1, current.nextPlayerInSimultaneousNode, null));
            } else {
                this.stack.pop();
                parent = this.stack.peek();
                parent.setResult(new Result(parent.nextMoves.last(), current.best.score), current);
                if (this.tt) {
                    this.TT.store(current.gs, current.depth, current.prevMove, current.best.m, current.best.score, current.alpha, current.beta, maxDepth - current.depth);
                }
            }
            this.frameTime = System.currentTimeMillis() - this.frameStartTime;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.PLAN_TIME + ", " + this.PLAN_PLAYOUTS + ", " + this.STEP_PLAYOUT_TIME + ", " + this.script + ", " + this.eval + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlanTimeBudget", Integer.TYPE, 5000));
        parameters.add(new ParameterSpecification("PlanIterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("StepPlayoutTime", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getStepPlayoutTime() {
        return this.STEP_PLAYOUT_TIME;
    }

    public void setStepPlayoutTime(int a_ib) {
        this.STEP_PLAYOUT_TIME = a_ib;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.eval;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.eval = a_ef;
    }

    class Plan {
        ABCDNode node;

        Plan(ABCDNode node) {
            this.node = node;
        }

        Plan() {
            this.node = null;
        }

        void update(GameState gs) {
            while (!(this.node == null || gs.getTime() - this.node.gs.gs.getTime() <= PuppetSearchAB.this.STEP_PLAYOUT_TIME && this.node.isMaxPlayer())) {
                this.node = this.node.following;
            }
        }

        Collection<Pair<Integer, Integer>> getChoices() {
            if (this.valid()) {
                return this.node.best.m.choices;
            }
            return Collections.emptyList();
        }

        boolean valid() {
            return this.node != null && this.node.best != null;
        }

        public String toString() {
            return this.node != null ? this.node.toString() : "";
        }
    }

    class ABCDNode {
        PuppetGameState gs;
        Move prevMove;
        float alpha;
        float beta;
        int depth;
        int nextPlayerInSimultaneousNode;
        MoveGenerator nextMoves;
        Result best;
        ABCDNode following;

        public ABCDNode(PuppetGameState gs, Move prevMove, float alpha, float beta, int depth, int nextPlayerInSimultaneousNode, Result best) {
            this.gs = gs;
            this.prevMove = prevMove;
            this.alpha = alpha;
            this.beta = beta;
            this.depth = depth;
            this.nextPlayerInSimultaneousNode = nextPlayerInSimultaneousNode;
            this.best = best;
            this.nextMoves = new MoveGenerator(PuppetSearchAB.this.script.getChoiceCombinations(this.toMove(), gs.gs), this.toMove());
            this.following = null;
        }

        int toMove() {
            if (this.prevMove == null) {
                return this.nextPlayerInSimultaneousNode;
            }
            return 1 - this.prevMove.player;
        }

        boolean isMaxPlayer() {
            return this.toMove() == PuppetSearchAB.this.MAXPLAYER;
        }

        void setResult(Result result, ABCDNode node) {
            if (this.best == null) {
                this.best = result;
                this.following = node;
            } else if (this.isMaxPlayer()) {
                this.alpha = Math.max(this.alpha, this.best.score);
                if (result.score > this.best.score) {
                    this.best = result;
                    this.following = node;
                }
            } else if (!this.isMaxPlayer()) {
                this.beta = Math.min(this.beta, this.best.score);
                if (result.score < this.best.score) {
                    this.best = result;
                    this.following = node;
                }
            }
            if (this.alpha >= this.beta) {
                this.nextMoves.ABcut();
            }
        }

        public String toString() {
            return " time:" + this.gs.gs.getTime() + " " + this.best + "\n" + (this.following != null ? this.following.toString() : "");
        }
    }

    class Result {
        Move m;
        float score;

        public Result(Move m, float score) {
            this.m = m;
            this.score = score;
        }

        public String toString() {
            return this.m.toString(PuppetSearchAB.this.script) + ", score: " + this.score;
        }
    }
}

