/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.RandomBiasedAI;
import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.ConfigurableScript;
import ai.puppet.PuppetBase;
import ai.puppet.PuppetMCTSNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.Pair;

public class PuppetSearchMCTS
extends PuppetBase {
    int DEBUG = 0;
    int EVAL_PLAYOUT_TIME;
    AI policy1;
    AI policy2;
    PuppetMCTSNode root;
    Plan currentPlan;
    float C;
    long allLeaves;
    long allTime;
    long allSearches;

    public PuppetSearchMCTS(UnitTypeTable utt) {
        this(100, -1, 5000, -1, 100, 100, new RandomBiasedAI(), new BasicConfigurableScript(utt, new FloodFillPathFinding()), new SimpleSqrtEvaluationFunction3());
    }

    public PuppetSearchMCTS(int max_time_per_frame, int max_playouts_per_frame, int max_plan_time, int max_plan_playouts, int step_playout_time, int eval_playout_time, AI policy, ConfigurableScript<?> script, EvaluationFunction evaluation) {
        super(max_time_per_frame, max_playouts_per_frame, max_plan_time, max_plan_playouts, step_playout_time, script, evaluation);
        this.EVAL_PLAYOUT_TIME = eval_playout_time;
        this.policy1 = policy.clone();
        this.policy2 = policy.clone();
        this.currentPlan = new Plan();
        this.root = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.policy1.reset();
        this.policy2.reset();
        this.currentPlan = new Plan();
        this.root = null;
        this.clearStats();
    }

    @Override
    public String statisticsString() {
        return "Average Number of Leaves: " + (this.allSearches > 0L ? Long.valueOf(this.allLeaves / this.allSearches) : "-") + ", Average Time: " + (this.allSearches > 0L ? Long.valueOf(this.allTime / this.allSearches) : "-");
    }

    void clearStats() {
        this.allLeaves = 0L;
        this.allTime = 0L;
        this.allSearches = -1L;
    }

    @Override
    public AI clone() {
        PuppetSearchMCTS clone = new PuppetSearchMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAN_TIME, this.PLAN_PLAYOUTS, this.STEP_PLAYOUT_TIME, this.EVAL_PLAYOUT_TIME, this.policy1.clone(), (ConfigurableScript<?>)this.script.clone(), this.eval);
        clone.currentPlan = this.currentPlan;
        clone.lastSearchFrame = this.lastSearchFrame;
        clone.lastSearchTime = this.lastSearchTime;
        return clone;
    }

    private void setC(GameState gs) {
        this.C = gs.getPhysicalGameState().getWidth() <= 8 ? 1.0f : (gs.getPhysicalGameState().getWidth() <= 16 ? 10.0f : 0.1f);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        assert (this.PLAN) : "This method can only be called when using a standing plan";
        this.setC(gs);
        if (this.lastSearchFrame == -1 || this.root == null) {
            if (this.DEBUG >= 1) {
                System.out.println("Restarting after " + (gs.getTime() - this.lastSearchFrame) + " frames, " + (System.currentTimeMillis() - this.lastSearchTime) + " ms (" + this.totalTime + " ms)");
            }
            this.startNewComputation(player, gs);
        }
        if (this.DEBUG >= 3) {
            System.out.println("Starting MCTS at frame " + gs.getTime() + ", player " + player + " with " + this.TIME_BUDGET + " ms");
        }
        if (this.root != null) {
            this.computeDuringOneGameFrame();
        }
        if (gs.canExecuteAnyAction(player) && gs.winner() == -1) {
            this.currentPlan.update(gs, player);
            if (this.DEBUG >= 2) {
                System.out.println("Issuing move using choices: " + this.currentPlan.getChoices());
            }
            this.script.setDefaultChoices();
            this.script.setChoices(this.currentPlan.getChoices());
            PlayerAction pa = this.script.getAction(player, gs);
            return pa;
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int player, GameState gs) {
        this.setC(gs);
        this.lastSearchFrame = gs.getTime();
        this.lastSearchTime = System.currentTimeMillis();
        this.root = new PuppetMCTSNode(gs.clone(), this.script, this.C, player, this.eval.upperBound(gs));
        this.allLeaves += (long)this.totalLeaves;
        this.allTime += this.totalTime;
        ++this.allSearches;
        this.totalLeaves = 0;
        this.totalTime = 0L;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        assert (!this.PLAN) : "This method can only be called when not using s standing plan";
        if (this.DEBUG >= 1) {
            System.out.println("Done. Moves:\n" + this.root + " in " + this.totalTime + " ms, wall time: " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, playouts: " + this.totalLeaves);
        }
        this.script.setDefaultChoices();
        this.script.setChoices(this.root.actions[this.root.bestChild().index].choices);
        return this.script.getAction(this.root.nextPlayerInSimultaneousNode, this.root.gs);
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long prev = this.frameStartTime = System.currentTimeMillis();
        this.frameLeaves = 0;
        if (this.DEBUG >= 2) {
            System.out.println("Search...");
        }
        do {
            this.monteCarloRun();
            long next = System.currentTimeMillis();
            this.totalTime += next - prev;
            prev = next;
            this.frameTime = next - this.frameStartTime;
        } while (!this.frameBudgetExpired() && !this.searchDone());
        if (this.searchDone()) {
            this.currentPlan = new Plan(this.root);
            this.root = null;
            if (this.DEBUG >= 1) {
                System.out.println("Done. Updating Plan:\n" + this.currentPlan + " in " + this.totalTime + " ms, wall time: " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, playouts: " + this.totalLeaves);
            }
        }
    }

    void monteCarloRun() throws Exception {
        float e;
        PuppetMCTSNode leaf = this.root.selectLeaf(this.STEP_PLAYOUT_TIME);
        if (!leaf.gs.gameover()) {
            ++this.frameLeaves;
            ++this.totalLeaves;
            this.policy1.reset();
            this.policy2.reset();
            GameState gs2 = leaf.gs.clone();
            PuppetSearchMCTS.simulate(gs2, this.policy1, this.policy2, leaf.parent.player(), leaf.player(), this.EVAL_PLAYOUT_TIME);
            e = this.eval.evaluate(leaf.player(), 1 - leaf.player(), gs2);
        } else {
            e = this.eval.evaluate(leaf.player(), 1 - leaf.player(), leaf.gs);
        }
        leaf.update(e, leaf.player());
    }

    boolean searchDone() {
        return this.PLAN && this.planBudgetExpired();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.PLAN_TIME + ", " + this.PLAN_PLAYOUTS + ", " + this.STEP_PLAYOUT_TIME + ", " + this.EVAL_PLAYOUT_TIME + ", " + this.policy1 + ", " + this.script + ", " + this.eval + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlanTimeBudget", Integer.TYPE, 5000));
        parameters.add(new ParameterSpecification("PlanIterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("StepPlayoutTime", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("EvalPlayoutTime", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("Policy", AI.class, this.policy1));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public int getStepPlayoutTime() {
        return this.STEP_PLAYOUT_TIME;
    }

    public void setStepPlayoutTime(int a_ib) {
        this.STEP_PLAYOUT_TIME = a_ib;
    }

    public int getEvalPlayoutTime() {
        return this.EVAL_PLAYOUT_TIME;
    }

    public void setEvalPlayoutTime(int a_ib) {
        this.EVAL_PLAYOUT_TIME = a_ib;
    }

    public AI getPolicy() {
        return this.policy1;
    }

    public void setPolicy(AI a) throws Exception {
        this.policy1 = a.clone();
        this.policy2 = a.clone();
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.eval;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.eval = a_ef;
    }

    class Plan {
        PuppetMCTSNode node;

        Plan() {
            this.node = null;
        }

        Plan(PuppetMCTSNode root) {
            this.node = root;
        }

        void update(GameState gs, int player) {
            while (this.valid() && (gs.getTime() - this.node.gs.getTime() > PuppetSearchMCTS.this.STEP_PLAYOUT_TIME || this.node.bestChild().player() != player)) {
                this.node = this.node.bestChild();
            }
        }

        Collection<Pair<Integer, Integer>> getChoices() {
            if (this.valid()) {
                return this.node.actions[this.node.bestChild().index].choices;
            }
            return Collections.emptyList();
        }

        boolean valid() {
            return this.node != null && this.node.bestChild() != null;
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

