/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.puppet.ConfigurableScript;
import ai.puppet.SingleChoice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;

public class SingleChoiceConfigurableScript
extends ConfigurableScript<SingleChoice> {
    AI[] scripts;

    public SingleChoiceConfigurableScript(PathFinding a_pf, AI[] scripts) {
        super(a_pf);
        this.scripts = scripts;
        this.choicePoints = new EnumMap(SingleChoice.class);
        this.choices = new EnumMap(SingleChoice.class);
        this.choicePointValues = SingleChoice.values();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        for (AI sc : this.scripts) {
            sc.reset();
        }
    }

    @Override
    public Collection<ConfigurableScript.Options> getApplicableChoicePoints(int player, GameState gs) {
        return this.getAllChoicePoints();
    }

    @Override
    public void initializeChoices() {
        int[] opts = new int[this.scripts.length];
        for (int i = 0; i < this.scripts.length; ++i) {
            opts[i] = i;
        }
        for (SingleChoice c : (SingleChoice[])this.choicePointValues) {
            if (c != SingleChoice.SINGLE) continue;
            this.choicePoints.put(c, new ConfigurableScript.Options(c.ordinal(), opts));
        }
    }

    @Override
    public ConfigurableScript<SingleChoice> clone() {
        AI[] scripts2 = new AI[this.scripts.length];
        for (int i = 0; i < this.scripts.length; ++i) {
            scripts2[i] = this.scripts[i].clone();
        }
        SingleChoiceConfigurableScript sc = new SingleChoiceConfigurableScript(this.pf, scripts2);
        sc.choices = this.choices.clone();
        sc.choicePoints = this.choicePoints.clone();
        sc.choicePointValues = (Enum[])((SingleChoice[])this.choicePointValues).clone();
        return sc;
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        return this.scripts[(Integer)this.choices.get((Object)SingleChoice.SINGLE)].getAction(player, gs);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("SingleChoicePoint(");
        for (AI ai : this.scripts) {
            str.append(ai.toString()).append(",");
        }
        return str + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new FloodFillPathFinding()));
        parameters.add(new ParameterSpecification("Scripts", AI[].class, this.scripts));
        return parameters;
    }
}

