/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.puppet.Entry;
import ai.puppet.Move;
import ai.puppet.PuppetGameState;

class TranspositionTable {
    Entry[] _entries;

    TranspositionTable(int size) {
        this._entries = new Entry[size];
        for (int i = 0; i < size; ++i) {
            this._entries[i] = new Entry();
        }
    }

    void store(PuppetGameState origState, Move bestMove, float value, float alpha, float beta, int height) {
        boolean upper;
        boolean exact;
        if (value <= alpha) {
            exact = false;
            upper = true;
        } else if (value >= beta) {
            exact = false;
            upper = false;
        } else {
            exact = true;
            upper = false;
        }
        int pos = origState.getHash() % this._entries.length;
        this._entries[pos]._bestMove = bestMove;
        this._entries[pos]._hash = origState.getHash();
        this._entries[pos]._value = value;
        this._entries[pos]._height = height;
        this._entries[pos]._exact = exact;
        this._entries[pos]._upper = upper;
    }

    void store(PuppetGameState origState, int depth, Move move, Move bestMove, float value, float alpha, float beta, int height) {
        boolean upper;
        boolean exact;
        if (value <= alpha) {
            exact = false;
            upper = true;
        } else if (value >= beta) {
            exact = false;
            upper = false;
        } else {
            exact = true;
            upper = false;
        }
        int pos = origState.getHash(depth, move) % this._entries.length;
        this._entries[pos]._bestMove = bestMove;
        this._entries[pos]._hash = origState.getHash(depth, move);
        this._entries[pos]._value = value;
        this._entries[pos]._height = height;
        this._entries[pos]._exact = exact;
        this._entries[pos]._upper = upper;
    }

    Entry lookup(PuppetGameState state, int depth, Move move) {
        int hash = state.getHash(depth, move);
        Entry entry = this._entries[hash % this._entries.length];
        if (entry._hash == hash) {
            return entry;
        }
        return null;
    }

    Entry lookup(PuppetGameState state) {
        Entry entry = this._entries[state.getHash() % this._entries.length];
        if (entry._hash == state.getHash()) {
            return entry;
        }
        return null;
    }
}

