/*
 * Decompiled with CFR 0.152.
 */
package ai.scv;

import ai.RandomBiasedAI;
import ai.abstraction.EconomyMilitaryRush;
import ai.abstraction.EconomyRush;
import ai.abstraction.HeavyDefense;
import ai.abstraction.LightDefense;
import ai.abstraction.LightRush;
import ai.abstraction.RangedDefense;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerDefense;
import ai.abstraction.WorkerRush;
import ai.abstraction.WorkerRushPlusPlus;
import ai.abstraction.partialobservability.POHeavyRush;
import ai.abstraction.partialobservability.POLightRush;
import ai.abstraction.partialobservability.PORangedRush;
import ai.abstraction.partialobservability.POWorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import weka.classifiers.functions.SimpleLogistic;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.SerializationHelper;
import weka.core.converters.ConverterUtils;

public class SCV
extends AIWithComputationBudget {
    AI[] strategies;
    int playerForThisComputation;
    GameState gs_to_start_from;
    SimpleLogistic rf;
    UnitTypeTable localUtt;
    Instances dataSet;
    long tempoInicial;
    HashMap<String, HashMap<Integer, List<infBattles>>> indice;
    int heightMap;

    public SCV(UnitTypeTable utt) {
        this(new AI[]{new WorkerRush(utt), new LightRush(utt), new RangedRush(utt), new RandomBiasedAI()}, 100, -1, utt);
    }

    public SCV(AI[] s, int time, int max_playouts, UnitTypeTable utt) {
        super(time, max_playouts);
        this.strategies = s;
        this.localUtt = utt;
        this.indice = new HashMap();
    }

    @Override
    public void reset() {
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        this.tempoInicial = System.currentTimeMillis();
        if (this.rf == null) {
            this.heightMap = gs.getPhysicalGameState().getHeight();
            this.loadModel();
            this.loadLtd3Battles();
        }
        this.tryClassify(player, gs);
        if (gs.canExecuteAnyAction(player)) {
            this.startNewComputation(player, gs);
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    protected void loadLtd3Battles() {
        ArrayList<infBattles> infTemp = new ArrayList<infBattles>();
        try {
            BufferedReader learArq;
            switch (this.heightMap) {
                case 8: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais8.csv")));
                    break;
                }
                case 9: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais9.csv")));
                    break;
                }
                case 16: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais16.csv")));
                    break;
                }
                case 24: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais24.csv")));
                    break;
                }
                case 32: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais32.csv")));
                    break;
                }
                case 64: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinais64.csv")));
                    break;
                }
                default: {
                    learArq = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("models/ltdsFinaisSCV.csv")));
                }
            }
            String linha = learArq.readLine();
            while (linha != null) {
                infBattles bat = new infBattles();
                String[] itens = linha.split(";");
                bat.ltd3 = Double.parseDouble(itens[0]);
                bat.tMapa = Integer.decode(itens[1]);
                bat.enemy = itens[2];
                bat.strategy = itens[3];
                infTemp.add(bat);
                linha = learArq.readLine();
            }
            learArq.close();
        }
        catch (Exception e) {
            System.err.printf("Erro na abertura do arquivo: %s.\n", e.getMessage());
            System.out.println(e.toString());
        }
        this.buildIndice(infTemp);
    }

    protected void buildIndice(ArrayList<infBattles> infTemp) {
        int cont = 0;
        for (infBattles bat : infTemp) {
            ArrayList<infBattles> infT;
            HashMap<Object, Object> batTemp;
            ++cont;
            if (this.indice.containsKey(bat.strategy)) {
                batTemp = this.indice.get(bat.strategy);
                if (!batTemp.containsKey(bat.tMapa)) {
                    infT = new ArrayList();
                    infT.add(bat);
                    batTemp.put(bat.tMapa, infT);
                    continue;
                }
                ((List)batTemp.get(bat.tMapa)).add(bat);
                continue;
            }
            batTemp = new HashMap();
            infT = new ArrayList<infBattles>();
            infT.add(bat);
            batTemp.put(bat.tMapa, infT);
            this.indice.put(bat.strategy, batTemp);
        }
    }

    public void startNewComputation(int a_player, GameState gs) {
        this.playerForThisComputation = a_player;
        this.gs_to_start_from = gs;
    }

    public PlayerAction getBestActionSoFar() throws Exception {
        int slength = this.strategies.length;
        PlayerAction[] pa = new PlayerAction[slength];
        ArrayList<TreeMap> s = new ArrayList<TreeMap>();
        for (int i = 0; i < slength; ++i) {
            pa[i] = this.strategies[i].getAction(this.playerForThisComputation, this.gs_to_start_from);
        }
        PlayerAction pAux = pa[0];
        for (PlayerAction p : pa) {
            TreeMap sAux = new TreeMap();
            p.getActions().forEach(u -> sAux.put(((Unit)u.m_a).getID(), u.m_b));
            s.add(sAux);
        }
        PlayerAction resultado = new PlayerAction();
        ArrayList vote = new ArrayList();
        TreeMap contagem = new TreeMap(new Comparator<UnitAction>(){

            @Override
            public int compare(UnitAction u1, UnitAction u2) {
                if (u1.equals(u2)) {
                    return 0;
                }
                return 1;
            }
        });
        while (!((TreeMap)s.get(0)).isEmpty()) {
            s.forEach(ua -> vote.add(ua.get(ua.firstKey())));
            Unit uAux = null;
            for (Pair pair : pAux.getActions()) {
                if (((Unit)pair.m_a).getID() != ((Long)((TreeMap)s.get(0)).firstKey()).longValue()) continue;
                uAux = (Unit)pair.m_a;
            }
            s.forEach(ua -> ua.remove(ua.firstKey()));
            vote.stream().map(valor -> {
                if (!contagem.containsKey(valor)) {
                    contagem.put((UnitAction)valor, 0);
                }
                return valor;
            }).forEachOrdered(valor -> contagem.put((UnitAction)valor, (Integer)contagem.get(valor) + 1));
            vote.clear();
            Iterator iterator = contagem.entrySet().iterator();
            Map.Entry entry = iterator.next();
            Integer maior = (Integer)entry.getValue();
            UnitAction action = entry.getKey();
            iterator.remove();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                Integer aux = (Integer)entry2.getValue();
                if (aux > maior) {
                    action = entry2.getKey();
                    maior = aux;
                }
                iterator.remove();
            }
            resultado.addUnitAction(uAux, action);
        }
        return resultado;
    }

    @Override
    public AI clone() {
        return new SCV(this.strategies, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.localUtt);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        return parameters;
    }

    protected void loadModel() {
        this.dataSet = null;
        try {
            switch (this.heightMap) {
                case 8: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV8.model"));
                    break;
                }
                case 9: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV9.model"));
                    break;
                }
                case 16: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV16.model"));
                    break;
                }
                case 24: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV24.model"));
                    break;
                }
                case 32: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV32.model"));
                    break;
                }
                case 64: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV64.model"));
                    break;
                }
                default: {
                    this.rf = (SimpleLogistic)SerializationHelper.read(this.getClass().getResourceAsStream("models/SimpleLogisticSCV.model"));
                }
            }
            ConverterUtils.DataSource source = new ConverterUtils.DataSource(this.getClass().getResourceAsStream("models/dadosEnemyDistModelTemplateSCV.arff"));
            this.dataSet = source.getDataSet();
            this.dataSet.setClassIndex(this.dataSet.numAttributes() - 1);
            DenseInstance avai = new DenseInstance(10);
            avai.setDataset(this.dataSet);
            avai.setValue(0, 0.0);
            avai.setValue(1, 0.0);
            avai.setValue(2, 0.0);
            avai.setValue(3, 0.0);
            avai.setValue(4, 0.0);
            avai.setValue(5, 0.0);
            avai.setValue(6, 0.0);
            avai.setValue(7, 8.0);
            avai.setValue(8, -1.0);
            double d = this.rf.classifyInstance(avai);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SCV.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Erro " + ex);
        }
        catch (Exception ex) {
            Logger.getLogger(SCV.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Erro " + ex);
        }
    }

    protected void tryClassify(int player, GameState gs) {
        int playerEnemy = 0;
        if (player == 0) {
            playerEnemy = 1;
        }
        if (gs.getTime() % 1000 == 0 && gs.getTime() != 0) {
            this.recordInfo(playerEnemy, player, gs, gs.getTime());
        } else if (gs.getTime() == 0) {
            PhysicalGameState pgs = gs.getPhysicalGameState();
            this.strategies = pgs.getHeight() == 8 ? new AI[]{new WorkerRushPlusPlus(this.localUtt), new WorkerDefense(this.localUtt)} : (pgs.getHeight() == 16 ? new AI[]{new WorkerRushPlusPlus(this.localUtt)} : (pgs.getHeight() == 24 ? new AI[]{new WorkerRushPlusPlus(this.localUtt), new WorkerDefense(this.localUtt), new LightDefense(this.localUtt)} : (pgs.getHeight() == 32 ? new AI[]{new POLightRush(this.localUtt), new WorkerDefense(this.localUtt), new EconomyMilitaryRush(this.localUtt)} : (pgs.getHeight() == 64 ? new AI[]{new POLightRush(this.localUtt), new EconomyMilitaryRush(this.localUtt), new WorkerDefense(this.localUtt)} : new AI[]{new EconomyMilitaryRush(this.localUtt)}))));
        }
    }

    private void recordInfo(int playerEnemy, int player, GameState gs, int time) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player pEn = gs.getPlayer(playerEnemy);
        Player pA = gs.getPlayer(player);
        SimpleSqrtEvaluationFunction3 ef = new SimpleSqrtEvaluationFunction3();
        Unit base = null;
        int nWorkers = 0;
        int nBases = 0;
        int nBarracks = 0;
        int nRanged = 0;
        int nLight = 0;
        int nHeavy = 0;
        for (Unit u : pgs.getUnits()) {
            if (u.getType().name.equals("Base") && u.getPlayer() == player && base == null) {
                base = u;
            }
            if (u.getType().name.equals("Base") && u.getPlayer() == playerEnemy) {
                ++nBases;
            }
            if (u.getType().name.equals("Barracks") && u.getPlayer() == playerEnemy) {
                ++nBarracks;
            }
            if (u.getType().name.equals("Worker") && u.getPlayer() == playerEnemy) {
                ++nWorkers;
            }
            if (u.getType().name.equals("Ranged") && u.getPlayer() == playerEnemy) {
                ++nRanged;
            }
            if (u.getType().name.equals("Light") && u.getPlayer() == playerEnemy) {
                ++nLight;
            }
            if (!u.getType().name.equals("Heavy") || u.getPlayer() != playerEnemy) continue;
            ++nHeavy;
        }
        DenseInstance avai = new DenseInstance(10);
        avai.setDataset(this.dataSet);
        avai.setValue(0, (double)nBases);
        avai.setValue(1, (double)nBarracks);
        avai.setValue(2, (double)nWorkers);
        avai.setValue(3, (double)nLight);
        avai.setValue(4, (double)nHeavy);
        avai.setValue(5, (double)nRanged);
        avai.setValue(6, (double)gs.getTime());
        avai.setValue(7, (double)pgs.getWidth());
        if (base == null) {
            avai.setValue(8, -1.0);
        } else {
            avai.setValue(8, (double)this.distRealUnitEneBase(base, pA, gs));
        }
        try {
            this.setNewStrategy(this.getStrategyByDistribution(this.rf.distributionForInstance(avai), pgs.getHeight()));
        }
        catch (Exception ex) {
            Logger.getLogger(SCV.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Erro na classifica\u00e7\u00e3o=" + ex);
        }
    }

    public int distRealUnitEneBase(Unit base, Player p, GameState gs) {
        AStarPathFinding aStar = new AStarPathFinding();
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        int d = 9999;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID() || u2 == null || base == null) continue;
            d = aStar.findDistToPositionInRange(base, u2.getPosition(pgs), 1, gs, gs.getResourceUsage());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy == null) {
            return -1;
        }
        return aStar.findDistToPositionInRange(base, closestEnemy.getPosition(pgs), 1, gs, gs.getResourceUsage());
    }

    public int distUnitEneBase(Unit base, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = Math.abs(u2.getX() - base.getX()) + Math.abs(u2.getY() - base.getY());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        return closestDistance;
    }

    protected String getStrategyByDistribution(double[] distrib, int alturaMapa) {
        String bestStrategy = "POWorkerRush";
        double bestPondValue = -1.0;
        for (String s : this.indice.keySet()) {
            double heavy = 0.0;
            double economy = 0.0;
            double ranged = 0.0;
            double light = 0.0;
            double worker = 0.0;
            block15: for (infBattles i : this.indice.get(s).get(alturaMapa)) {
                switch (i.enemy) {
                    case "POHeavyRush": {
                        heavy = i.ltd3;
                        continue block15;
                    }
                    case "EconomyRush": {
                        economy = i.ltd3;
                        continue block15;
                    }
                    case "PORangedRush": {
                        ranged = i.ltd3;
                        continue block15;
                    }
                    case "POLightRush": {
                        light = i.ltd3;
                        continue block15;
                    }
                    case "POWorkerRush": {
                        worker = i.ltd3;
                        continue block15;
                    }
                }
                System.err.println("Erro na sele\u00e7\u00e3o");
            }
            double pondTemp = (distrib[0] * light + distrib[1] * worker + distrib[2] * ranged + distrib[3] * economy + distrib[4] * heavy) / (distrib[0] + distrib[1] + distrib[2] + distrib[3] + distrib[4]);
            if (!(pondTemp > bestPondValue)) continue;
            bestPondValue = pondTemp;
            bestStrategy = s;
        }
        return bestStrategy;
    }

    protected void setNewStrategy(String BagStrategy) {
        ArrayList<AI> newStrat = new ArrayList<AI>();
        if (BagStrategy.contains("POWorkerRush")) {
            newStrat.add(new POWorkerRush(this.localUtt));
        }
        if (BagStrategy.contains("WorkerRushPlusPlus")) {
            newStrat.add(new WorkerRushPlusPlus(this.localUtt));
        }
        if (BagStrategy.contains("POLightRush")) {
            newStrat.add(new POLightRush(this.localUtt));
        }
        if (BagStrategy.contains("EconomyRush")) {
            newStrat.add(new EconomyRush(this.localUtt));
        }
        if (BagStrategy.contains("RandomBiasedAI")) {
            newStrat.add(new RandomBiasedAI(this.localUtt));
        }
        if (BagStrategy.contains("POHeavyRush")) {
            newStrat.add(new POHeavyRush(this.localUtt));
        }
        if (BagStrategy.contains("PORangedRush")) {
            newStrat.add(new PORangedRush(this.localUtt));
        }
        if (BagStrategy.contains("LightDefense")) {
            newStrat.add(new LightDefense(this.localUtt));
        }
        if (BagStrategy.contains("RangedDefense")) {
            newStrat.add(new RangedDefense(this.localUtt));
        }
        if (BagStrategy.contains("WorkerDefense")) {
            newStrat.add(new WorkerDefense(this.localUtt));
        }
        if (BagStrategy.contains("EconomyMilitaryRush")) {
            newStrat.add(new EconomyMilitaryRush(this.localUtt));
        }
        if (BagStrategy.contains("HeavyDefense")) {
            newStrat.add(new HeavyDefense(this.localUtt));
        }
        this.strategies = new AI[newStrat.size()];
        for (int i = 0; i < newStrat.size(); ++i) {
            this.strategies[i] = (AI)newStrat.get(i);
        }
    }

    protected class infBattles {
        Integer tMapa;
        String enemy;
        String strategy;
        double ltd3;

        protected infBattles() {
        }
    }
}

