/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.socket.SocketAI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class GameVisualSimulationWithSocketAI {
    public static void main(String[] args) throws Exception {
        UnitTypeTable utt = new UnitTypeTable();
        PhysicalGameState pgs = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", utt);
        GameState gs = new GameState(pgs, utt);
        int MAXCYCLES = 5000;
        int PERIOD = 20;
        boolean gameover = false;
        SocketAI ai1 = new SocketAI(100, 0, "127.0.0.1", 9898, 1, utt);
        RandomBiasedAI ai2 = new RandomBiasedAI();
        ((AI)ai1).reset();
        ((AI)ai2).reset();
        PhysicalGameStateJFrame w = PhysicalGameStatePanel.newVisualizer(gs, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
        ((AI)ai1).preGameAnalysis(gs, 1000L, ".");
        ai2.preGameAnalysis(gs, 1000L, ".");
        long nextTimeToUpdate = System.currentTimeMillis() + (long)PERIOD;
        do {
            if (System.currentTimeMillis() >= nextTimeToUpdate) {
                PlayerAction pa1 = ((AI)ai1).getAction(0, gs);
                PlayerAction pa2 = ((AI)ai2).getAction(1, gs);
                gs.issueSafe(pa1);
                gs.issueSafe(pa2);
                gameover = gs.cycle();
                w.repaint();
                nextTimeToUpdate += (long)PERIOD;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (!gameover && gs.getTime() < MAXCYCLES);
        System.out.println("Game Over");
    }
}

