/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.abstraction.WorkerRush;
import ai.core.AIWithComputationBudget;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class JSONSocketWrapperAI {
    public static int DEBUG = 0;

    public static void main(String[] args) throws Exception {
        DEBUG = 1;
        JSONSocketWrapperAI.runServer(new WorkerRush(new UnitTypeTable()), 9898);
    }

    public static void runServer(AIWithComputationBudget ai, int socket) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("JSONSocketWrapperAI server is running.");
        }
        int clientNumber = 0;
        ServerSocket listener = new ServerSocket(socket);
        try {
            while (true) {
                new SocketWrapperAI(listener.accept(), clientNumber++, ai).start();
            }
        }
        catch (Throwable throwable) {
            listener.close();
            throw throwable;
        }
    }

    private static class SocketWrapperAI
    extends Thread {
        Socket socket;
        int clientNumber = 0;
        int time_budget = 100;
        int iterations_budget = 0;
        UnitTypeTable utt;
        AIWithComputationBudget ai;

        public SocketWrapperAI(Socket socket, int clientNumber, AIWithComputationBudget a_ai) {
            this.socket = socket;
            this.clientNumber = clientNumber;
            this.ai = a_ai;
            if (DEBUG >= 1) {
                System.out.println("New connection with client# " + clientNumber + " at " + socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String input;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
                out.println("JSONSocketWrapperAI: you are client #" + this.clientNumber);
                while ((input = in.readLine()) != null) {
                    String[] tokens;
                    if (input.startsWith("end")) {
                        System.exit(0);
                        continue;
                    }
                    if (input.startsWith("budget")) {
                        tokens = input.split(" ");
                        this.time_budget = Integer.parseInt(tokens[1]);
                        this.iterations_budget = Integer.parseInt(tokens[2]);
                        if (DEBUG >= 1) {
                            System.out.println("setting the budget to: " + this.time_budget + ", " + this.iterations_budget);
                        }
                        this.ai.reset();
                        this.ai.setTimeBudget(this.time_budget);
                        this.ai.setIterationsBudget(this.iterations_budget);
                        out.append("ack\n");
                        out.flush();
                        continue;
                    }
                    if (input.startsWith("utt")) {
                        input = in.readLine();
                        if (DEBUG >= 1) {
                            System.out.println("setting the utt to: " + input);
                        }
                        this.utt = UnitTypeTable.fromJSON(input);
                        this.ai.reset(this.utt);
                        out.append("ack\n");
                        out.flush();
                        continue;
                    }
                    if (input.startsWith("getAction")) {
                        tokens = input.split(" ");
                        int player = Integer.parseInt(tokens[1]);
                        if (DEBUG >= 1) {
                            System.out.println("getAction for player " + player);
                        }
                        input = in.readLine();
                        if (DEBUG >= 1) {
                            System.out.println("with game state: " + input);
                        }
                        GameState gs = GameState.fromJSON(input, this.utt);
                        if (DEBUG >= 1) {
                            System.out.println(gs);
                        }
                        PlayerAction pa = this.ai.getAction(player, gs);
                        pa.toJSON(out);
                        out.append("\n");
                        out.flush();
                        if (DEBUG < 1) continue;
                        System.out.println("action sent!");
                        continue;
                    }
                    if (input.startsWith("preGameAnalysis")) {
                        tokens = input.split(" ");
                        int milliseconds = Integer.parseInt(tokens[1]);
                        String readWriteFolder = null;
                        if (tokens.length >= 2 && (readWriteFolder = tokens[2]).startsWith("\"")) {
                            readWriteFolder = readWriteFolder.substring(1, readWriteFolder.length() - 1);
                        }
                        if (DEBUG >= 1) {
                            System.out.println("preGameAnalysis");
                        }
                        input = in.readLine();
                        if (DEBUG >= 1) {
                            System.out.println("with game state: " + input);
                        }
                        GameState gs = GameState.fromJSON(input, this.utt);
                        if (DEBUG >= 1) {
                            System.out.println(gs);
                        }
                        if (readWriteFolder != null) {
                            this.ai.preGameAnalysis(gs, milliseconds, readWriteFolder);
                        } else {
                            this.ai.preGameAnalysis(gs, milliseconds);
                        }
                        out.append("ack\n");
                        out.flush();
                        continue;
                    }
                    if (!input.startsWith("gameOver")) continue;
                    tokens = input.split(" ");
                    int winner = Integer.parseInt(tokens[1]);
                    if (DEBUG >= 1) {
                        System.out.println("gameOver " + winner);
                    }
                    this.ai.gameOver(winner);
                    out.append("ack\n");
                    out.flush();
                }
            }
            catch (Exception e) {
                System.out.println("Error handling client# " + this.clientNumber + ": " + e);
                e.printStackTrace();
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Connection with client# " + this.clientNumber + " closed");
            }
        }
    }
}

