/*
 * Decompiled with CFR 0.152.
 */
package ai.socket;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class SocketAI
extends AIWithComputationBudget {
    public static int DEBUG;
    public static final int LANGUAGE_XML = 1;
    public static final int LANGUAGE_JSON = 2;
    private boolean includeConstants = true;
    private boolean compressTerrain = false;
    UnitTypeTable utt;
    int communication_language = 1;
    String serverAddress = "127.0.0.1";
    int serverPort = 9898;
    Socket socket;
    BufferedReader in_pipe;
    PrintWriter out_pipe;

    public SocketAI(UnitTypeTable a_utt) {
        super(100, -1);
        this.utt = a_utt;
        try {
            this.connectToServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SocketAI(int mt, int mi, String a_sa, int a_port, int a_language, UnitTypeTable a_utt) {
        super(mt, mi);
        this.serverAddress = a_sa;
        this.serverPort = a_port;
        this.communication_language = a_language;
        this.utt = a_utt;
        try {
            this.connectToServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SocketAI(int mt, int mi, UnitTypeTable a_utt, int a_language, boolean includeConstantsInState, boolean compressTerrain, Socket socket) {
        super(mt, mi);
        this.communication_language = a_language;
        this.utt = a_utt;
        this.includeConstants = includeConstantsInState;
        this.compressTerrain = compressTerrain;
        try {
            this.socket = socket;
            this.in_pipe = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.out_pipe = new PrintWriter(socket.getOutputStream(), true);
            while (!this.in_pipe.ready()) {
            }
            while (this.in_pipe.ready()) {
                this.in_pipe.readLine();
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: welcome message received");
            }
            this.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SocketAI createFromExistingSocket(int mt, int mi, UnitTypeTable a_utt, int a_language, boolean includeConstantsInState, boolean compressTerrain, Socket socket) {
        return new SocketAI(mt, mi, a_utt, a_language, includeConstantsInState, compressTerrain, socket);
    }

    public void connectToServer() throws Exception {
        this.socket = new Socket(this.serverAddress, this.serverPort);
        this.in_pipe = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out_pipe = new PrintWriter(this.socket.getOutputStream(), true);
        while (!this.in_pipe.ready()) {
        }
        while (this.in_pipe.ready()) {
            this.in_pipe.readLine();
        }
        if (DEBUG >= 1) {
            System.out.println("SocketAI: welcome message received");
        }
        this.reset();
    }

    @Override
    public void reset() {
        try {
            this.out_pipe.append("budget ").append(String.valueOf(this.TIME_BUDGET)).append(" ").append(String.valueOf(this.ITERATIONS_BUDGET)).append("\n");
            this.out_pipe.flush();
            if (DEBUG >= 1) {
                System.out.println("SocketAI: budget sent, waiting for ack");
            }
            this.in_pipe.readLine();
            while (this.in_pipe.ready()) {
                this.in_pipe.readLine();
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: ack received");
            }
            this.out_pipe.append("utt\n");
            if (this.communication_language == 1) {
                XMLWriter w = new XMLWriter(this.out_pipe, " ");
                this.utt.toxml(w);
                w.flush();
                this.out_pipe.append("\n");
                this.out_pipe.flush();
            } else if (this.communication_language == 2) {
                this.utt.toJSON(this.out_pipe);
                this.out_pipe.append("\n");
                this.out_pipe.flush();
            } else {
                throw new Exception("Communication language " + this.communication_language + " not supported!");
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: UTT sent, waiting for ack");
            }
            this.in_pipe.readLine();
            while (this.in_pipe.ready()) {
                this.in_pipe.readLine();
            }
            if (DEBUG >= 1) {
                System.out.println("SocketAI: ack received");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        this.out_pipe.append("getAction ").append(String.valueOf(player)).append("\n");
        if (this.communication_language == 1) {
            XMLWriter w = new XMLWriter(this.out_pipe, " ");
            gs.toxml(w, this.includeConstants, this.compressTerrain);
            w.getWriter().append("\n");
            w.flush();
            String actionString = this.in_pipe.readLine();
            if (DEBUG >= 1) {
                System.out.println("action received from server: " + actionString);
            }
            Element action_e = new SAXBuilder().build(new StringReader(actionString)).getRootElement();
            PlayerAction pa = PlayerAction.fromXML(action_e, gs, this.utt);
            pa.fillWithNones(gs, player, 10);
            return pa;
        }
        if (this.communication_language == 2) {
            gs.toJSON(this.out_pipe, this.includeConstants, this.compressTerrain);
            this.out_pipe.append("\n");
            this.out_pipe.flush();
            String actionString = this.in_pipe.readLine();
            PlayerAction pa = PlayerAction.fromJSON(actionString, gs, this.utt);
            pa.fillWithNones(gs, player, 10);
            return pa;
        }
        throw new Exception("Communication language " + this.communication_language + " not supported!");
    }

    @Override
    public void preGameAnalysis(GameState gs, long milliseconds) throws Exception {
        this.preGameAnalysis(gs, milliseconds, null);
    }

    @Override
    public void preGameAnalysis(GameState gs, long milliseconds, String readWriteFolder) throws Exception {
        this.out_pipe.append("preGameAnalysis ").append(String.valueOf(milliseconds));
        if (readWriteFolder != null) {
            this.out_pipe.append("  \"").append(readWriteFolder).append("\"");
        }
        this.out_pipe.append("\n");
        switch (this.communication_language) {
            case 1: {
                XMLWriter w = new XMLWriter(this.out_pipe, " ");
                gs.toxml(w);
                w.flush();
                this.out_pipe.append("\n");
                this.out_pipe.flush();
                this.in_pipe.readLine();
                break;
            }
            case 2: {
                gs.toJSON(this.out_pipe);
                this.out_pipe.append("\n");
                this.out_pipe.flush();
                this.in_pipe.readLine();
                break;
            }
            default: {
                throw new Exception("Communication language " + this.communication_language + " not supported!");
            }
        }
    }

    @Override
    public void gameOver(int winner) throws Exception {
        this.out_pipe.append("gameOver ").append(String.valueOf(winner)).append("\n");
        this.out_pipe.flush();
        this.in_pipe.readLine();
    }

    @Override
    public AI clone() {
        return new SocketAI(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.serverAddress, this.serverPort, this.communication_language, this.utt);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> l = new ArrayList<ParameterSpecification>();
        l.add(new ParameterSpecification("Server Address", String.class, "127.0.0.1"));
        l.add(new ParameterSpecification("Server Port", Integer.class, 9898));
        l.add(new ParameterSpecification("Language", Integer.class, 1));
        return l;
    }
}

