/*
 * Decompiled with CFR 0.152.
 */
package ai.stochastic;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.stochastic.UnitActionProbabilityDistribution;
import ai.stochastic.UnitActionTypeConstantDistribution;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Sampler;

public class UnitActionProbabilityDistributionAI
extends AI {
    public static int DEBUG = 0;
    Random r = new Random();
    UnitActionProbabilityDistribution model;
    String modelName = "";
    UnitTypeTable utt;

    public UnitActionProbabilityDistributionAI(UnitTypeTable utt) throws Exception {
        this(new UnitActionTypeConstantDistribution(utt, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), utt, "uniform");
    }

    public UnitActionProbabilityDistributionAI(UnitActionProbabilityDistribution a_model, UnitTypeTable a_utt, String a_modelName) {
        this.model = a_model;
        this.utt = a_utt;
        this.modelName = a_modelName;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.modelName + ")";
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new UnitActionProbabilityDistributionAI(this.model, this.utt, this.modelName);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.getUnitTypeTable() != this.utt) {
            throw new Exception("UnitActionDistributionAI uses a UnitTypeTable different from the one used to play!");
        }
        PhysicalGameState pgs = gs.getPhysicalGameState();
        PlayerAction pa = new PlayerAction();
        if (!gs.canExecuteAnyAction(player)) {
            return pa;
        }
        for (Unit u : pgs.getUnits()) {
            UnitActionAssignment uaa = gs.getActionAssignment(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, pgs);
            pa.getResourceUsage().merge(ru);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            List<UnitAction> l = u.getUnitActions(gs);
            double[] distribution = this.model.predictDistribution(u, gs, l);
            UnitAction none = null;
            for (UnitAction ua : l) {
                if (ua.getType() != 0) continue;
                none = ua;
            }
            try {
                UnitAction ua = l.get(Sampler.weighted(distribution));
                if (ua.resourceUsage(u, pgs).consistentWith(pa.getResourceUsage(), gs)) {
                    ResourceUsage ru = ua.resourceUsage(u, pgs);
                    pa.getResourceUsage().merge(ru);
                    pa.addUnitAction(u, ua);
                    continue;
                }
                pa.addUnitAction(u, none);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                pa.addUnitAction(u, none);
            }
        }
        return pa;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        try {
            parameters.add(new ParameterSpecification("Model", UnitActionProbabilityDistribution.class, new UnitActionTypeConstantDistribution(this.utt, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0})));
            parameters.add(new ParameterSpecification("ModelName", String.class, "uniformDistribution"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parameters;
    }

    public UnitActionProbabilityDistribution getModel() {
        return this.model;
    }

    public void setModel(UnitActionProbabilityDistribution a) {
        this.model = a;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String a) {
        this.modelName = a;
    }
}

