/*
 * Decompiled with CFR 0.152.
 */
package ai.stochastic;

import ai.stochastic.UnitActionProbabilityDistribution;
import java.util.List;
import rts.GameState;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class UnitActionTypeConstantDistribution
extends UnitActionProbabilityDistribution {
    double[] m_distribution;

    public UnitActionTypeConstantDistribution(UnitTypeTable a_utt, double[] distribution) throws Exception {
        super(a_utt);
        if (distribution == null || distribution.length != 6) {
            throw new Exception("distribution does not have the right number of elements!");
        }
        this.m_distribution = distribution;
    }

    @Override
    public double[] predictDistribution(Unit u, GameState gs, List<UnitAction> actions2) throws Exception {
        int i;
        int nActions = actions2.size();
        double[] d = new double[nActions];
        double accum = 0.0;
        for (i = 0; i < nActions; ++i) {
            int type = actions2.get(i).getType();
            d[i] = this.m_distribution[type];
            accum += d[i];
        }
        if (accum <= 0.0) {
            for (i = 0; i < nActions; ++i) {
                d[i] = 1.0 / (double)nActions;
            }
        } else {
            i = 0;
            while (i < nActions) {
                int n = i++;
                d[n] = d[n] / accum;
            }
        }
        return d;
    }
}

